/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.logics;

import forestry.api.core.ICamouflageItemHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.greenhouse.DefaultGreenhouseLogic;
import forestry.api.greenhouse.EnumGreenhouseEventType;
import forestry.api.greenhouse.IGreenhouseClimaLogic;
import forestry.api.multiblock.IGreenhouseController;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.CamouflageAccess;
import forestry.core.utils.CamouflageUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GreenhouseLogicGreenhouseEffect
extends DefaultGreenhouseLogic
implements IGreenhouseClimaLogic {
    private float lightTransmittance;
    private int workTimer;

    public GreenhouseLogicGreenhouseEffect(IGreenhouseController controller) {
        super(controller, "GreenhouseEffect");
    }

    @Override
    public void work() {
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("workTimer", this.workTimer);
        nbt.func_74776_a("lightTransmittance", this.lightTransmittance);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.workTimer = nbt.func_74762_e("workTimer");
        this.lightTransmittance = nbt.func_74760_g("lightTransmittance");
    }

    @Override
    public void onEvent(EnumGreenhouseEventType type, Object event) {
        if (type == EnumGreenhouseEventType.CAMOUFLAGE) {
            if (this.controller == null || !this.controller.isAssembled()) {
                return;
            }
            float lightTransmittance = 0.0f;
            int i = 0;
            World world = this.controller.getWorldObj();
            for (IMultiblockComponent component : this.controller.getComponents()) {
                ItemStack camouflageStack;
                ICamouflageItemHandler handler;
                float camouflageLightTransmittance;
                ICamouflagedTile block;
                if (!(component instanceof ICamouflagedTile) || (block = (ICamouflagedTile)((Object)component)).getCamouflageType() != "glass" || !world.func_175710_j(component.getCoordinates()) || !((camouflageLightTransmittance = (handler = CamouflageAccess.getHandlerFromItem(camouflageStack = CamouflageUtil.getCamouflageBlock((IBlockAccess)world, component.getCoordinates()), this.controller)).getLightTransmittance(camouflageStack, this.controller)) < 1.0f) || !(camouflageLightTransmittance > 0.0f)) continue;
                lightTransmittance += camouflageLightTransmittance;
                ++i;
            }
            if (i != 0) {
                this.lightTransmittance = lightTransmittance / (float)i;
            }
        }
    }
}

