/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.ContainerFiller;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TileBase;
import forestry.factory.gui.ContainerRaintank;
import forestry.factory.gui.GuiRaintank;
import forestry.factory.inventory.InventoryRaintank;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileRaintank
extends TileBase
implements ISidedInventory,
ILiquidTankTile {
    private static final FluidStack STACK_WATER = new FluidStack(FluidRegistry.WATER, 1000);
    private static final FluidStack WATER_PER_UPDATE = new FluidStack(FluidRegistry.WATER, 10);
    @Nonnull
    private final FilteredTank resourceTank;
    @Nonnull
    private final TankManager tankManager;
    @Nonnull
    private final ContainerFiller containerFiller;
    private Boolean canDumpBelow = null;
    private boolean dumpingFluid = false;
    private int fillingProgress;

    public TileRaintank() {
        super("raintank");
        this.setInternalInventory(new InventoryRaintank(this));
        this.resourceTank = new FilteredTank(30000).setFilters(FluidRegistry.WATER);
        this.tankManager = new TankManager(this, this.resourceTank);
        this.containerFiller = new ContainerFiller(this.resourceTank, 12, (IInventory)this, 0, 1);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        if (this.updateOnInterval(20)) {
            IErrorLogic errorLogic = this.getErrorLogic();
            BlockPos pos = this.func_174877_v();
            Biome biome = this.field_145850_b.func_180494_b(pos);
            errorLogic.setCondition(!biome.func_76738_d(), EnumErrorCode.NO_RAIN_BIOME);
            BlockPos posAbove = pos.func_177984_a();
            boolean hasSky = this.field_145850_b.func_175710_j(posAbove);
            errorLogic.setCondition(!hasSky, EnumErrorCode.NO_SKY_RAIN_TANK);
            errorLogic.setCondition(!this.field_145850_b.func_175727_C(posAbove), EnumErrorCode.NOT_RAINING);
            if (!errorLogic.hasErrors()) {
                this.resourceTank.fillInternal(WATER_PER_UPDATE, true);
            }
            this.containerFiller.updateServerSide();
        }
        if (this.canDumpBelow == null) {
            this.canDumpBelow = FluidHelper.canAcceptFluid(this.field_145850_b, this.func_174877_v().func_177977_b(), EnumFacing.UP, STACK_WATER);
        }
        if (this.canDumpBelow.booleanValue() && (this.dumpingFluid || this.updateOnInterval(20))) {
            this.dumpingFluid = this.dumpFluidBelow();
        }
    }

    private boolean dumpFluidBelow() {
        IFluidHandler fluidDestination;
        return !this.resourceTank.isEmpty() && (fluidDestination = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (EnumFacing)EnumFacing.UP)) != null && FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)this.tankManager, (int)50, (boolean)true) != null;
    }

    public boolean isFilling() {
        return this.fillingProgress > 0;
    }

    public int getFillProgressScaled(int i) {
        return this.fillingProgress * i / 12;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingProgress = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, IContainerListener iCrafting) {
        iCrafting.func_71112_a(container, 0, this.containerFiller.getFillingProgress());
    }

    @Override
    @Nonnull
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void onNeighborTileChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborTileChange(world, pos, neighbor);
        if (neighbor.equals((Object)pos.func_177977_b())) {
            this.canDumpBelow = FluidHelper.canAcceptFluid(this.field_145850_b, neighbor, EnumFacing.UP, STACK_WATER);
        }
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankManager);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiRaintank(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerRaintank(player.field_71071_by, this);
    }
}

