package forestry.core.utils;

import mezz.jei.api.IModRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class JeiUtil {
	public static void addDescription(IModRegistry registry, String itemKey, Item... items) {
		for (Item item : items) {
			addDescription(registry, item, itemKey);
		}
	}

	public static void addDescription(IModRegistry registry, Block... blocks) {
		for (Block block : blocks) {
			Item item = Item.func_150898_a(block);
			if (item != null) {
				addDescription(registry, item);
			} else {
				Log.error("No item for block {}", block);
			}
		}
	}

	public static void addDescription(IModRegistry registry, Item... items) {
		for (Item item : items) {
			addDescription(registry, item);
		}
	}

	public static void addDescription(IModRegistry registry, Item item) {
		String resourcePath = item.getRegistryName().func_110623_a();
		addDescription(registry, item, resourcePath);
	}

	public static void addDescription(IModRegistry registry, Item item, String itemKey) {
		ItemStack itemStack = new ItemStack(item, 1, OreDictionary.WILDCARD_VALUE);
		registry.addDescription(itemStack, "for.jei.description." + itemKey);
	}
}
