/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import forestry.energy.EnergyManager;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouse;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class TileGreenhouseGearbox
extends TileGreenhouse
implements IEnergyReceiver,
IEnergyHandler {
    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.getEnergyManager() == null) {
            return 0;
        }
        return this.getEnergyManager().receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        if (this.getEnergyManager() == null) {
            return 0;
        }
        return this.getEnergyManager().getEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        if (this.getEnergyManager() == null) {
            return 0;
        }
        return this.getEnergyManager().getMaxEnergyStored(from);
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.getEnergyManager() != null && this.getEnergyManager().canConnectEnergy(from);
    }

    private EnergyManager getEnergyManager() {
        if (!((MultiblockLogicGreenhouse)this.getMultiblockLogic()).isConnected()) {
            return null;
        }
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getEnergyManager();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        EnergyManager energyManager = this.getEnergyManager();
        if (energyManager != null && energyManager.hasCapability(capability)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        T energyCapability;
        EnergyManager energyManager = this.getEnergyManager();
        if (energyManager != null && (energyCapability = energyManager.getCapability(capability)) != null) {
            return energyCapability;
        }
        return (T)super.getCapability(capability, facing);
    }
}

