/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.blocks;

import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.core.blocks.propertys.UnlistedBlockAccess;
import forestry.core.blocks.propertys.UnlistedBlockPos;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.CamouflageUtil;
import forestry.core.utils.Translator;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.models.GreenhouseDoorStateMapper;
import forestry.greenhouse.tiles.TileGreenhouse;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGreenhouseDoor
extends BlockGreenhouse
implements IStateMapperRegister {
    private static final PropertyDirection FACING = BlockDoor.field_176520_a;
    private static final PropertyBool OPEN = BlockDoor.field_176519_b;
    private static final PropertyEnum<BlockDoor.EnumHingePosition> HINGE = BlockDoor.field_176521_M;
    private static final PropertyBool POWERED = BlockDoor.field_176522_N;
    private static final PropertyEnum<BlockDoor.EnumDoorHalf> HALF = BlockDoor.field_176523_O;
    public static final PropertyBool CAMOUFLAGED = PropertyBool.func_177716_a((String)"camouflaged");
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);

    public BlockGreenhouseDoor() {
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a(HINGE, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a(HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)CAMOUFLAGED, (Comparable)Boolean.valueOf(false)));
    }

    public String func_149732_F() {
        return Translator.translateToLocal((this.func_149739_a() + ".name").replaceAll("tile", "item"));
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return BlockGreenhouseDoor.isOpen(BlockGreenhouseDoor.combineMetadata(worldIn, pos));
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean flag = (Boolean)state.func_177229_b((IProperty)OPEN) == false;
        boolean flag1 = state.func_177229_b(HINGE) == BlockDoor.EnumHingePosition.RIGHT;
        switch (enumfacing) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileGreenhouse)) {
            return false;
        }
        TileGreenhouse door = (TileGreenhouse)tile;
        if (playerIn.func_70093_af() && playerIn.func_184586_b(hand) == null) {
            if (!worldIn.field_72995_K) {
                door.openGui(playerIn);
            }
            return true;
        }
        BlockPos blockpos = state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate = pos.equals((Object)blockpos) ? state : worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() != this) {
            return false;
        }
        state = iblockstate.func_177231_a((IProperty)OPEN);
        worldIn.func_180501_a(blockpos, state, 2);
        worldIn.func_175704_b(blockpos, pos);
        worldIn.func_180498_a(playerIn, (Boolean)state.func_177229_b((IProperty)OPEN) != false ? 1005 : 1011, pos, 0);
        return true;
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockpos = pos.func_177977_b();
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (blockIn != this) {
                iblockstate.func_189546_a(worldIn, blockpos, blockIn);
            }
        } else {
            boolean flag1 = false;
            BlockPos blockpos1 = pos.func_177984_a();
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                flag1 = true;
            }
            if (!worldIn.func_180495_p(pos.func_177977_b()).func_185896_q()) {
                worldIn.func_175698_g(pos);
                flag1 = true;
                if (iblockstate1.func_177230_c() == this) {
                    worldIn.func_175698_g(blockpos1);
                }
            }
            if (flag1) {
                if (!worldIn.field_72995_K) {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
            } else {
                boolean flag;
                boolean bl = flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(blockpos1);
                if (blockIn != this && (flag || blockIn.func_176223_P().func_185897_m()) && flag != (Boolean)iblockstate1.func_177229_b((IProperty)POWERED)) {
                    worldIn.func_180501_a(blockpos1, iblockstate1.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
                    if (flag != (Boolean)state.func_177229_b((IProperty)OPEN)) {
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
                        worldIn.func_175704_b(pos, pos);
                        worldIn.func_180498_a(null, flag ? 1003 : 1006, pos, 0);
                    }
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER ? null : Item.func_150898_a((Block)state.func_177230_c());
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return pos.func_177956_o() < worldIn.func_72800_K() - 1 && worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) && super.func_176196_c(worldIn, pos) && super.func_176196_c(worldIn, pos.func_177984_a());
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    private static int combineMetadata(IBlockAccess worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        int i = iblockstate.func_177230_c().func_176201_c(iblockstate);
        boolean flag = BlockGreenhouseDoor.isTop(i);
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177977_b());
        int j = iblockstate1.func_177230_c().func_176201_c(iblockstate1);
        int k = flag ? j : i;
        IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177984_a());
        int l = iblockstate2.func_177230_c().func_176201_c(iblockstate2);
        int i1 = flag ? i : l;
        boolean flag1 = (i1 & 1) != 0;
        boolean flag2 = (i1 & 2) != 0;
        return BlockGreenhouseDoor.removeHalfBit(k) | (flag ? 8 : 0) | (flag1 ? 16 : 0) | (flag2 ? 32 : 0);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos = pos.func_177977_b();
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER && worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177984_a());
            if (iblockstate.func_177230_c() == this) {
                state = state.func_177226_a(HINGE, iblockstate.func_177229_b(HINGE)).func_177226_a((IProperty)POWERED, iblockstate.func_177229_b((IProperty)POWERED));
            }
        } else {
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177977_b());
            if (iblockstate1.func_177230_c() == this) {
                state = state.func_177226_a((IProperty)FACING, iblockstate1.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)OPEN, iblockstate1.func_177229_b((IProperty)OPEN));
            }
        }
        TileGreenhouse tile = TileUtil.getTile(worldIn, pos, TileGreenhouse.class);
        boolean isCamouflaged = false;
        if (tile != null) {
            ItemStack camouflage = CamouflageUtil.getCamouflageBlock(worldIn, pos);
            isCamouflaged = camouflage != null;
        }
        state = state.func_177226_a((IProperty)CAMOUFLAGED, (Comparable)Boolean.valueOf(isCamouflaged));
        return state;
    }

    public IBlockState func_176203_a(int meta) {
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(HALF, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a(HINGE, (Comparable)((meta & 1) > 0 ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 2) > 0)) : this.func_176223_P().func_177226_a(HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)).func_176735_f()).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER) {
            i |= 8;
            if (state.func_177229_b(HINGE) == BlockDoor.EnumHingePosition.RIGHT) {
                i |= 1;
            }
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                i |= 2;
            }
        } else {
            i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e().func_176736_b();
            if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("forestry:greenhouse.door", "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        Proxies.render.registerStateMapper(this, new GreenhouseDoorStateMapper());
    }

    protected static int removeHalfBit(int meta) {
        return meta & 7;
    }

    public static boolean isOpen(IBlockAccess worldIn, BlockPos pos) {
        return BlockGreenhouseDoor.isOpen(BlockGreenhouseDoor.combineMetadata(worldIn, pos));
    }

    public static EnumFacing getFacing(IBlockAccess worldIn, BlockPos pos) {
        return BlockGreenhouseDoor.getFacing(BlockGreenhouseDoor.combineMetadata(worldIn, pos));
    }

    public static EnumFacing getFacing(int combinedMeta) {
        return EnumFacing.func_176731_b((int)(combinedMeta & 3)).func_176735_f();
    }

    protected static boolean isOpen(int combinedMeta) {
        return (combinedMeta & 4) != 0;
    }

    protected static boolean isTop(int meta) {
        return (meta & 8) != 0;
    }

    protected static boolean isHingeLeft(int combinedMeta) {
        return (combinedMeta & 0x10) != 0;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{HALF, FACING, OPEN, HINGE, POWERED, CAMOUFLAGED}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
    }

    @Override
    @Nonnull
    public BlockGreenhouseType getGreenhouseType() {
        return BlockGreenhouseType.DOOR;
    }
}

