/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.moistener;

import forestry.api.recipes.IMoistenerRecipe;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.render.ForestryResource;
import forestry.factory.recipes.jei.moistener.MoistenerRecipeWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;

public class MoistenerRecipeCategory
extends ForestryRecipeCategory {
    private static final int resourceSlot = 0;
    private static final int productSlot = 1;
    private static final int fuelItemSlot = 2;
    private static final int fuelProductSlot = 3;
    private static final int inputTank = 0;
    private static final ResourceLocation guiTexture = new ForestryResource("textures/gui/moistener.png");
    @Nonnull
    private final IDrawableAnimated arrow;
    @Nonnull
    private final IDrawableAnimated progressBar;
    @Nonnull
    private final IDrawable tankOverlay;

    public MoistenerRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(guiTexture, 15, 15, 145, 60), "tile.for.moistener.name");
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(guiTexture, 176, 91, 29, 55);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 80, IDrawableAnimated.StartDirection.BOTTOM, false);
        IDrawableStatic progressBar = guiHelper.createDrawable(guiTexture, 176, 74, 16, 15);
        this.progressBar = guiHelper.createAnimatedDrawable(progressBar, 160, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = guiHelper.createDrawable(guiTexture, 176, 0, 16, 58);
    }

    @Nonnull
    public String getUid() {
        return "forestry.moistener";
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, 78, 2);
        this.progressBar.draw(minecraft, 109, 22);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 127, 3);
        guiItemStacks.init(2, true, 23, 42);
        guiItemStacks.init(1, false, 127, 39);
        guiItemStacks.init(3, false, 89, 21);
        guiFluidStacks.init(0, true, 1, 1, 16, 58, 10000, false, this.tankOverlay);
        MoistenerRecipeWrapper wrapper = (MoistenerRecipeWrapper)recipeWrapper;
        guiItemStacks.set(0, ((IMoistenerRecipe)wrapper.getRecipe()).getResource());
        guiItemStacks.set(2, wrapper.getFuel().getItem());
        guiItemStacks.set(1, ((IMoistenerRecipe)wrapper.getRecipe()).getProduct());
        guiItemStacks.set(3, wrapper.getFuel().getProduct());
        guiFluidStacks.set(0, FluidRegistry.getFluidStack((String)"water", (int)10000));
    }
}

