/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.arboriculture;

import com.google.common.collect.ImmutableMap;
import forestry.api.arboriculture.IWoodType;
import java.util.Locale;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelProcessingHelper;

public enum WoodBlockKind {
    LOG,
    PLANKS,
    SLAB,
    FENCE,
    FENCE_GATE,
    STAIRS,
    DOOR(false);

    public final boolean retextureItem;

    private WoodBlockKind() {
        this(true);
    }

    private WoodBlockKind(boolean retextureItem) {
        this.retextureItem = retextureItem;
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    public IModel retextureModel(IModel model, IWoodType type) {
        ImmutableMap.Builder textures = new ImmutableMap.Builder();
        switch (this) {
            case SLAB: 
            case STAIRS: {
                String textureLocation = type.getPlankTexture();
                textures.put((Object)"particle", (Object)textureLocation);
                textures.put((Object)"side", (Object)textureLocation);
                textures.put((Object)"top", (Object)textureLocation);
                textures.put((Object)"bottom", (Object)textureLocation);
                textures.put((Object)"all", (Object)textureLocation);
                break;
            }
            case PLANKS: {
                textures.put((Object)"particle", (Object)type.getPlankTexture());
                textures.put((Object)"all", (Object)type.getPlankTexture());
                break;
            }
            case FENCE_GATE: 
            case FENCE: {
                textures.put((Object)"particle", (Object)type.getPlankTexture());
                textures.put((Object)"side", (Object)type.getPlankTexture());
                textures.put((Object)"texture", (Object)type.getPlankTexture());
                break;
            }
            case DOOR: {
                textures.put((Object)"particle", (Object)type.getDoorLowerTexture());
                textures.put((Object)"bottom", (Object)type.getDoorLowerTexture());
                textures.put((Object)"top", (Object)type.getDoorUpperTexture());
                break;
            }
            case LOG: {
                textures.put((Object)"particle", (Object)type.getBarkTexture());
                textures.put((Object)"side", (Object)type.getBarkTexture());
                textures.put((Object)"all", (Object)type.getBarkTexture());
                textures.put((Object)"end", (Object)type.getHeartTexture());
                break;
            }
        }
        return ModelProcessingHelper.retexture((IModel)model, (ImmutableMap)textures.build());
    }
}

