/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import forestry.api.core.climate.IClimatePosition;
import forestry.api.core.climate.IClimateRegion;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.apiculture.network.packets.PacketActiveUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IActivatable;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouse;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class TileGreenhouseClimatiser
extends TileGreenhouse
implements IActivatable,
IGreenhouseComponent.Climatiser {
    protected static final int WORK_CYCLES = 1;
    protected static final int ENERGY_PER_OPERATION = 150;
    private final IClimitiserDefinition definition;
    protected EnumFacing inwards;
    protected EnumFacing leftwards;
    protected BlockPos maxPos;
    protected BlockPos minPos;
    protected int workingTime = 0;
    private boolean active;

    protected TileGreenhouseClimatiser(IClimitiserDefinition definition) {
        this.definition = definition;
    }

    @Override
    public void onMachineBroken() {
        this.inwards = null;
        this.leftwards = null;
        this.minPos = null;
        this.maxPos = null;
    }

    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
        this.recalculateDirections(minCoord, maxCoord);
        if (this.leftwards != null) {
            this.maxPos = this.func_174877_v().func_177967_a(this.inwards, this.definition.getClimitiseRange() / 2).func_177967_a(this.leftwards, this.definition.getClimitiseRange() / 2).func_177967_a(EnumFacing.UP, this.definition.getClimitiseRange() / 2);
            this.minPos = this.func_174877_v().func_177972_a(this.inwards).func_177967_a(this.leftwards.func_176734_d(), this.definition.getClimitiseRange() / 2).func_177967_a(EnumFacing.DOWN, this.definition.getClimitiseRange() / 2);
        } else {
            this.maxPos = this.func_174877_v().func_177967_a(this.inwards, this.definition.getClimitiseRange() / 2).func_177967_a(EnumFacing.EAST, this.definition.getClimitiseRange() / 2).func_177967_a(EnumFacing.NORTH, this.definition.getClimitiseRange() / 2);
            this.minPos = this.func_174877_v().func_177972_a(this.inwards).func_177967_a(EnumFacing.WEST, this.definition.getClimitiseRange() / 2).func_177967_a(EnumFacing.SOUTH, this.definition.getClimitiseRange() / 2);
        }
    }

    @Override
    public int getTicksForChange(IClimateRegion region) {
        return 20;
    }

    @Override
    public void changeClimate(int tick, IClimateRegion region) {
        IGreenhouseControllerInternal controller = ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController();
        if (((MultiblockLogicGreenhouse)this.getMultiblockLogic()).isConnected() && controller != null && controller.isAssembled() && this.minPos != null && this.maxPos != null && region != null) {
            IGreenhouseControllerInternal greenhouseInternal = controller;
            boolean canWork = true;
            for (IGreenhouseComponent.Listener listenerComponent : greenhouseInternal.getListenerComponents()) {
                if (!canWork) continue;
                canWork = listenerComponent.getGreenhouseListener().canWork(greenhouseInternal, canWork);
            }
            if (canWork && this.workingTime == 0 && greenhouseInternal.getEnergyManager().consumeEnergyToDoWork(1, 150)) {
                int dimensionID = this.field_145850_b.field_73011_w.getDimension();
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.maxPos, (BlockPos)this.minPos)) {
                    int maxDistance;
                    double distance;
                    IClimatePosition position = region.getPositions().get(pos);
                    if (position == null) continue;
                    if (this.definition.getType() == ClimitiserType.TEMPERATURE) {
                        if (this.definition.isPositiv()) {
                            if (position.getTemperature() >= 2.0f) {
                                if (!(position.getTemperature() > 2.0f)) continue;
                                position.setTemperature(2.0f);
                                continue;
                            }
                        } else if (position.getTemperature() <= 0.0f) {
                            if (!(position.getTemperature() < 0.0f)) continue;
                            position.setTemperature(0.0f);
                            continue;
                        }
                    } else if (this.definition.isPositiv()) {
                        if (position.getHumidity() >= 2.0f) {
                            if (!(position.getHumidity() > 2.0f)) continue;
                            position.setHumidity(2.0f);
                            continue;
                        }
                    } else if (position.getHumidity() <= 0.0f) {
                        if (!(position.getHumidity() < 0.0f)) continue;
                        position.setHumidity(0.0f);
                        continue;
                    }
                    if (!((distance = pos.func_177951_i((Vec3i)this.field_174879_c)) <= (double)(maxDistance = this.definition.getClimitiseRange()))) continue;
                    if (this.definition.getType() == ClimitiserType.TEMPERATURE) {
                        position.addTemperature((float)(this.definition.isPositiv() ? 1 : -1) * (distance == 0.0 ? this.definition.getChange() : (float)((double)this.definition.getChange() / distance)));
                        continue;
                    }
                    position.addHumidity((float)(this.definition.isPositiv() ? 1 : -1) * (distance == 0.0 ? this.definition.getChange() : (float)((double)this.definition.getChange() / distance)));
                }
                this.workingTime += 6;
            }
            if (this.workingTime > 0) {
                --this.workingTime;
            }
            this.setActive(this.workingTime > 0);
        } else if (this.isActive()) {
            this.setActive(false);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.workingTime = nbttagcompound.func_74762_e("Heating");
        this.setActive(this.workingTime > 0);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("Heating", this.workingTime);
        return nbttagcompound;
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.func_74757_a("Active", this.active);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        this.setActive(packetData.func_74767_n("Active"));
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void recalculateDirections(BlockPos minCoord, BlockPos maxCoord) {
        this.inwards = null;
        this.leftwards = null;
        int facesMatching = 0;
        if (maxCoord.func_177958_n() == this.func_174877_v().func_177958_n() || minCoord.func_177958_n() == this.func_174877_v().func_177958_n()) {
            ++facesMatching;
        }
        if (maxCoord.func_177956_o() == this.func_174877_v().func_177956_o() || minCoord.func_177956_o() == this.func_174877_v().func_177956_o()) {
            ++facesMatching;
        }
        if (maxCoord.func_177952_p() == this.func_174877_v().func_177952_p() || minCoord.func_177952_p() == this.func_174877_v().func_177952_p()) {
            ++facesMatching;
        }
        if (facesMatching == 1) {
            if (maxCoord.func_177958_n() == this.func_174877_v().func_177958_n()) {
                this.inwards = EnumFacing.WEST;
                this.leftwards = EnumFacing.SOUTH;
            } else if (minCoord.func_177958_n() == this.func_174877_v().func_177958_n()) {
                this.inwards = EnumFacing.EAST;
                this.leftwards = EnumFacing.NORTH;
            } else if (maxCoord.func_177952_p() == this.func_174877_v().func_177952_p()) {
                this.inwards = EnumFacing.NORTH;
                this.leftwards = EnumFacing.WEST;
            } else if (minCoord.func_177952_p() == this.func_174877_v().func_177952_p()) {
                this.inwards = EnumFacing.SOUTH;
                this.leftwards = EnumFacing.EAST;
            } else {
                this.inwards = maxCoord.func_177956_o() == this.func_174877_v().func_177956_o() ? EnumFacing.DOWN : EnumFacing.UP;
            }
        } else {
            this.inwards = EnumFacing.DOWN;
        }
    }

    public IClimitiserDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            } else {
                Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this), this.field_145850_b);
            }
        }
    }

    protected static interface IClimitiserDefinition {
        public float getChange();

        public boolean isPositiv();

        public int getClimitiseRange();

        public ClimitiserType getType();
    }

    protected static enum ClimitiserType {
        TEMPERATURE,
        HUMIDITY;

    }
}

