/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.core.IClimateProvider;
import forestry.api.core.climate.IClimateManager;
import forestry.api.core.climate.IClimatePosition;
import forestry.api.core.climate.IClimateRegion;
import forestry.api.core.climate.IClimateSource;
import forestry.core.DefaultClimateProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class ClimateManager
implements IClimateManager {
    protected Map<Integer, List<IClimateRegion>> regions = new HashMap<Integer, List<IClimateRegion>>();
    protected Map<Integer, Map<BlockPos, IClimateSource>> sources = new HashMap<Integer, Map<BlockPos, IClimateSource>>();
    private final Object regionsMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegion(IClimateRegion region) {
        if (region == null) {
            return;
        }
        List<IClimateRegion> regions = this.regions.get(region.getWorld().field_73011_w.getDimension());
        Object object = this.regionsMutex;
        synchronized (object) {
            if (!regions.contains(region)) {
                for (BlockPos pos : region.getPositions().keySet()) {
                    if (this.getRegionForPos(region.getWorld(), pos) == null) continue;
                    return;
                }
                regions.add(region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegion(IClimateRegion region) {
        if (region == null) {
            return;
        }
        Object object = this.regionsMutex;
        synchronized (object) {
            List<IClimateRegion> regions = this.regions.get(region.getWorld().field_73011_w.getDimension());
            if (regions.contains(region)) {
                regions.remove(region);
            }
        }
    }

    @Override
    public void removeSource(IClimateSource source) {
        Integer dimensionID = source.getWorld().field_73011_w.getDimension();
        if (!this.sources.containsKey(dimensionID)) {
            this.sources.put(dimensionID, new HashMap());
        }
        if (this.sources.get(dimensionID).keySet().contains(source.getPos())) {
            this.sources.get(dimensionID).remove(source.getPos(), source);
        }
    }

    @Override
    public void addSource(IClimateSource source) {
        Integer dimensionID = source.getWorld().field_73011_w.getDimension();
        if (!this.sources.containsKey(dimensionID)) {
            this.sources.put(dimensionID, new HashMap());
        }
        if (this.sources.get(dimensionID).get(source.getPos()) == null) {
            this.sources.get(dimensionID).put(source.getPos(), source);
        }
    }

    @Override
    public float getTemperature(World world, BlockPos pos) {
        IClimatePosition position;
        Biome biome = world.func_180494_b(pos);
        IClimateRegion region = this.getRegionForPos(world, pos);
        if (region != null && (position = region.getPositions().get(pos)) != null) {
            return position.getTemperature();
        }
        return biome.func_185353_n();
    }

    @Override
    public float getHumidity(World world, BlockPos pos) {
        IClimatePosition position;
        Biome biome = world.func_180494_b(pos);
        IClimateRegion region = this.getRegionForPos(world, pos);
        if (region != null && (position = region.getPositions().get(pos)) != null) {
            return position.getHumidity();
        }
        return biome.func_76727_i();
    }

    @Override
    public Map<Integer, List<IClimateRegion>> getRegions() {
        return this.regions;
    }

    @Override
    public IClimateRegion getRegionForPos(World world, BlockPos pos) {
        Integer dimensionID = world.field_73011_w.getDimension();
        if (!this.regions.containsKey(dimensionID)) {
            this.regions.put(dimensionID, new ArrayList());
        }
        List<IClimateRegion> regions = this.regions.get(dimensionID);
        for (IClimateRegion region : regions) {
            if (region.getPositions().keySet().contains(pos)) {
                return region;
            }
            if (!region.getOtherPositions().contains(pos)) continue;
            return region;
        }
        return null;
    }

    @Override
    public Map<Integer, Map<BlockPos, IClimateSource>> getSources() {
        return this.sources;
    }

    @Override
    public IClimateProvider getDefaultClimate(World world, BlockPos pos) {
        return new DefaultClimateProvider(world, pos);
    }
}

