/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WoodTextures {
    public static final Gson GSON = new GsonBuilder().create();
    protected static final Map<String, Texture> textures = new HashMap<String, Texture>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deserializeFile(IResourceManager resourceManager) {
        block10: {
            try {
                InputStream stream = resourceManager.func_110536_a(new ResourceLocation("forestry:textures/woodTextures.json")).func_110527_b();
                if (stream == null) break block10;
                try (JsonReader reader = null;){
                    reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(stream)));
                    JsonElement json = Streams.parse((JsonReader)reader);
                    if (json.isJsonObject()) {
                        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                            JsonElement ele = (JsonElement)entry.getValue();
                            if (ele.isJsonObject()) {
                                textures.put((String)entry.getKey(), WoodTextures.loadTexture(ele.getAsJsonObject()));
                                continue;
                            }
                            if (!ele.isJsonArray()) continue;
                            ImmutableMap.Builder locations = new ImmutableMap.Builder();
                            for (JsonElement eleEntry : ele.getAsJsonArray()) {
                                JsonObject obj;
                                if (!eleEntry.isJsonObject() || !(obj = eleEntry.getAsJsonObject()).has("kind") || !obj.get("kind").isJsonPrimitive() || !obj.get("kind").getAsJsonPrimitive().isString()) continue;
                                String kind = obj.get("kind").getAsString();
                                locations.put((Object)kind, (Object)WoodTextures.loadTexture(obj));
                            }
                            textures.put((String)entry.getKey(), new KindTexture((ImmutableMap<String, SimpleTexture>)locations.build()));
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static SimpleTexture loadTexture(JsonObject obj) {
        ImmutableMap.Builder locations = new ImmutableMap.Builder();
        for (Map.Entry eleEntry : obj.entrySet()) {
            JsonElement e = (JsonElement)eleEntry.getValue();
            if (!e.isJsonPrimitive() || !e.getAsJsonPrimitive().isString()) continue;
            locations.put(eleEntry.getKey(), (Object)e.getAsString());
        }
        return new SimpleTexture((ImmutableMap<String, String>)locations.build());
    }

    public static ImmutableMap<String, String> getLocations(IWoodType woodType, WoodBlockKind blockKind) {
        if (woodType != null && blockKind != null && woodType.func_176610_l() != null) {
            String kindName = blockKind.toString();
            Texture kindTex = textures.get((Object)blockKind);
            Texture tex = textures.get(woodType.func_176610_l().toLowerCase(Locale.ENGLISH));
            HashMap<String, String> locations = new HashMap<String, String>();
            if (kindTex != null && kindTex instanceof SimpleTexture) {
                locations.putAll((Map<String, String>)((SimpleTexture)kindTex).locations);
            }
            if (tex != null) {
                if (tex instanceof SimpleTexture) {
                    locations.putAll((Map<String, String>)((SimpleTexture)tex).locations);
                } else {
                    SimpleTexture kind = (SimpleTexture)((KindTexture)tex).kindLocations.get((Object)kindName);
                    locations.putAll((Map<String, String>)kind.locations);
                }
            }
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Map.Entry location : locations.entrySet()) {
                String texture = (String)location.getValue();
                if (texture.equals("plank")) {
                    texture = woodType.getPlankTexture();
                } else if (texture.equals("bark")) {
                    texture = woodType.getBarkTexture();
                } else if (texture.equals("heart")) {
                    texture = woodType.getHeartTexture();
                } else if (texture.equals("doorUp")) {
                    texture = woodType.getDoorUpperTexture();
                } else if (texture.equals("doorLow")) {
                    texture = woodType.getDoorLowerTexture();
                } else {
                    builder.put(location.getKey(), (Object)texture.replace("%woodType", woodType.func_176610_l().toLowerCase(Locale.ENGLISH)));
                    continue;
                }
                builder.put(location.getKey(), (Object)texture);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    private static class KindTexture
    extends Texture {
        public final ImmutableMap<String, SimpleTexture> kindLocations;

        public KindTexture(ImmutableMap<String, SimpleTexture> kindLocations) {
            this.kindLocations = kindLocations;
        }
    }

    private static class SimpleTexture
    extends Texture {
        public final ImmutableMap<String, String> locations;

        public SimpleTexture(ImmutableMap<String, String> locations) {
            this.locations = locations;
        }
    }

    private static class Texture {
        private Texture() {
        }
    }
}

