/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ICamouflagedTile;
import forestry.api.core.climate.IClimatePosition;
import forestry.api.core.climate.IClimateRegion;
import forestry.api.core.climate.IClimateSource;
import forestry.api.greenhouse.EnumGreenhouseEventType;
import forestry.api.greenhouse.GreenhouseEvents;
import forestry.api.greenhouse.GreenhouseManager;
import forestry.api.greenhouse.IGreenhouseLogic;
import forestry.api.greenhouse.IInternalBlock;
import forestry.api.greenhouse.IInternalBlockFace;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IGreenhouseController;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.climate.ClimatePosition;
import forestry.core.climate.ClimateRoom;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.RectangularMultiblockControllerBase;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.utils.CamouflageUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.energy.EnergyManager;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.inventory.InventoryGreenhouse;
import forestry.greenhouse.multiblock.GreenhouseMultiblockSizeLimits;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.InternalBlock;
import forestry.greenhouse.network.packets.PacketCamouflageUpdate;
import forestry.greenhouse.tiles.TileGreenhouseSprinkler;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GreenhouseController
extends RectangularMultiblockControllerBase
implements IGreenhouseControllerInternal,
ILiquidTankTile {
    private final Set<IInternalBlock> internalBlocks = new HashSet<IInternalBlock>();
    private final Set<IGreenhouseComponent.Listener> listenerComponents = new HashSet<IGreenhouseComponent.Listener>();
    private final Set<IGreenhouseComponent.Active> activeComponents = new HashSet<IGreenhouseComponent.Active>();
    private final List<IGreenhouseLogic> logics = new ArrayList<IGreenhouseLogic>();
    private final TankManager tankManager;
    private final StandardTank resourceTank = new FilteredTank(10000).setFilters(FluidRegistry.WATER);
    private final EnergyManager energyManager;
    private final InventoryGreenhouse inventory;
    private final boolean needRenderUpdate = false;
    private ItemStack camouflagePlainBlock;
    private ItemStack camouflageGlassBlock;
    private ItemStack camouflageDoorBlock;
    private ClimateRoom region;

    public GreenhouseController(World world) {
        super(world, GreenhouseMultiblockSizeLimits.instance);
        this.tankManager = new TankManager(this, this.resourceTank);
        this.energyManager = new EnergyManager(200, 100000);
        this.inventory = new InventoryGreenhouse(this);
        this.camouflagePlainBlock = this.getDefaultCamouflageBlock("default");
        this.camouflageGlassBlock = this.getDefaultCamouflageBlock("glass");
        this.camouflageDoorBlock = this.getDefaultCamouflageBlock("door");
    }

    @Override
    public EnumTemperature getTemperature() {
        BlockPos coords = this.getReferenceCoord();
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        int dimensionID = this.worldObj.field_73011_w.getDimension();
        float temperature = 0.0f;
        int positions = 0;
        for (IInternalBlock internalBlock : this.internalBlocks) {
            IClimatePosition position = this.region.getPositions().get(internalBlock.getPos());
            if (position == null) continue;
            ++positions;
            temperature += position.getTemperature();
        }
        return temperature / (float)positions;
    }

    @Override
    public float getExactHumidity() {
        int dimensionID = this.worldObj.field_73011_w.getDimension();
        float humidity = 0.0f;
        int positions = 0;
        for (IInternalBlock internalBlock : this.internalBlocks) {
            IClimatePosition position = this.region.getPositions().get(internalBlock.getPos());
            if (position == null) continue;
            ++positions;
            humidity += position.getHumidity();
        }
        return humidity / (float)positions;
    }

    @Override
    public String getUnlocalizedType() {
        return "for.multiblock.greenhouse.type";
    }

    @Override
    public BlockPos getCoordinates() {
        BlockPos coord = this.getReferenceCoord();
        return new BlockPos((Vec3i)coord);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data = super.writeToNBT(data);
        this.tankManager.writeToNBT(data);
        this.energyManager.writeToNBT(data);
        this.inventory.writeToNBT(data);
        CamouflageUtil.writeCamouflageBlockToNBT(data, this, "default");
        CamouflageUtil.writeCamouflageBlockToNBT(data, this, "glass");
        CamouflageUtil.writeCamouflageBlockToNBT(data, this, "door");
        for (IGreenhouseLogic logic : this.getLogics()) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            logic.writeToNBT(nbtTag);
            data.func_74782_a("logic" + logic.getName(), (NBTBase)nbtTag);
        }
        if (this.region != null) {
            data.func_74782_a("Region", (NBTBase)this.region.writeToNBT(new NBTTagCompound()));
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.tankManager.readFromNBT(data);
        this.energyManager.readFromNBT(data);
        this.inventory.readFromNBT(data);
        CamouflageUtil.readCamouflageBlockFromNBT(data, this, "default");
        CamouflageUtil.readCamouflageBlockFromNBT(data, this, "glass");
        CamouflageUtil.readCamouflageBlockFromNBT(data, this, "door");
        if (this.logics.isEmpty()) {
            this.createLogics();
        }
        for (IGreenhouseLogic logic : this.getLogics()) {
            logic.readFromNBT(data.func_74775_l("logic" + logic.getName()));
        }
        if (data.func_74764_b("Region")) {
            NBTTagCompound nbtTag = data.func_74775_l("Region");
            this.region = new ClimateRoom(this, nbtTag);
        }
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        this.writeToNBT(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    protected void onAttachedPartWithMultiblockData(IMultiblockComponent part, NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        this.tankManager.writeData(data);
        this.energyManager.writeData(data);
        this.inventory.writeData(data);
        CamouflageUtil.writeCamouflageBlockToData(data, this, "default");
        CamouflageUtil.writeCamouflageBlockToData(data, this, "glass");
        CamouflageUtil.writeCamouflageBlockToData(data, this, "door");
        if (this.region != null) {
            data.writeBoolean(true);
            this.region.writeData(data);
        } else {
            data.writeBoolean(false);
        }
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.tankManager.readData(data);
        this.energyManager.readData(data);
        this.inventory.readData(data);
        CamouflageUtil.readCamouflageBlockFromData(data, this);
        CamouflageUtil.readCamouflageBlockFromData(data, this);
        CamouflageUtil.readCamouflageBlockFromData(data, this);
        if (data.readBoolean()) {
            this.region.readData(data);
        }
    }

    @Override
    public boolean canHandleType(String type) {
        return type.equals("default") || type.equals("glass") || type.equals("door");
    }

    @Override
    public void setCamouflageBlock(String type, ItemStack camouflageBlock) {
        ItemStack oldCamouflageBlock;
        switch (type) {
            case "default": {
                oldCamouflageBlock = this.camouflagePlainBlock;
                break;
            }
            case "glass": {
                oldCamouflageBlock = this.camouflageGlassBlock;
                break;
            }
            case "door": {
                oldCamouflageBlock = this.camouflageDoorBlock;
                break;
            }
            default: {
                return;
            }
        }
        if (!ItemStackUtil.isIdenticalItem(camouflageBlock, oldCamouflageBlock)) {
            switch (type) {
                case "default": {
                    this.camouflagePlainBlock = camouflageBlock;
                    break;
                }
                case "glass": {
                    this.camouflageGlassBlock = camouflageBlock;
                    break;
                }
                case "door": {
                    this.camouflageDoorBlock = camouflageBlock;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.worldObj != null && this.worldObj.field_72995_K) {
                Proxies.net.sendToServer(new PacketCamouflageUpdate(this, type, true));
                for (IMultiblockComponent comp : this.connectedParts) {
                    ICamouflagedTile camBlock;
                    if (!(comp instanceof ICamouflagedTile) || (camBlock = (ICamouflagedTile)((Object)comp)).getCamouflageType() != type) continue;
                    this.worldObj.func_175704_b(camBlock.getCoordinates(), camBlock.getCoordinates());
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new GreenhouseEvents.CamouflageChangeEvent(this, null, this, type));
        }
    }

    @Override
    public ItemStack getCamouflageBlock(String type) {
        switch (type) {
            case "default": {
                return this.camouflagePlainBlock;
            }
            case "glass": {
                return this.camouflageGlassBlock;
            }
            case "door": {
                return this.camouflageDoorBlock;
            }
        }
        return null;
    }

    @Override
    public ItemStack getDefaultCamouflageBlock(String type) {
        switch (type) {
            case "default": {
                return new ItemStack(Blocks.field_150336_V);
            }
            case "glass": {
                return new ItemStack((Block)Blocks.field_150399_cn, 1, 13);
            }
            case "door": {
                return null;
            }
        }
        return null;
    }

    @Override
    public void onChange(EnumGreenhouseEventType type, Object event) {
        for (IGreenhouseLogic logic : this.logics) {
            logic.onEvent(type, event);
        }
    }

    private void createLogics() {
        this.logics.clear();
        for (Class<? extends IGreenhouseLogic> logicClass : GreenhouseManager.greenhouseHelper.getGreenhouseLogics()) {
            IGreenhouseLogic logic = this.createLogic(logicClass);
            if (logic == null) continue;
            this.logics.add(logic);
        }
    }

    private IGreenhouseLogic createLogic(Class<? extends IGreenhouseLogic> logicClass) {
        try {
            return logicClass.getConstructor(IGreenhouseController.class).newInstance(this);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Log.error("Fail to create a greenhouse logic with the class: {}", logicClass, e);
            return null;
        }
    }

    @Override
    public List<IGreenhouseLogic> getLogics() {
        return this.logics;
    }

    @Override
    @Nonnull
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    @Override
    @Nonnull
    public IInventoryAdapter getInternalInventory() {
        if (this.isAssembled()) {
            return this.inventory;
        }
        return FakeInventoryAdapter.instance();
    }

    @Override
    protected void onMachineAssembled() {
        super.onMachineAssembled();
        this.createLogics();
        if (this.region != null) {
            HashMap<BlockPos, IClimatePosition> internalPositions = new HashMap<BlockPos, IClimatePosition>();
            ArrayList<BlockPos> wallPositions = new ArrayList<BlockPos>();
            for (IMultiblockComponent comp : this.connectedParts) {
                if (comp == null) continue;
                wallPositions.add(comp.getCoordinates());
            }
            for (IInternalBlock block : this.internalBlocks) {
                if (block == null) continue;
                internalPositions.put(block.getPos(), new ClimatePosition(this.region, block.getPos()));
            }
            ForestryAPI.climateManager.removeRegion(this.region);
            this.region = new ClimateRoom(this.region, internalPositions, wallPositions);
            ForestryAPI.climateManager.addRegion(this.region);
        } else {
            HashMap<BlockPos, IClimatePosition> internalPositions = new HashMap<BlockPos, IClimatePosition>();
            ArrayList<BlockPos> wallPositions = new ArrayList<BlockPos>();
            for (IMultiblockComponent comp : this.connectedParts) {
                if (comp == null) continue;
                wallPositions.add(comp.getCoordinates());
            }
            this.region = new ClimateRoom(this, internalPositions, wallPositions);
            for (IInternalBlock block : this.internalBlocks) {
                if (block == null) continue;
                internalPositions.put(block.getPos(), new ClimatePosition(this.region, block.getPos()));
            }
            ForestryAPI.climateManager.addRegion(this.region);
        }
    }

    @Override
    protected void onMachineDisassembled() {
        super.onMachineDisassembled();
        this.internalBlocks.clear();
        this.logics.clear();
    }

    @Override
    protected void onBlockAdded(IMultiblockComponent newPart) {
        if (newPart instanceof IGreenhouseComponent.Listener) {
            this.listenerComponents.add((IGreenhouseComponent.Listener)newPart);
        } else if (newPart instanceof IGreenhouseComponent.Climatiser) {
            ForestryAPI.climateManager.addSource((IClimateSource)((Object)newPart));
        } else if (newPart instanceof IGreenhouseComponent.Active) {
            this.activeComponents.add((IGreenhouseComponent.Active)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockComponent oldPart) {
        if (oldPart instanceof IGreenhouseComponent.Listener) {
            this.listenerComponents.remove(oldPart);
        } else if (oldPart instanceof IGreenhouseComponent.Climatiser) {
            ForestryAPI.climateManager.removeSource((IClimateSource)((Object)oldPart));
        } else if (oldPart instanceof IGreenhouseComponent.Active) {
            this.activeComponents.remove(oldPart);
        }
    }

    @Override
    protected void onAssimilate(IMultiblockControllerInternal assimilated) {
        if (assimilated != null && ((IGreenhouseControllerInternal)assimilated).getRegion() != null) {
            IGreenhouseControllerInternal internal = (IGreenhouseControllerInternal)assimilated;
            if (this.region != null) {
                ForestryAPI.climateManager.removeRegion(this.region);
                ArrayList<BlockPos> wallPositions = new ArrayList<BlockPos>();
                for (IMultiblockComponent comp : this.connectedParts) {
                    if (comp == null) continue;
                    wallPositions.add(comp.getCoordinates());
                }
                this.region = new ClimateRoom(this.region, internal.getRegion().getPositions(), wallPositions);
                ForestryAPI.climateManager.addRegion(this.region);
            }
        }
    }

    @Override
    public void onAssimilated(IMultiblockControllerInternal assimilator) {
        if (this.region != null) {
            ForestryAPI.climateManager.removeRegion(this.region);
        }
    }

    @Override
    protected boolean updateServer(int tickCount) {
        if (this.updateOnInterval(20)) {
            this.inventory.drainCan(this.tankManager);
        }
        for (IGreenhouseLogic logic : this.logics) {
            logic.work();
        }
        for (IGreenhouseComponent.Active activeComponent : this.activeComponents) {
            activeComponent.updateServer(tickCount);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        int minX = this.getSizeLimits().getMinimumXSize();
        int minY = this.getSizeLimits().getMinimumYSize();
        int minZ = this.getSizeLimits().getMinimumZSize();
        if (this.connectedParts.size() < this.getSizeLimits().getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small", minX, minY, minZ));
        }
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.func_177958_n() - minimumCoord.func_177958_n() + 1;
        int deltaY = maximumCoord.func_177956_o() - minimumCoord.func_177956_o() + 1;
        int deltaZ = maximumCoord.func_177952_p() - minimumCoord.func_177952_p() + 1;
        int maxX = this.getSizeLimits().getMaximumXSize();
        int maxY = this.getSizeLimits().getMaximumYSize();
        int maxZ = this.getSizeLimits().getMaximumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.large.x", maxX));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.large.y", maxY));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.large.z", maxZ));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small.x", minX));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small.y", minY));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small.z", minZ));
        }
        boolean isNextRoof = false;
        Class<?> myClass = this.getClass();
        for (int y = minimumCoord.func_177956_o(); y <= maximumCoord.func_177956_o() && !isNextRoof; ++y) {
            for (int x = minimumCoord.func_177958_n(); x <= maximumCoord.func_177958_n(); ++x) {
                for (int z = minimumCoord.func_177952_p(); z <= maximumCoord.func_177952_p(); ++z) {
                    int delta;
                    BlockPos pos = new BlockPos(x, y, z);
                    TileEntity te = this.worldObj.func_175625_s(pos);
                    IMultiblockComponent part = te instanceof IMultiblockComponent ? (IMultiblockComponent)te : null;
                    int extremes = 0;
                    int sides = 0;
                    if (x == minimumCoord.func_177958_n()) {
                        ++extremes;
                        ++sides;
                    }
                    if (y == minimumCoord.func_177956_o()) {
                        ++extremes;
                    }
                    if (z == minimumCoord.func_177952_p()) {
                        ++extremes;
                        ++sides;
                    }
                    if (x == maximumCoord.func_177958_n()) {
                        ++extremes;
                        ++sides;
                    }
                    if (z == maximumCoord.func_177952_p()) {
                        ++extremes;
                        ++sides;
                    }
                    if (extremes >= 1) {
                        int exteriorLevel = y - minimumCoord.func_177956_o();
                        if (part != null) {
                            if (!myClass.equals(part.getMultiblockLogic().getController().getClass())) {
                                throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.invalid.part", Translator.translateToLocal(this.getUnlocalizedType())));
                            }
                            this.isGoodForExteriorLevel(part, exteriorLevel);
                        } else {
                            this.isBlockGoodForExteriorLevel(exteriorLevel, this.worldObj, pos);
                        }
                    } else if (part != null) {
                        IBlockState state = this.worldObj.func_180495_p(part.getCoordinates());
                        if ((!(state.func_177230_c() instanceof BlockGreenhouse) || ((BlockGreenhouse)state.func_177230_c()).getGreenhouseType() != BlockGreenhouseType.SPRINKLER) && myClass.equals(part.getMultiblockLogic().getController().getClass())) throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.invalid.part", Translator.translateToLocal(this.getUnlocalizedType())));
                        this.isGoodForInterior(part);
                    } else {
                        this.isBlockGoodForInterior(this.worldObj, pos);
                    }
                    BlockPos posUp = pos.func_177981_b(2);
                    TileEntity tileUp = this.worldObj.func_175625_s(posUp);
                    if (sides < 1 || tileUp instanceof IGreenhouseComponent || (delta = y - minimumCoord.func_177956_o()) + 2 < minY) continue;
                    isNextRoof = true;
                }
            }
        }
        this.internalBlocks.clear();
        if (isNextRoof) {
            Stack<IInternalBlock> blocksToCheck = new Stack<IInternalBlock>();
            IInternalBlock internalBlock = this.createInternalBlock(new InternalBlock(this.getMinimumCoord().func_177982_a(1, 1, 1)));
            blocksToCheck.add(internalBlock);
            while (!blocksToCheck.isEmpty()) {
                IInternalBlock blockToCheck = (IInternalBlock)blocksToCheck.pop();
                List<IInternalBlock> newBlocksToCheck = this.checkInternalBlock(blockToCheck);
                blocksToCheck.addAll(newBlocksToCheck);
            }
        }
        if (this.internalBlocks.isEmpty()) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.greenhouse.error.space.closed"));
        }
        int hatches = 0;
        for (IMultiblockComponent comp : this.connectedParts) {
            if (!(comp instanceof IGreenhouseComponent.ButterflyHatch)) continue;
            ++hatches;
        }
        if (hatches <= true) return;
        throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.greenhouse.error.butterflyhatch.toomany"));
    }

    @Override
    protected void updateClient(int tickCount) {
    }

    private List<IInternalBlock> checkInternalBlock(IInternalBlock blockToCheck) throws MultiblockValidationException {
        ArrayList<IInternalBlock> newBlocksToCheck = new ArrayList<IInternalBlock>();
        this.internalBlocks.add(blockToCheck);
        BlockPos posRoot = blockToCheck.getPos();
        this.isBlockGoodForInterior(this.worldObj, posRoot);
        for (IInternalBlockFace faceToCheck : blockToCheck.getFaces()) {
            GreenhouseEvents.CheckInternalBlockFaceEvent checkEvent = new GreenhouseEvents.CheckInternalBlockFaceEvent(this, blockToCheck, faceToCheck);
            MinecraftForge.EVENT_BUS.post((Event)checkEvent);
            if (faceToCheck.isTested()) continue;
            EnumFacing face = faceToCheck.getFace();
            BlockPos posFacing = posRoot.func_177972_a(face);
            BlockPos minPos = this.getMinimumCoord();
            BlockPos maxPos = this.getMaximumCoord();
            if (minPos.func_177958_n() > posFacing.func_177958_n() || minPos.func_177956_o() > posFacing.func_177956_o() || minPos.func_177952_p() > posFacing.func_177952_p() || maxPos.func_177958_n() < posFacing.func_177958_n() || maxPos.func_177956_o() < posFacing.func_177956_o() || maxPos.func_177952_p() < posFacing.func_177952_p()) {
                throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.greenhouse.error.space.closed", new Object[0]));
            }
            TileEntity tileFace = this.worldObj.func_175625_s(posFacing);
            if (tileFace instanceof IGreenhouseComponent) {
                if (((IGreenhouseComponent)tileFace).getMultiblockLogic().getController() != this) {
                    throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.not.connected.part", new Object[0]));
                }
                if (tileFace instanceof TileGreenhouseSprinkler) continue;
                faceToCheck.setTested(true);
                continue;
            }
            IInternalBlock internalBlock = this.createInternalBlock(new InternalBlock(posFacing, face.func_176734_d(), blockToCheck));
            if (this.internalBlocks.contains(internalBlock)) {
                faceToCheck.setTested(true);
                continue;
            }
            newBlocksToCheck.add(internalBlock);
        }
        return newBlocksToCheck;
    }

    private IInternalBlock createInternalBlock(IInternalBlock internalBlock) {
        GreenhouseEvents.CreateInternalBlockEvent createEvent = new GreenhouseEvents.CreateInternalBlockEvent(this, internalBlock);
        MinecraftForge.EVENT_BUS.post((Event)createEvent);
        return createEvent.internalBlock;
    }

    @Override
    public Set<IInternalBlock> getInternalBlocks() {
        return this.internalBlocks;
    }

    public static IGreenhouseComponent.ButterflyHatch getGreenhouseButterflyHatch(World world, BlockPos pos) {
        if (GreenhouseManager.greenhouseHelper.getGreenhouseController(world, pos) == null) {
            return null;
        }
        IGreenhouseController controller = GreenhouseManager.greenhouseHelper.getGreenhouseController(world, pos);
        for (IMultiblockComponent greenhouse : controller.getComponents()) {
            if (!(greenhouse instanceof IGreenhouseComponent.ButterflyHatch)) continue;
            return (IGreenhouseComponent.ButterflyHatch)greenhouse;
        }
        return null;
    }

    @Override
    protected void isGoodForExteriorLevel(IMultiblockComponent part, int level) throws MultiblockValidationException {
    }

    @Override
    protected void isGoodForInterior(IMultiblockComponent part) throws MultiblockValidationException {
    }

    @Override
    protected void isBlockGoodForInterior(World world, BlockPos pos) throws MultiblockValidationException {
    }

    @Override
    public IClimateRegion getRegion() {
        return this.region;
    }

    @Override
    public void clearRegion() {
        this.region = null;
    }

    @Override
    public World getWorld() {
        return this.worldObj;
    }

    @Override
    public Set<IGreenhouseComponent.Listener> getListenerComponents() {
        return this.listenerComponents;
    }
}

