/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.proxy;

import forestry.api.arboriculture.EnumPileType;
import forestry.api.arboriculture.IWoodItemMeshDefinition;
import forestry.api.arboriculture.IWoodStateMapper;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.blocks.slab.BlockArbSlab;
import forestry.arboriculture.models.ModelDecorativeLeaves;
import forestry.arboriculture.models.ModelLeaves;
import forestry.arboriculture.models.ModelWoodPile;
import forestry.arboriculture.models.WoodModelLoader;
import forestry.arboriculture.proxy.ProxyArboriculture;
import forestry.arboriculture.render.CharcoalPileRenderer;
import forestry.arboriculture.tiles.TilePile;
import forestry.core.models.BlockModelEntry;
import forestry.core.models.SimpleRetexturedModel;
import forestry.core.models.WoodModelEntry;
import forestry.core.proxy.Proxies;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.BlockStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.ColorizerFoliage;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ProxyArboricultureClient
extends ProxyArboriculture {
    private static Set<WoodModelEntry> woodModelEntrys = new HashSet<WoodModelEntry>();

    @Override
    public void initializeModels() {
        Object blockModelLocation = new ModelResourceLocation("forestry:leaves");
        ModelResourceLocation itemModelLocation = new ModelResourceLocation("forestry:leaves", "inventory");
        BlockModelEntry blockModelIndex = new BlockModelEntry((ModelResourceLocation)blockModelLocation, itemModelLocation, new ModelLeaves(), (Block)PluginArboriculture.blocks.leaves);
        Proxies.render.registerBlockModel(blockModelIndex);
        for (BlockDecorativeLeaves leaves : PluginArboriculture.blocks.leavesDecorative) {
            String resourceName = "forestry:leaves.decorative." + leaves.getBlockNumber();
            ModelResourceLocation blockModelLocation2 = new ModelResourceLocation(resourceName);
            ModelResourceLocation itemModeLocation = new ModelResourceLocation(resourceName, "inventory");
            BlockModelEntry blockModelIndex2 = new BlockModelEntry(blockModelLocation2, itemModeLocation, new ModelDecorativeLeaves(), leaves);
            Proxies.render.registerBlockModel(blockModelIndex2);
        }
        blockModelLocation = new ModelResourceLocation("forestry:pile", "type=wood");
        itemModelLocation = new ModelResourceLocation("forestry:woodPile", "inventory");
        blockModelIndex = new BlockModelEntry((ModelResourceLocation)blockModelLocation, itemModelLocation, new ModelWoodPile(), PluginArboriculture.blocks.piles.get((Object)EnumPileType.WOOD));
        Proxies.render.registerBlockModel(blockModelIndex);
        ClientRegistry.bindTileEntitySpecialRenderer(TilePile.class, (TileEntitySpecialRenderer)new CharcoalPileRenderer());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)WoodModelLoader.INSTANCE);
        for (BlockArbSlab slab : PluginArboriculture.blocks.slabsDouble) {
            this.registerWoodModel(slab, true);
        }
        for (BlockArbSlab slab : PluginArboriculture.blocks.slabsDoubleFireproof) {
            this.registerWoodModel(slab, true);
        }
    }

    @SubscribeEvent
    public <T extends Block> void onModelBake(ModelBakeEvent event) {
        WoodModelLoader.INSTANCE.isRegistered = true;
        IRegistry registry = event.getModelRegistry();
        Minecraft minecraft = Proxies.common.getClientInstance();
        Map loadingExceptions = (Map)ObfuscationReflectionHelper.getPrivateValue(ModelLoader.class, (Object)event.getModelLoader(), (int)2);
        if (minecraft.func_175602_ab() != null) {
            BlockStateMapper stateMapper = minecraft.func_175602_ab().func_175023_a().func_178120_a();
            Map definitions = (Map)ObfuscationReflectionHelper.getPrivateValue(ItemModelMesher.class, (Object)minecraft.func_175599_af().func_175037_a(), (int)2);
            Map blockStateMap = (Map)ObfuscationReflectionHelper.getPrivateValue(BlockStateMapper.class, (Object)stateMapper, (int)0);
            for (WoodModelEntry entry : woodModelEntrys) {
                Object woodTyped = entry.woodTyped;
                WoodBlockKind woodKind = ((IWoodTyped)woodTyped).getBlockKind();
                IStateMapper mapper = (IStateMapper)blockStateMap.get(woodTyped);
                if (!(mapper instanceof IWoodStateMapper)) continue;
                IWoodStateMapper woodMapper = (IWoodStateMapper)mapper;
                try {
                    for (IBlockState state : woodTyped.func_176194_O().func_177619_a()) {
                        ItemMeshDefinition definition;
                        ItemStack itemStack;
                        IWoodType woodType;
                        if (entry.withVariants) {
                            int meta = woodTyped.func_176201_c(state);
                            woodType = ((IWoodTyped)woodTyped).getWoodType(meta);
                            itemStack = new ItemStack(woodTyped, 1, meta);
                        } else {
                            woodType = ((IWoodTyped)woodTyped).getWoodType(0);
                            itemStack = new ItemStack(woodTyped);
                        }
                        if (woodKind.retextureItem && (definition = (ItemMeshDefinition)definitions.get(itemStack.func_77973_b())) instanceof IWoodItemMeshDefinition) {
                            IWoodItemMeshDefinition woodDefinition = (IWoodItemMeshDefinition)definition;
                            IModel basicItemModel = ModelLoaderRegistry.getModel((ResourceLocation)woodDefinition.getDefaultModelLocation(itemStack));
                            ModelResourceLocation basicItemLocation = definition.func_178113_a(itemStack);
                            registry.func_82595_a((Object)basicItemLocation, (Object)new SimpleRetexturedModel(woodKind.retextureModel(basicItemModel, woodType)));
                        }
                        IModel basicModel = ModelLoaderRegistry.getModel((ResourceLocation)woodMapper.getDefaultModelResourceLocation(state));
                        ModelResourceLocation basicLocation = woodMapper.getModelLocation(state);
                        if (loadingExceptions.containsKey(basicLocation)) {
                            loadingExceptions.remove(basicLocation);
                        }
                        registry.func_82595_a((Object)basicLocation, (Object)new SimpleRetexturedModel(woodKind.retextureModel(basicModel, woodType)));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        loadingExceptions.putAll(WoodModelLoader.loadingExceptions);
    }

    @Override
    public <T extends Block> void registerWoodModel(T woodTyped, boolean withVariants) {
        woodModelEntrys.add(new WoodModelEntry<T>(woodTyped, withVariants));
    }

    @Override
    public int getFoliageColorBasic() {
        return ColorizerFoliage.func_77468_c();
    }

    @Override
    public int getFoliageColorBirch() {
        return ColorizerFoliage.func_77469_b();
    }

    @Override
    public int getFoliageColorPine() {
        return ColorizerFoliage.func_77466_a();
    }
}

