/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.core.items.EnumContainerType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;

public class FluidHandlerItemForestry
extends FluidHandlerItemStackSimple.Consumable {
    private final EnumContainerType containerType;

    public FluidHandlerItemForestry(ItemStack container, EnumContainerType containerType) {
        super(container, 1000);
        this.containerType = containerType;
    }

    private boolean contentsAllowed(FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return false;
        }
        switch (this.containerType) {
            case CAPSULE: {
                return (double)fluid.getTemperature(fluidStack) < 310.15;
            }
        }
        return true;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.contentsAllowed(fluid);
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return this.contentsAllowed(fluid);
    }

    protected void setFluid(FluidStack fluid) {
        super.setFluid(fluid);
        this.container.func_77964_b(1);
    }
}

