/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.network.packets;

import forestry.api.core.ICamouflageHandler;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketIdServer;
import forestry.core.network.packets.PacketCoordinates;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketCamouflageUpdate
extends PacketCoordinates
implements IForestryPacketServer {
    private ItemStack camouflageStack;
    private String type;
    private boolean isMultiblock;

    public PacketCamouflageUpdate() {
    }

    public PacketCamouflageUpdate(ICamouflageHandler tile, String type, boolean isMultiblock) {
        super(tile.getCoordinates());
        this.camouflageStack = tile.getCamouflageBlock(type);
        this.isMultiblock = isMultiblock;
        this.type = type;
    }

    public PacketCamouflageUpdate(ICamouflageHandler tile, String type) {
        super(tile.getCoordinates());
        this.camouflageStack = tile.getCamouflageBlock(type);
        this.isMultiblock = false;
        this.type = type;
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.TILE_FORESTRY_CAMOUFLAGE;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeBoolean(this.isMultiblock);
        data.writeUTF(this.type);
        data.writeItemStack(this.camouflageStack);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.isMultiblock = data.readBoolean();
        this.type = data.readUTF();
        this.camouflageStack = data.readItemStack();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayerMP player) {
        TileEntity tile = this.getTarget(player.field_70170_p);
        ICamouflageHandler handler = null;
        if (this.isMultiblock && tile instanceof IMultiblockComponent) {
            IMultiblockController controller = ((IMultiblockComponent)tile).getMultiblockLogic().getController();
            if (controller instanceof ICamouflageHandler) {
                handler = (ICamouflageHandler)((Object)controller);
            }
        } else if (tile instanceof ICamouflageHandler) {
            handler = (ICamouflageHandler)tile;
        }
        if (handler != null) {
            handler.setCamouflageBlock(this.type, this.camouflageStack);
        }
    }
}

