/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import forestry.core.commands.IForestryCommand;
import forestry.core.commands.SubCommand;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class CommandHelpers {
    public static void sendLocalizedChatMessage(ICommandSender sender, String locTag, Object ... args) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(locTag, args));
    }

    public static void sendLocalizedChatMessage(ICommandSender sender, Style chatStyle, String locTag, Object ... args) {
        TextComponentTranslation chat = new TextComponentTranslation(locTag, args);
        chat.func_150255_a(chatStyle);
        sender.func_145747_a((ITextComponent)chat);
    }

    public static void sendChatMessage(ICommandSender sender, String message) {
        sender.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    public static void throwWrongUsage(ICommandSender sender, IForestryCommand command) throws WrongUsageException {
        throw new WrongUsageException(Translator.translateToLocalFormatted("for.chat.help", command.func_71518_a(sender)), new Object[0]);
    }

    public static void processChildCommand(MinecraftServer server, ICommandSender sender, SubCommand child, String[] args) throws CommandException {
        if (!sender.func_70003_b(child.getPermissionLevel(), child.getFullCommandString())) {
            throw new WrongUsageException(Translator.translateToLocal("for.chat.command.noperms"), new Object[0]);
        }
        String[] newargs = new String[args.length - 1];
        System.arraycopy(args, 1, newargs, 0, newargs.length);
        child.func_184881_a(server, sender, newargs);
    }

    public static void printHelp(ICommandSender sender, IForestryCommand command) {
        int permLevel;
        String commandString = command.getFullCommandString().replace(" ", ".");
        Style header = new Style();
        header.func_150238_a(TextFormatting.BLUE);
        CommandHelpers.sendLocalizedChatMessage(sender, header, "for.chat.command." + commandString + ".format", command.getFullCommandString());
        Style body = new Style();
        body.func_150238_a(TextFormatting.GRAY);
        List<String> commandAliases = command.func_71514_a();
        if (!commandAliases.isEmpty()) {
            CommandHelpers.sendLocalizedChatMessage(sender, body, "for.chat.command.aliases", commandAliases.toString().replace("[", "").replace("]", ""));
        }
        if ((permLevel = command.getPermissionLevel()) > 0) {
            CommandHelpers.sendLocalizedChatMessage(sender, body, "for.chat.command.permlevel", permLevel);
        }
        CommandHelpers.sendLocalizedChatMessage(sender, body, "for.chat.command." + commandString + ".help", new Object[0]);
        if (!command.getChildren().isEmpty()) {
            CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.list", new Object[0]);
            for (SubCommand child : command.getChildren()) {
                CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command." + child.getFullCommandString().replace(" ", ".") + ".desc", child.func_71517_b());
            }
        }
    }

    public static boolean processStandardCommands(MinecraftServer server, ICommandSender sender, IForestryCommand command, String[] args) throws CommandException {
        if (args.length >= 1) {
            if (args[0].equals("help")) {
                command.printHelp(sender);
                return true;
            }
            for (SubCommand child : command.getChildren()) {
                if (!CommandHelpers.matches(args[0], child)) continue;
                CommandHelpers.processChildCommand(server, sender, child, args);
                return true;
            }
        }
        return false;
    }

    public static boolean matches(String commandName, IForestryCommand command) {
        if (commandName.equals(command.func_71517_b())) {
            return true;
        }
        if (command.func_71514_a() != null) {
            for (String alias : command.func_71514_a()) {
                if (!commandName.equals(alias)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> getListOfStringsMatchingLastWord(String[] strings, String ... lastWords) {
        return CommandBase.func_71530_a((String[])strings, (String[])lastWords);
    }

    public static List<String> addStandardTabCompletionOptions(MinecraftServer server, IForestryCommand command, ICommandSender sender, String[] incomplete, BlockPos pos) {
        if (incomplete.length > 1) {
            String commandName = incomplete[0];
            for (SubCommand child : command.getChildren()) {
                if (!CommandHelpers.matches(commandName, child)) continue;
                String[] incompleteRemaining = Arrays.copyOfRange(incomplete, 1, incomplete.length);
                return child.func_184883_a(server, sender, incompleteRemaining, pos);
            }
        }
        ArrayList<String> commandNames = new ArrayList<String>();
        for (SubCommand child : command.getChildren()) {
            commandNames.add(child.func_71517_b());
        }
        commandNames.add("help");
        String[] commandNamesArr = commandNames.toArray(new String[commandNames.size()]);
        return CommandHelpers.getListOfStringsMatchingLastWord(incomplete, commandNamesArr);
    }
}

