/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import com.google.common.collect.ImmutableMap;
import forestry.api.core.climate.IClimatePosition;
import forestry.api.core.climate.IClimateRegion;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.proxy.Proxies;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouseClimatiser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;

public class TileGreenhouseSprinkler
extends TileGreenhouseClimatiser {
    private final IAnimationStateMachine asm;
    private final TimeValues.VariableValue cycleLength = new TimeValues.VariableValue(4.0f);
    private final TimeValues.VariableValue clickTime = new TimeValues.VariableValue(Float.NEGATIVE_INFINITY);
    protected static final int WATER_PER_OPERATION = 25;
    private static final SprinklerDefinition definition = new SprinklerDefinition();

    public TileGreenhouseSprinkler() {
        super(definition);
        this.asm = Proxies.render.loadAnimationState(new ResourceLocation("forestry", "asms/block/sprinkler.json"), (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"cycle_length", (Object)this.cycleLength, (Object)"click_time", (Object)this.clickTime));
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public void changeClimate(int tick, IClimateRegion region) {
        IGreenhouseControllerInternal controller = ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController();
        if (((MultiblockLogicGreenhouse)this.getMultiblockLogic()).isConnected() && controller != null && controller.isAssembled() && this.minPos != null && this.maxPos != null && region != null) {
            IGreenhouseControllerInternal greenhouseInternal = controller;
            boolean canWork = true;
            for (IGreenhouseComponent.Listener listenerComponent : greenhouseInternal.getListenerComponents()) {
                if (!canWork) continue;
                canWork = listenerComponent.getGreenhouseListener().canWork(greenhouseInternal, canWork);
            }
            if (canWork && this.workingTime == 0 && this.consumeWaterToDoWork(1, 25, (StandardTank)greenhouseInternal.getTankManager().getTank(0))) {
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.maxPos, (BlockPos)this.minPos)) {
                    int maxDistance;
                    IClimatePosition position = region.getPositions().get(pos);
                    if (position == null) continue;
                    if (position.getHumidity() >= 2.0f) {
                        if (!(position.getHumidity() > 2.0f)) continue;
                        position.setHumidity(2.0f);
                        continue;
                    }
                    double distance = pos.func_177951_i((Vec3i)pos);
                    if (!(distance <= (double)(maxDistance = definition.getClimitiseRange()))) continue;
                    position.setHumidity(position.getHumidity() + (float)((double)definition.getChange() / distance));
                }
                this.workingTime += 2;
            }
            if (this.workingTime > 0) {
                --this.workingTime;
            }
            this.setActive(this.workingTime > 0);
        } else if (this.isActive()) {
            this.setActive(false);
        }
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            if (this.asm.currentState().equals("moving") && !this.isActive()) {
                this.clickTime.setValue(Animation.getWorldTime((World)this.func_145831_w(), (float)Animation.getPartialTickTime()));
                this.asm.transition("stopping");
            } else if (this.asm.currentState().equals("default") && this.isActive()) {
                float time = Animation.getWorldTime((World)this.func_145831_w(), (float)Animation.getPartialTickTime());
                this.clickTime.setValue(time);
                this.asm.transition("starting");
            }
        }
    }

    public boolean consumeWaterToDoWork(int ticksPerWorkCycle, int fluidPerWorkCycle, StandardTank tank) {
        int fluidPerCycle = (int)Math.ceil((float)fluidPerWorkCycle / (float)ticksPerWorkCycle);
        if (tank.getFluid() == null || tank.getFluid().amount < fluidPerCycle) {
            return false;
        }
        this.modifyWaterStored(-fluidPerCycle, tank);
        return true;
    }

    public void modifyWaterStored(int fluid, StandardTank tank) {
        tank.getFluid().amount += fluid;
        if (tank.getFluid().amount > tank.getCapacity()) {
            tank.getFluid().amount = tank.getCapacity();
        } else if (tank.getFluid().amount < 0) {
            tank.getFluid().amount = 0;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        return (T)super.getCapability(capability, side);
    }

    private static class SprinklerDefinition
    implements TileGreenhouseClimatiser.IClimitiserDefinition {
        private SprinklerDefinition() {
        }

        @Override
        public TileGreenhouseClimatiser.ClimitiserType getType() {
            return TileGreenhouseClimatiser.ClimitiserType.HUMIDITY;
        }

        @Override
        public float getChange() {
            return 0.005f;
        }

        @Override
        public int getClimitiseRange() {
            return 9;
        }

        @Override
        public boolean isPositiv() {
            return true;
        }
    }
}

