/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import forestry.api.core.ForestryAPI;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.tiles.TileEngine;
import forestry.energy.EnergyStorage;
import java.io.IOException;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla")})
public class EnergyManager
implements IEnergyReceiver,
ITeslaConsumer,
ITeslaProducer,
ITeslaHolder,
IEnergyProvider,
IStreamable {
    @CapabilityInject(value=ITeslaConsumer.class)
    public static Capability<ITeslaConsumer> TESLA_CONSUMER = null;
    @CapabilityInject(value=ITeslaProducer.class)
    public static Capability<ITeslaProducer> TESLA_PRODUCER = null;
    @CapabilityInject(value=ITeslaHolder.class)
    public static Capability<ITeslaHolder> TESLA_HOLDER = null;
    private final EnergyStorage energyStorage;
    private EnergyTransferMode mode = EnergyTransferMode.BOTH;

    public EnergyManager(int maxTransfer, int capacity) {
        this.energyStorage = new EnergyStorage(EnergyManager.scaleForDifficulty(capacity), EnergyManager.scaleForDifficulty(maxTransfer), EnergyManager.scaleForDifficulty(maxTransfer));
    }

    public static int scaleForDifficulty(int energyPerUse) {
        return Math.round((float)energyPerUse * ForestryAPI.activeMode.getFloatSetting("energy.demand.modifier"));
    }

    public void setExtractOnly() {
        this.mode = EnergyTransferMode.EXTRACT;
    }

    public void setReceiveOnly() {
        this.mode = EnergyTransferMode.RECEIVE;
    }

    private boolean canExtract() {
        switch (this.mode) {
            case EXTRACT: 
            case BOTH: {
                return true;
            }
        }
        return false;
    }

    private boolean canReceive() {
        switch (this.mode) {
            case BOTH: 
            case RECEIVE: {
                return true;
            }
        }
        return false;
    }

    public EnergyManager readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound energyManagerNBT = nbt.func_74775_l("EnergyManager");
        NBTTagCompound energyStorageNBT = energyManagerNBT.func_74775_l("EnergyStorage");
        this.energyStorage.readFromNBT(energyStorageNBT);
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound energyStorageNBT = new NBTTagCompound();
        this.energyStorage.writeToNBT(energyStorageNBT);
        NBTTagCompound energyManagerNBT = new NBTTagCompound();
        energyManagerNBT.func_74782_a("EnergyStorage", (NBTBase)energyStorageNBT);
        nbt.func_74782_a("EnergyManager", (NBTBase)energyManagerNBT);
        return nbt;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        int energyStored = this.energyStorage.getEnergyStored();
        data.writeInt(energyStored);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        int energyStored = data.readInt();
        this.energyStorage.setEnergyStored(energyStored);
    }

    public int toGuiInt() {
        return this.energyStorage.getEnergyStored();
    }

    public void fromGuiInt(int packetInt) {
        this.energyStorage.setEnergyStored(packetInt);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getTotalEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getMaxEnergyReceived() {
        return this.energyStorage.getMaxReceive();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public boolean consumeEnergyToDoWork(int ticksPerWorkCycle, int energyPerWorkCycle) {
        int energyPerCycle = (int)Math.ceil((float)energyPerWorkCycle / (float)ticksPerWorkCycle);
        if (this.energyStorage.getEnergyStored() < energyPerCycle) {
            return false;
        }
        this.energyStorage.modifyEnergyStored(-energyPerCycle);
        return true;
    }

    public boolean canSendEnergy(EnumFacing orientation, TileEntity tile) {
        return this.sendEnergy(orientation, tile, Integer.MAX_VALUE, true) > 0;
    }

    public int sendEnergy(EnumFacing orientation, TileEntity tile) {
        return this.sendEnergy(orientation, tile, Integer.MAX_VALUE, false);
    }

    public int sendEnergy(EnumFacing orientation, TileEntity tile, int amount, boolean simulate) {
        int extractable;
        int sent = 0;
        if (tile != null && (extractable = this.energyStorage.extractEnergy(amount, true)) > 0) {
            EnumFacing side = orientation.func_176734_d();
            if (TESLA_CONSUMER != null && tile.hasCapability(TESLA_CONSUMER, side)) {
                sent = EnergyManager.sendEnergyTesla(tile, side, extractable, simulate);
            } else if (tile instanceof IEnergyReceiver) {
                IEnergyReceiver receptor = (IEnergyReceiver)tile;
                sent = receptor.receiveEnergy(side, extractable, simulate);
            } else if (tile instanceof TileEngine) {
                TileEngine receptor = (TileEngine)tile;
                sent = receptor.getEnergyManager().receiveEnergy(side, extractable, simulate);
            }
            this.energyStorage.extractEnergy(sent, simulate);
        }
        return sent;
    }

    public void drainEnergy(int amount) {
        this.energyStorage.modifyEnergyStored(-amount);
    }

    public void generateEnergy(int amount) {
        this.energyStorage.modifyEnergyStored(amount);
    }

    public boolean hasCapability(Capability<?> capability) {
        if (capability == TESLA_PRODUCER && this.canExtract()) {
            return true;
        }
        if (capability == TESLA_CONSUMER && this.canReceive()) {
            return true;
        }
        return capability == TESLA_HOLDER;
    }

    public <T> T getCapability(Capability<T> capability) {
        if (capability == TESLA_PRODUCER && this.canExtract()) {
            return (T)TESLA_PRODUCER.cast((Object)this);
        }
        if (capability == TESLA_CONSUMER && this.canReceive()) {
            return (T)TESLA_CONSUMER.cast((Object)this);
        }
        if (capability == TESLA_HOLDER) {
            return (T)TESLA_HOLDER.cast((Object)this);
        }
        return null;
    }

    @Optional.Method(modid="tesla")
    public static int sendEnergyTesla(TileEntity tile, EnumFacing side, int amount, boolean simulate) {
        ITeslaConsumer consumer = (ITeslaConsumer)tile.getCapability(TESLA_CONSUMER, side);
        return (int)consumer.givePower((long)amount, simulate);
    }

    @Optional.Method(modid="tesla")
    public long givePower(long power, boolean simulated) {
        if (!this.canReceive()) {
            return 0L;
        }
        return this.energyStorage.receiveEnergy(power, simulated);
    }

    @Optional.Method(modid="tesla")
    public long takePower(long power, boolean simulated) {
        if (!this.canExtract()) {
            return 0L;
        }
        return this.energyStorage.extractEnergy(power, simulated);
    }

    @Optional.Method(modid="tesla")
    public long getStoredPower() {
        return this.energyStorage.getEnergyStored();
    }

    @Optional.Method(modid="tesla")
    public long getCapacity() {
        return this.energyStorage.getMaxEnergyStored();
    }

    private static enum EnergyTransferMode {
        EXTRACT,
        RECEIVE,
        BOTH;

    }
}

