/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import forestry.api.core.IModelBaker;
import forestry.api.core.IModelBakerModel;
import forestry.core.blocks.propertys.UnlistedBlockAccess;
import forestry.core.blocks.propertys.UnlistedBlockPos;
import forestry.core.models.baker.ModelBaker;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class ModelBlockDefault<B extends Block>
implements IBakedModel {
    private ItemOverrideList overrideList;
    @Nonnull
    protected final Class<B> blockClass;
    protected IModelBakerModel blockModel;
    protected IModelBakerModel itemModel;

    protected ModelBlockDefault(@Nonnull Class<B> blockClass) {
        this.blockClass = blockClass;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (state instanceof IExtendedBlockState) {
            ModelBaker baker = new ModelBaker();
            IExtendedBlockState stateExtended = (IExtendedBlockState)state;
            IBlockAccess world = (IBlockAccess)stateExtended.getValue((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS);
            BlockPos pos = (BlockPos)stateExtended.getValue((IUnlistedProperty)UnlistedBlockPos.POS);
            Block block = state.func_177230_c();
            if (!this.blockClass.isInstance(block)) {
                return null;
            }
            Block bBlock = (Block)this.blockClass.cast(block);
            baker.setRenderBounds(block.func_185496_a(state, world, pos));
            this.bakeWorldBlock(bBlock, world, pos, stateExtended, baker);
            this.blockModel = baker.bakeModel(false);
            this.onCreateModel(this.blockModel);
            return this.blockModel.func_188616_a(state, side, rand);
        }
        return Collections.emptyList();
    }

    protected void onCreateModel(IModelBakerModel model) {
    }

    public boolean func_177555_b() {
        if (this.itemModel == null && this.blockModel == null) {
            return false;
        }
        return this.blockModel != null ? this.blockModel.func_177555_b() : this.itemModel.func_177555_b();
    }

    public boolean func_177556_c() {
        if (this.itemModel == null) {
            return false;
        }
        return this.itemModel.func_177556_c();
    }

    public boolean func_188618_c() {
        if (this.itemModel == null && this.blockModel == null) {
            return false;
        }
        return this.blockModel != null ? this.blockModel.func_188618_c() : this.itemModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        if (this.blockModel != null) {
            return this.blockModel.func_177554_e();
        }
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        if (this.itemModel == null) {
            return null;
        }
        return this.itemModel.func_177552_f();
    }

    protected ItemOverrideList createOverrides() {
        return new DefaultItemOverrideList();
    }

    public ItemOverrideList func_188617_f() {
        if (this.overrideList == null) {
            this.overrideList = this.createOverrides();
        }
        return this.overrideList;
    }

    protected abstract void bakeInventoryBlock(@Nonnull B var1, @Nonnull ItemStack var2, @Nonnull IModelBaker var3);

    protected abstract void bakeWorldBlock(@Nonnull B var1, @Nonnull IBlockAccess var2, @Nonnull BlockPos var3, @Nonnull IExtendedBlockState var4, @Nonnull IModelBaker var5);

    private class DefaultItemOverrideList
    extends ItemOverrideList {
        public DefaultItemOverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            ModelBaker baker = new ModelBaker();
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (!ModelBlockDefault.this.blockClass.isInstance(block)) {
                return null;
            }
            Block bBlock = (Block)ModelBlockDefault.this.blockClass.cast(block);
            baker.setRenderBounds(block.func_185496_a(block.func_176203_a(stack.func_77952_i()), (IBlockAccess)world, null));
            ModelBlockDefault.this.bakeInventoryBlock(bBlock, stack, baker);
            ModelBlockDefault.this.itemModel = baker.bakeModel(true);
            return ModelBlockDefault.this.itemModel;
        }
    }
}

