/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.rainmaker;

import forestry.api.fuels.RainSubstrate;
import forestry.core.utils.Translator;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class RainmakerRecipeWrapper
extends BlankRecipeWrapper {
    @Nonnull
    private final RainSubstrate substrate;

    public RainmakerRecipeWrapper(@Nonnull RainSubstrate substrate) {
        this.substrate = substrate;
    }

    @Nonnull
    public List<List<ItemStack>> getInputs() {
        return Collections.singletonList(Collections.singletonList(this.substrate.getItem()));
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        minecraft.field_71466_p.func_78276_b(this.getEffectString(), 24, 0, Color.darkGray.getRGB());
        String speed = Translator.translateToLocalFormatted("for.jei.rainmaker.speed", Float.valueOf(this.substrate.getSpeed()));
        minecraft.field_71466_p.func_78276_b(speed, 24, 10, Color.gray.getRGB());
        if (!this.substrate.isReverse()) {
            String duration = Translator.translateToLocalFormatted("for.jei.rainmaker.duration", this.substrate.getDuration());
            minecraft.field_71466_p.func_78276_b(duration, 24, 20, Color.gray.getRGB());
        }
    }

    private String getEffectString() {
        if (this.substrate.isReverse()) {
            return Translator.translateToLocal("for.jei.rainmaker.stops.rain");
        }
        return Translator.translateToLocal("for.jei.rainmaker.causes.rain");
    }
}

