/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.models;

import forestry.api.core.IModelBaker;
import forestry.core.models.ModelBlockDefault;
import forestry.core.utils.CamouflageUtil;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;

public class ModelGreenhouse
extends ModelBlockDefault<BlockGreenhouse> {
    public ModelGreenhouse() {
        super(BlockGreenhouse.class);
    }

    @Override
    protected void bakeInventoryBlock(@Nonnull BlockGreenhouse block, @Nonnull ItemStack item, @Nonnull IModelBaker baker) {
        ModelGreenhouse.bakeBlockModel(block, null, null, null, baker, null);
    }

    @Override
    protected void bakeWorldBlock(@Nonnull BlockGreenhouse block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IExtendedBlockState stateExtended, @Nonnull IModelBaker baker) {
        ItemStack camouflageStack = CamouflageUtil.getCamouflageBlock(world, pos);
        ModelGreenhouse.bakeBlockModel(block, world, pos, stateExtended, baker, camouflageStack);
    }

    private static void bakeBlockModel(@Nonnull BlockGreenhouse block, @Nullable IBlockAccess world, @Nullable BlockPos pos, @Nullable IExtendedBlockState stateExtended, @Nonnull IModelBaker baker, @Nullable ItemStack camouflageStack) {
        if (camouflageStack != null) {
            BlockModelShapes modelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
            IBlockState state = Block.func_149634_a((Item)camouflageStack.func_77973_b()).func_176203_a(camouflageStack.func_77952_i());
            baker.addBakedModel(state, modelShapes.func_178125_b(state));
            baker.setParticleSprite(modelShapes.func_178125_b(Block.func_149634_a((Item)camouflageStack.func_77973_b()).func_176203_a(camouflageStack.func_77952_i())).func_177554_e());
        } else if (block.getGreenhouseType() == BlockGreenhouseType.GLASS) {
            TextureAtlasSprite glassSprite = BlockGreenhouseType.getSprite(BlockGreenhouseType.GLASS, null, null, world, pos);
            baker.addBlockModel((Block)block, Block.field_185505_j, pos, BlockGreenhouseType.getSprite(BlockGreenhouseType.GLASS, null, null, world, pos), 100);
            baker.setParticleSprite(glassSprite);
        } else {
            TextureAtlasSprite plainSprite = BlockGreenhouseType.getSprite(BlockGreenhouseType.PLAIN, null, null, world, pos);
            baker.addBlockModel((Block)block, Block.field_185505_j, pos, BlockGreenhouseType.getSprite(BlockGreenhouseType.PLAIN, null, null, world, pos), 100);
            baker.setParticleSprite(plainSprite);
        }
        if (block.getGreenhouseType().hasOverlaySprite) {
            TextureAtlasSprite[] sprite = new TextureAtlasSprite[6];
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                sprite[facing.ordinal()] = BlockGreenhouseType.getSprite(block.getGreenhouseType(), facing, (IBlockState)stateExtended, world, pos);
            }
            baker.addBlockModel((Block)block, Block.field_185505_j, pos, sprite, 101);
        }
    }
}

