/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.fermenter;

import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.IVariableFermentable;
import forestry.core.recipes.jei.ForestryRecipeWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FermenterRecipeWrapper
extends ForestryRecipeWrapper<IFermenterRecipe> {
    @Nonnull
    private final ItemStack fermentable;

    public FermenterRecipeWrapper(@Nonnull IFermenterRecipe recipe, @Nonnull ItemStack fermentable) {
        super(recipe);
        this.fermentable = fermentable;
    }

    @Nonnull
    public List getInputs() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (FermenterFuel fuel : FuelManager.fermenterFuel.values()) {
            inputs.add(fuel.item);
        }
        inputs.add(this.fermentable);
        return inputs;
    }

    @Nonnull
    public ItemStack getFermentable() {
        return this.fermentable;
    }

    @Nonnull
    public List<FluidStack> getFluidInputs() {
        FluidStack input = ((IFermenterRecipe)this.getRecipe()).getFluidResource().copy();
        input.amount = ((IFermenterRecipe)this.getRecipe()).getFermentationValue();
        return Collections.singletonList(input);
    }

    @Nonnull
    public List<FluidStack> getFluidOutputs() {
        int amount = Math.round((float)((IFermenterRecipe)this.getRecipe()).getFermentationValue() * ((IFermenterRecipe)this.getRecipe()).getModifier());
        if (this.fermentable.func_77973_b() instanceof IVariableFermentable) {
            amount = (int)((float)amount * ((IVariableFermentable)this.fermentable.func_77973_b()).getFermentationModifier(this.fermentable));
        }
        FluidStack output = new FluidStack(((IFermenterRecipe)this.getRecipe()).getOutput(), amount);
        return Collections.singletonList(output);
    }
}

