/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.circuits;

import java.io.IOException;
import java.util.Locale;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ICircuitSocketType;
import forestry.api.farming.FarmDirection;
import forestry.core.config.Constants;
import forestry.core.gui.GuiForestry;
import forestry.core.inventory.ItemInventorySolderingIron;
import forestry.core.utils.Translator;

public class GuiSolderingIron extends GuiForestry<ContainerSolderingIron, ItemInventorySolderingIron> {

	public GuiSolderingIron(EntityPlayer player, ItemInventorySolderingIron inventory) {
		super(Constants.TEXTURE_PATH_GUI + "/solder.png", new ContainerSolderingIron(player, inventory), inventory);

		field_146999_f = 176;
		field_147000_g = 205;
	}

	@Override
	protected void func_146976_a(float var1, int mouseX, int mouseY) {
		super.func_146976_a(var1, mouseX, mouseY);

		ICircuitLayout layout = ((ContainerSolderingIron) field_147002_h).getLayout();
		String title = layout.getName();
		field_146289_q.func_78276_b(title, field_147003_i + 8 + textLayout.getCenteredOffset(title, 138), field_147009_r + 16, fontColor.get("gui.screen"));

		for (int i = 0; i < 4; i++) {
			String description;
			ItemStack tube = inventory.func_70301_a(i + 2);
			CircuitRecipe recipe = SolderManager.getMatchingRecipe(layout, tube);
			if (recipe == null) {
				description = "(" + Translator.translateToLocal("for.gui.noeffect") + ")";
			} else {
				description = Translator.translateToLocal(recipe.getCircuit().getUnlocalizedName());
			}

			int row = i * 20;
			field_146289_q.func_78276_b(description, field_147003_i + 32, field_147009_r + 36 + row, fontColor.get("gui.screen"));

			if (tube == null) {
				ICircuitSocketType socketType = layout.getSocketType();
				if (CircuitSocketType.FARM.equals(socketType)) {
					FarmDirection farmDirection = FarmDirection.values()[i];
					String farmDirectionString = farmDirection.toString().toLowerCase(Locale.ENGLISH);
					String localizedDirection = Translator.translateToLocal("for.gui.solder." + farmDirectionString);
					field_146289_q.func_78276_b(localizedDirection, field_147003_i + 17, field_147009_r + 36 + row, fontColor.get("gui.screen"));
				}
			}
		}
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();

		field_146292_n.add(new GuiButton(1, field_147003_i + 12, field_147009_r + 10, 12, 18, "<"));
		field_146292_n.add(new GuiButton(2, field_147003_i + 130, field_147009_r + 10, 12, 18, ">"));
	}

	@Override
	protected void func_146284_a(GuiButton guibutton) throws IOException {
		super.func_146284_a(guibutton);

		if (guibutton.field_146127_k == 1) {
			ContainerSolderingIron.regressSelection(0);
		} else if (guibutton.field_146127_k == 2) {
			ContainerSolderingIron.advanceSelection(0);
		}
	}

}
