/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse;

import forestry.api.core.ForestryAPI;
import forestry.api.greenhouse.GreenhouseManager;
import forestry.api.greenhouse.IGreenhouseAccess;
import forestry.api.recipes.RecipeManagers;
import forestry.core.PluginCore;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumElectronTube;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.greenhouse.EventHandlerGreenhouse;
import forestry.greenhouse.GreenhouseAccess;
import forestry.greenhouse.GreenhouseHelper;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.blocks.BlockRegistryGreenhouse;
import forestry.greenhouse.logics.GreenhouseLogicGreenhouseDoor;
import forestry.greenhouse.logics.GreenhouseLogicGreenhouseEffect;
import forestry.greenhouse.network.PacketRegistryGreenhouse;
import forestry.greenhouse.proxy.ProxyGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouseButterflyHatch;
import forestry.greenhouse.tiles.TileGreenhouseControl;
import forestry.greenhouse.tiles.TileGreenhouseDoor;
import forestry.greenhouse.tiles.TileGreenhouseDryer;
import forestry.greenhouse.tiles.TileGreenhouseFan;
import forestry.greenhouse.tiles.TileGreenhouseGearbox;
import forestry.greenhouse.tiles.TileGreenhouseHatch;
import forestry.greenhouse.tiles.TileGreenhouseHeater;
import forestry.greenhouse.tiles.TileGreenhousePlain;
import forestry.greenhouse.tiles.TileGreenhouseSprinkler;
import forestry.greenhouse.tiles.TileGreenhouseValve;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.registry.GameRegistry;

@ForestryPlugin(pluginID="forestry.greenhouse", name="Greenhouse", author="Nedelosk", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.greenhouse.description")
public class PluginGreenhouse
extends BlankForestryPlugin {
    @SidedProxy(clientSide="forestry.greenhouse.proxy.ProxyGreenhouseClient", serverSide="forestry.greenhouse.proxy.ProxyGreenhouse")
    public static ProxyGreenhouse proxy;
    public static BlockRegistryGreenhouse blocks;

    @Override
    public void setupAPI() {
        GreenhouseManager.greenhouseAccess = new GreenhouseAccess();
        GreenhouseManager.greenhouseHelper = new GreenhouseHelper();
    }

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistryGreenhouse();
    }

    @Override
    public void registerRecipes() {
        BlockGreenhouse greenhousePlainBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN);
        RecipeUtil.addRecipe(greenhousePlainBlock, "###", "#X#", "###", Character.valueOf('X'), Blocks.field_150336_V, Character.valueOf('#'), PluginCore.items.craftingMaterial.getCamouflagedPaneling());
        BlockGreenhouse greenhouseGlassBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.GLASS);
        RecipeUtil.addRecipe(greenhouseGlassBlock, "###", "#X#", "###", Character.valueOf('X'), "blockGlass", Character.valueOf('#'), PluginCore.items.craftingMaterial.getCamouflagedPaneling());
        BlockGreenhouse greenhouseHatchInputBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.HATCH_INPUT);
        RecipeUtil.addRecipe(greenhouseHatchInputBlock, "TXT", "#H#", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('H'), "trapdoorWood", Character.valueOf('#'), "gearTin", Character.valueOf('T'), PluginCore.items.tubes.get(EnumElectronTube.BRONZE, 1));
        BlockGreenhouse greenhouseHatchOutputBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.HATCH_OUTPUT);
        RecipeUtil.addRecipe(greenhouseHatchOutputBlock, "#H#", "TXT", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('H'), "trapdoorWood", Character.valueOf('#'), "gearTin", Character.valueOf('T'), PluginCore.items.tubes.get(EnumElectronTube.BRONZE, 1));
        BlockGreenhouse greenhouseControlBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.CONTROL);
        RecipeUtil.addRecipe(greenhouseControlBlock, " X ", "#T#", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('#'), "dustRedstone", Character.valueOf('T'), PluginCore.items.tubes.get(EnumElectronTube.GOLD, 1));
        BlockGreenhouse greenhouseGearBoxBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.GEARBOX);
        RecipeUtil.addRecipe(greenhouseGearBoxBlock, " X ", "###", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('#'), "gearTin");
        BlockGreenhouse greenhouseValveBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.VALVE);
        RecipeUtil.addRecipe(greenhouseValveBlock, " X ", "#G#", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('#'), "blockGlass", Character.valueOf('G'), "gearTin");
        BlockGreenhouse greenhouseHeaterBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.HEATER);
        RecipeUtil.addRecipe(greenhouseHeaterBlock, "T#T", "#X#", "T#T", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('#'), "ingotGold", Character.valueOf('T'), PluginCore.items.tubes.get(EnumElectronTube.GOLD, 1));
        BlockGreenhouse greenhouseFanlock = blocks.getGreenhouseBlock(BlockGreenhouseType.FAN);
        RecipeUtil.addRecipe(greenhouseFanlock, "T#T", "#X#", "T#T", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('#'), "ingotTin", Character.valueOf('T'), PluginCore.items.tubes.get(EnumElectronTube.TIN, 1));
        BlockGreenhouse greenhouseDryerBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.DRYER);
        RecipeUtil.addRecipe(greenhouseDryerBlock, "T#T", "#X#", "T#T", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.PLAIN), Character.valueOf('#'), "ingotBronze", Character.valueOf('T'), PluginCore.items.tubes.get(EnumElectronTube.BLAZE, 1));
        BlockGreenhouse greenhouseSprinklerBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.SPRINKLER);
        RecipeUtil.addRecipe(greenhouseSprinklerBlock, "TXT", " I ", "III", Character.valueOf('X'), blocks.getGreenhouseBlock(BlockGreenhouseType.GLASS), Character.valueOf('I'), "ingotIron", Character.valueOf('T'), PluginCore.items.tubes.get(EnumElectronTube.LAPIS, 1));
        BlockGreenhouse greenhouseDoorBlock = blocks.getGreenhouseBlock(BlockGreenhouseType.DOOR);
        RecipeUtil.addRecipe(greenhouseDoorBlock, true, "GG ", "GG ", "GG ", Character.valueOf('G'), blocks.getGreenhouseBlock(BlockGreenhouseType.GLASS));
        if (ForestryAPI.enabledPlugins.contains("forestry.factory")) {
            RecipeManagers.carpenterManager.addRecipe(50, Fluids.BIOMASS.getFluid(500), null, PluginCore.items.craftingMaterial.getCamouflagedPaneling(), " A ", "###", "RPR", Character.valueOf('#'), "plankWood", Character.valueOf('A'), "dustAsh", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), "pulpWood");
        }
    }

    @Override
    public void doInit() {
        super.doInit();
        GameRegistry.registerTileEntity(TileGreenhouseFan.class, (String)"forestry.GreenhouseFan");
        GameRegistry.registerTileEntity(TileGreenhouseHeater.class, (String)"forestry.GreenhouseHeater");
        GameRegistry.registerTileEntity(TileGreenhouseDryer.class, (String)"forestry.GreenhouseDryer");
        GameRegistry.registerTileEntity(TileGreenhouseSprinkler.class, (String)"forestry.GreenhouseSprinkler");
        GameRegistry.registerTileEntity(TileGreenhouseValve.class, (String)"forestry.GreenhouseValve");
        GameRegistry.registerTileEntity(TileGreenhouseGearbox.class, (String)"forestry.GreenhouseGearbox");
        GameRegistry.registerTileEntity(TileGreenhouseControl.class, (String)"forestry.GreenhouseController");
        GameRegistry.registerTileEntity(TileGreenhousePlain.class, (String)"forestry.GreenhousePlain");
        GameRegistry.registerTileEntity(TileGreenhouseDoor.class, (String)"forestry.GreenhouseDoor");
        GameRegistry.registerTileEntity(TileGreenhouseHatch.class, (String)"forestry.GreenhouseHatch");
        if (ForestryAPI.enabledPlugins.contains("forestry.lepidopterology")) {
            GameRegistry.registerTileEntity(TileGreenhouseButterflyHatch.class, (String)"forestry.GreenhouseButterflyHatch");
        }
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerGreenhouse());
        IGreenhouseAccess greenhouseAccess = GreenhouseManager.greenhouseAccess;
        greenhouseAccess.registerGreenhouseGlass(new ItemStack(Blocks.field_150359_w, 1, 0), 0.5f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 0), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 1), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 2), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 3), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 4), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 5), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 6), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 7), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 8), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 9), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 10), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 11), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 12), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 13), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 14), 0.25f);
        greenhouseAccess.registerGreenhouseGlass(new ItemStack((Block)Blocks.field_150399_cn, 1, 15), 0.25f);
        proxy.initializeModels();
        GreenhouseManager.greenhouseLogics.add(GreenhouseLogicGreenhouseEffect.class);
        GreenhouseManager.greenhouseLogics.add(GreenhouseLogicGreenhouseDoor.class);
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryGreenhouse();
    }
}

