/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.inventory.wrappers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.text.ITextComponent;

/**
 * @author CovertJaguar <http://www.railcraft.info/>
 */
public class ChestWrapper implements IInventory {

	/**
	 * Inventory object corresponding to double chest upper part
	 */
	private final TileEntityChest upperChest;
	/**
	 * Inventory object corresponding to double chest lower part
	 */
	private TileEntityChest lowerChest;

	public ChestWrapper(TileEntityChest tile) {
		this.upperChest = tile;
		checkChest();
	}

	private void checkChest() {
		if (lowerChest == null || lowerChest.func_145837_r()) {
			if (upperChest.field_145991_k != null) {
				lowerChest = upperChest.field_145991_k;
			} else if (upperChest.field_145990_j != null) {
				lowerChest = upperChest.field_145990_j;
			} else if (upperChest.field_145992_i != null) {
				lowerChest = upperChest.field_145992_i;
			} else if (upperChest.field_145988_l != null) {
				lowerChest = upperChest.field_145988_l;
			} else {
				lowerChest = null;
			}
		}
	}

	/**
	 * Returns the number of slots in the inventory.
	 */
	@Override
	public int func_70302_i_() {
		checkChest();
		int size = upperChest.func_70302_i_();
		if (lowerChest != null) {
			size += lowerChest.func_70302_i_();
		}
		return size;
	}

	/**
	 * Return whether the given inventory is part of this large chest.
	 */
	public boolean isPartOfLargeChest(IInventory inv) {
		return this.upperChest == inv || this.lowerChest == inv;
	}

	/**
	 * Returns the name of the inventory.
	 */
	@Override
	public String func_70005_c_() {
		return "";
	}
	
	@Override
	public ITextComponent func_145748_c_() {
		return null;
	}

	/**
	 * If this returns false, the inventory name will be used as an unlocalized
	 * name, and translated into the player's language. Otherwise it will be
	 * used directly.
	 */
	@Override
	public boolean func_145818_k_() {
		return false;
	}

	/**
	 * Returns the stack in slot i
	 */
	@Override
	public ItemStack func_70301_a(int slot) {
		checkChest();
		if (slot >= upperChest.func_70302_i_() && lowerChest != null) {
			return lowerChest.func_70301_a(slot - upperChest.func_70302_i_());
		}
		return upperChest.func_70301_a(slot);
	}

	/**
	 * Removes from an inventory slot (first arg) up to a specified number
	 * (second arg) of items and returns them in a new stack.
	 */
	@Override
	public ItemStack func_70298_a(int slot, int amout) {
		checkChest();
		if (slot >= upperChest.func_70302_i_() && lowerChest != null) {
			return lowerChest.func_70298_a(slot - upperChest.func_70302_i_(), amout);
		}
		return upperChest.func_70298_a(slot, amout);
	}

	/**
	 * When some containers are closed they call this on each slot, then drop
	 * whatever it returns as an EntityItem - like when you close a workbench
	 * GUI.
	 */
	@Override
	public ItemStack func_70304_b(int slot) {
		checkChest();
		if (slot >= upperChest.func_70302_i_() && lowerChest != null) {
			return lowerChest.func_70304_b(slot - upperChest.func_70302_i_());
		}
		return upperChest.func_70304_b(slot);
	}

	/**
	 * Sets the given item stack to the specified slot in the inventory (can be
	 * crafting or armor sections).
	 */
	@Override
	public void func_70299_a(int slot, ItemStack stack) {
		checkChest();
		if (slot >= this.upperChest.func_70302_i_() && lowerChest != null) {
			lowerChest.func_70299_a(slot - upperChest.func_70302_i_(), stack);
		} else {
			upperChest.func_70299_a(slot, stack);
		}
	}

	/**
	 * Returns the maximum stack size for a inventory slot. Seems to always be
	 * 64, possibly will be extended. *Isn't this more of a set than a get?*
	 */
	@Override
	public int func_70297_j_() {
		return this.upperChest.func_70297_j_();
	}

	/**
	 * Called when an the contents of an Inventory change, usually
	 */
	@Override
	public void func_70296_d() {
		this.upperChest.func_70296_d();
		if (lowerChest != null) {
			lowerChest.func_70296_d();
		}
	}

	/**
	 * Do not make give this method the name canInteractWith because it clashes
	 * with Container
	 */
	@Override
	public boolean func_70300_a(EntityPlayer player) {
		return this.upperChest.func_70300_a(player) && (lowerChest == null || lowerChest.func_70300_a(player));
	}

	@Override
	public void func_174889_b(EntityPlayer player) {
		this.upperChest.func_174889_b(player);
		if (lowerChest != null) {
			lowerChest.func_174889_b(player);
		}
	}

	@Override
	public void func_174886_c(EntityPlayer player) {
		this.upperChest.func_174886_c(player);
		if (lowerChest != null) {
			lowerChest.func_174886_c(player);
		}
	}

	/**
	 * Returns true if automation is allowed to insert the given stack (ignoring
	 * stack size) into the given slot.
	 */
	@Override
	public boolean func_94041_b(int slot, ItemStack stack) {
		return true;
	}

	@Override
	public int func_174887_a_(int id) {
		return 0;
	}

	@Override
	public void func_174885_b(int id, int value) {
	}

	@Override
	public int func_174890_g() {
		return 0;
	}

	@Override
	public void func_174888_l() {
	}

}
