/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.core.fluids.ITankManager;
import forestry.core.tiles.ILocatable;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public interface ILiquidTankTile
extends ILocatable,
IFluidHandler {
    @Nonnull
    public ITankManager getTankManager();

    default public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.getTankManager().fill(resource, doFill);
    }

    default public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.getTankManager().drain(resource, doDrain);
    }

    default public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.getTankManager().drain(maxDrain, doDrain);
    }

    default public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.getTankManager().canFillFluidType(new FluidStack(fluid, 1000));
    }

    default public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.getTankManager().canDrainFluidType(new FluidStack(fluid, 1000));
    }

    default public FluidTankInfo[] getTankInfo(EnumFacing from) {
        IFluidTankProperties[] tankProperties = this.getTankManager().getTankProperties();
        FluidTankInfo[] tankInfos = new FluidTankInfo[tankProperties.length];
        for (int i = 0; i < tankProperties.length; ++i) {
            IFluidTankProperties fluidTankProperties = tankProperties[i];
            tankInfos[i] = new FluidTankInfo(fluidTankProperties.getContents(), fluidTankProperties.getCapacity());
        }
        return tankInfos;
    }
}

