/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.lepidopterology.render;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public class ModelButterfly extends ModelBase {

	private final ModelRenderer wingRight;
	private final ModelRenderer eyeRight;
	private final ModelRenderer eyeLeft;
	private final ModelRenderer wingLeft;
	private final ModelRenderer body;

	private float scale;

	public ModelButterfly() {
		field_78090_t = 64;
		field_78089_u = 32;

		wingRight = new ModelRenderer(this, 0, 0);
		wingRight.func_78789_a(-7F, 0F, -6F, 7, 1, 13);
		wingRight.func_78793_a(-0.5F, 0.5F, 0F);
		wingRight.func_78787_b(64, 32);
		wingRight.field_78809_i = true;
		setRotation(wingRight, 0F, 0F, 0F);
		eyeRight = new ModelRenderer(this, 40, 9);
		eyeRight.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		eyeRight.func_78793_a(-1.1F, -0.5F, -4.5F);
		eyeRight.func_78787_b(64, 32);
		eyeRight.field_78809_i = true;
		setRotation(eyeRight, 0F, 0F, 0F);
		eyeLeft = new ModelRenderer(this, 40, 7);
		eyeLeft.func_78789_a(0F, 0F, 0F, 1, 1, 1);
		eyeLeft.func_78793_a(0.1F, -0.5F, -4.5F);
		eyeLeft.func_78787_b(64, 32);
		eyeLeft.field_78809_i = true;
		setRotation(eyeLeft, 0F, 0F, 0F);
		wingLeft = new ModelRenderer(this, 0, 14);
		wingLeft.func_78789_a(0F, 0F, -6F, 7, 1, 13);
		wingLeft.func_78793_a(0.5F, 0.5F, 0F);
		wingLeft.func_78787_b(64, 32);
		wingLeft.field_78809_i = true;
		setRotation(wingLeft, 0F, 0F, 0F);
		body = new ModelRenderer(this, 40, 0);
		body.func_78789_a(0F, 0F, -4F, 1, 1, 6);
		body.func_78793_a(0F, 0F, 0F);
		body.func_78787_b(64, 32);
		body.field_78809_i = true;
		setRotation(body, 0F, 0F, 0.7853982F);
	}

	public void setScale(float scale) {
		this.scale = scale;
	}

	@Override
	public void func_78088_a(Entity entity, float f, float f1, float swing, float f3, float f4, float f5) {
		super.func_78088_a(entity, f, f1, swing, f3, f4, f5);

		//body.rotateAngleX = ((float)Math.PI / 4F) + MathHelper.cos(swing * 0.1F) * 0.15F;
		//body.rotateAngleY = 0.0F;
		wingRight.field_78808_h = MathHelper.func_76134_b(swing * 1.3F) * (float) Math.PI * 0.25F;
		wingLeft.field_78808_h = -wingRight.field_78808_h;

		GlStateManager.func_179094_E();
		GlStateManager.func_179152_a(scale, scale, scale);
		GlStateManager.func_179109_b(0.0F, 20.0f / scale * f5, 0.0F);
		wingRight.func_78785_a(f5);
		eyeRight.func_78785_a(f5);
		eyeLeft.func_78785_a(f5);
		wingLeft.func_78785_a(f5);
		body.func_78785_a(f5);
		GlStateManager.func_179121_F();

	}

	private static void setRotation(ModelRenderer model, float x, float y, float z) {
		model.field_78795_f = x;
		model.field_78796_g = y;
		model.field_78808_h = z;
	}

}
