package forestry.core.utils;

import java.util.IllegalFormatException;

import net.minecraft.util.text.translation.I18n;

public class Translator {
	private Translator() {

	}

	public static String translateToLocal(String key) {
		if (I18n.func_94522_b(key)) {
			return I18n.func_74838_a(key);
		} else {
			return I18n.func_150826_b(key);
		}
	}

	public static boolean canTranslateToLocal(String key) {
		return I18n.func_94522_b(key);
	}

	public static String translateToLocalFormatted(String key, Object... format) {
		String s = translateToLocal(key);
		try {
			return String.format(s, format);
		} catch (IllegalFormatException e) {
			String errorMessage = "Format error: " + s;
			Log.error(errorMessage, e);
			return errorMessage;
		}
	}
}
