/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.ILocatable;
import forestry.core.errors.ErrorLogic;
import forestry.core.gui.IGuiHandlerTile;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.AdjacentTileCache;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.tiles.ITitled;
import forestry.core.utils.NBTUtilForestry;
import forestry.core.utils.TickHelper;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileForestry
extends TileEntity
implements IStreamable,
IErrorLogicSource,
ISidedInventory,
IFilterSlotDelegate,
ITitled,
ILocatable,
IGuiHandlerTile,
ITickable {
    private final ErrorLogic errorHandler = new ErrorLogic();
    private final AdjacentTileCache tileCache = new AdjacentTileCache(this);
    @Nonnull
    private IInventoryAdapter inventory = FakeInventoryAdapter.instance();
    private final TickHelper tickHelper = new TickHelper();
    private boolean needsNetworkUpdate = false;

    protected AdjacentTileCache getTileCache() {
        return this.tileCache;
    }

    public void onNeighborTileChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        this.tileCache.onNeighborChange();
    }

    public void func_145843_s() {
        this.tileCache.purge();
        super.func_145843_s();
    }

    public void func_145829_t() {
        this.tileCache.purge();
        super.func_145829_t();
    }

    public final void func_73660_a() {
        this.tickHelper.onTick();
        if (!this.field_145850_b.field_72995_K) {
            this.updateServerSide();
        } else {
            this.updateClientSide();
        }
        if (this.needsNetworkUpdate) {
            this.needsNetworkUpdate = false;
            this.sendNetworkUpdate();
        }
    }

    protected void updateClientSide() {
    }

    protected void updateServerSide() {
    }

    protected final boolean updateOnInterval(int tickInterval) {
        return this.tickHelper.updateOnInterval(tickInterval);
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inventory.readFromNBT(data);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        this.inventory.writeToNBT(data);
        return data;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        return NBTUtilForestry.writeStreamableToNbt(this, tag);
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        NBTUtilForestry.readStreamableFromNbt(this, tag);
    }

    protected final void sendNetworkUpdate() {
        PacketTileStream packet = new PacketTileStream(this);
        Proxies.net.sendNetworkPacket(packet, this.field_145850_b);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
    }

    public void onRemoval() {
    }

    @Override
    public World getWorldObj() {
        return this.field_145850_b;
    }

    protected boolean isRedstoneActivated() {
        return this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
    }

    protected final void setNeedsNetworkUpdate() {
        this.needsNetworkUpdate = true;
    }

    @Override
    public final IErrorLogic getErrorLogic() {
        return this.errorHandler;
    }

    @Override
    public String getUnlocalizedTitle() {
        String blockUnlocalizedName = this.func_145838_q().func_149739_a();
        return blockUnlocalizedName + '.' + this.func_145832_p() + ".name";
    }

    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    protected final void setInternalInventory(IInventoryAdapter inv) {
        if (inv == null) {
            throw new NullPointerException("Inventory cannot be null");
        }
        this.inventory = inv;
    }

    public final int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public final ItemStack func_70301_a(int slotIndex) {
        return this.getInternalInventory().func_70301_a(slotIndex);
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInternalInventory().func_70298_a(slotIndex, amount);
    }

    public ItemStack func_70304_b(int slotIndex) {
        return this.getInternalInventory().func_70304_b(slotIndex);
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(slotIndex, itemstack);
    }

    public final int func_70297_j_() {
        return this.getInternalInventory().func_70297_j_();
    }

    public final void func_174889_b(EntityPlayer player) {
        this.getInternalInventory().func_174889_b(player);
    }

    public final void func_174886_c(EntityPlayer player) {
        this.getInternalInventory().func_174886_c(player);
    }

    public String func_70005_c_() {
        return this.getUnlocalizedTitle();
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.getUnlocalizedTitle(), new Object[0]);
    }

    public final boolean func_70300_a(EntityPlayer player) {
        return this.getInternalInventory().func_70300_a(player);
    }

    public boolean func_145818_k_() {
        return this.getInternalInventory().func_145818_k_();
    }

    public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().func_94041_b(slotIndex, itemStack);
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.getInternalInventory().func_180463_a(side);
    }

    public final boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return this.getInternalInventory().func_180462_a(slotIndex, itemStack, side);
    }

    public final boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return this.getInternalInventory().func_180461_b(slotIndex, itemStack, side);
    }

    @Override
    public final BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public void func_174888_l() {
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory != null) {
            if (facing != null) {
                SidedInvWrapper sidedInvWrapper = new SidedInvWrapper((ISidedInventory)this.inventory, facing);
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)sidedInvWrapper);
            }
            InvWrapper invWrapper = new InvWrapper((IInventory)this.inventory);
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)invWrapper);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

