/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.core.IBlockPosPredicate;
import forestry.api.genetics.IFlowerAcceptableRule;
import forestry.api.genetics.IFlowerGrowthHelper;
import forestry.api.genetics.IFlowerGrowthRule;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.flowers.Flower;
import forestry.apiculture.flowers.GrowthRuleDirtGrass;
import forestry.apiculture.flowers.GrowthRuleFertilize;
import forestry.apiculture.flowers.GrowthRuleMycelium;
import forestry.apiculture.flowers.GrowthRuleNone;
import forestry.apiculture.flowers.GrowthRuleSnow;
import forestry.core.utils.BlockStateSet;
import forestry.core.utils.Log;
import forestry.core.utils.VectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class FlowerRegistry
implements IFlowerRegistry,
IFlowerGrowthHelper {
    private final Set<String> defaultFlowerTypes = ImmutableSet.of((Object)"flowersVanilla", (Object)"flowersNether", (Object)"flowersCacti", (Object)"flowersMushrooms", (Object)"flowersEnd", (Object)"flowersJungle", (Object[])new String[]{"flowersSnow", "flowersWheat", "flowersGourd"});
    private final HashMultimap<String, IFlowerAcceptableRule> registeredRules = HashMultimap.create();
    private final HashMultimap<String, Block> acceptableBlocks = HashMultimap.create();
    private final Map<String, BlockStateSet> acceptableBlockStates = new HashMap<String, BlockStateSet>();
    private final HashMultimap<String, Flower> plantableFlowers = HashMultimap.create();
    private final ArrayListMultimap<String, IFlowerGrowthRule> growthRules = ArrayListMultimap.create();
    private final Map<String, TreeMap<Double, Flower>> chances = new HashMap<String, TreeMap<Double, Flower>>();

    public FlowerRegistry() {
        this.registerVanillaGrowthRules();
    }

    @Override
    public void registerAcceptableFlower(Block block, String ... flowerTypes) {
        for (String flowerType : flowerTypes) {
            if (flowerType == null) {
                throw new NullPointerException("Tried to register flower with null type. " + block);
            }
            this.acceptableBlocks.get((Object)flowerType).add(block);
        }
    }

    @Override
    public void registerAcceptableFlower(IBlockState blockState, String ... flowerTypes) {
        for (String flowerType : flowerTypes) {
            if (flowerType == null) {
                throw new NullPointerException("Tried to register flower with null type. " + blockState);
            }
            this.getAcceptedBlockStates(flowerType).add(blockState);
        }
    }

    @Override
    public void registerAcceptableFlowerRule(IFlowerAcceptableRule acceptableFlower, String ... flowerTypes) {
        for (String flowerType : flowerTypes) {
            if (flowerType == null) {
                throw new NullPointerException("Tried to register flower with null type. " + acceptableFlower);
            }
            this.registeredRules.put((Object)flowerType, (Object)acceptableFlower);
        }
    }

    @Override
    public void registerPlantableFlower(IBlockState blockState, double weight, String ... flowerTypes) {
        if (blockState == null) {
            return;
        }
        if (weight <= 0.0) {
            weight = 0.0;
        }
        if (weight >= 1.0) {
            weight = 1.0;
        }
        if (blockState.func_177230_c() == Blocks.field_150350_a) {
            Log.error("Tried to register AIR as a flower. Bad idea.", new Object[0]);
        }
        Flower newFlower = new Flower(blockState, weight);
        for (String flowerType : flowerTypes) {
            if (flowerType == null) {
                throw new NullPointerException("Tried to register flower with null type. " + blockState);
            }
            Set flowers = this.plantableFlowers.get((Object)flowerType);
            flowers.add(newFlower);
            Set<IBlockState> blocks = this.getAcceptedBlockStates(flowerType);
            blocks.add(blockState);
            if (!this.chances.containsKey(flowerType)) continue;
            this.chances.remove(flowerType);
        }
    }

    private static Vec3i getArea(IBeeGenome genome, IBeeModifier beeModifier) {
        Vec3i genomeTerritory = genome.getTerritory();
        float housingModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        return VectUtil.scale(genomeTerritory, housingModifier * 3.0f);
    }

    @Override
    @Nonnull
    public List<BlockPos> getAcceptedFlowerCoordinates(IBeeHousing beeHousing, IBee bee, String flowerType, int maxFlowers) {
        ArrayList<BlockPos> flowerCoords = new ArrayList<BlockPos>();
        World world = beeHousing.getWorldObj();
        IBlockPosPredicate acceptedFlowerPredicate = this.createAcceptedFlowerPredicate(flowerType);
        Iterator<BlockPos.MutableBlockPos> areaIterator = this.getAreaIterator(beeHousing, bee);
        while (areaIterator.hasNext() && flowerCoords.size() < maxFlowers) {
            BlockPos.MutableBlockPos pos = areaIterator.next();
            if (!acceptedFlowerPredicate.test(world, (BlockPos)pos)) continue;
            flowerCoords.add(pos.func_185334_h());
        }
        return flowerCoords;
    }

    @Override
    public Iterator<BlockPos.MutableBlockPos> getAreaIterator(IBeeHousing beeHousing, IBee bee) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(beeHousing);
        Vec3i area = FlowerRegistry.getArea(bee.getGenome(), beeModifier);
        BlockPos minPos = beeHousing.getCoordinates().func_177982_a(-area.func_177958_n() / 2, -area.func_177956_o() / 2, -area.func_177952_p() / 2);
        BlockPos maxPos = minPos.func_177971_a(area);
        World world = beeHousing.getWorldObj();
        return VectUtil.getAllInBoxFromCenterMutable(world, minPos, beeHousing.getCoordinates(), maxPos);
    }

    @Override
    @Deprecated
    public boolean isAcceptedFlower(String flowerType, World world, BlockPos pos) {
        if (!world.func_175667_e(pos)) {
            return true;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Set acceptedCustom = this.registeredRules.get((Object)flowerType);
        for (IFlowerAcceptableRule acceptableFlower : acceptedCustom) {
            if (!acceptableFlower.isAcceptableFlower(blockState, world, pos, flowerType)) continue;
            return true;
        }
        Set<IBlockState> acceptedBlockStates = this.getAcceptedBlockStates(flowerType);
        Set acceptedBlocks = this.acceptableBlocks.get((Object)flowerType);
        return FlowerRegistry.isAcceptedFlower(blockState, acceptedBlocks, acceptedBlockStates);
    }

    private Set<IBlockState> getAcceptedBlockStates(String flowerType) {
        return this.acceptableBlockStates.computeIfAbsent(flowerType, k -> new BlockStateSet());
    }

    @Override
    public IBlockPosPredicate createAcceptedFlowerPredicate(String flowerType) {
        Set acceptableRules = this.registeredRules.get((Object)flowerType);
        Set<IBlockState> acceptedBlockStates = this.getAcceptedBlockStates(flowerType);
        Set acceptedBlocks = this.acceptableBlocks.get((Object)flowerType);
        return new AcceptedFlowerPredicate(flowerType, acceptableRules, acceptedBlocks, acceptedBlockStates);
    }

    private static boolean isAcceptedFlower(IBlockState blockState, Set<Block> acceptedBlocks, Set<IBlockState> acceptedBlockStates) {
        Block block = blockState.func_177230_c();
        return acceptedBlocks.contains(block) || acceptedBlockStates.contains(blockState);
    }

    @Override
    public boolean growFlower(String flowerType, World world, IIndividual individual, BlockPos pos) {
        if (!this.growthRules.containsKey((Object)flowerType)) {
            return false;
        }
        for (IFlowerGrowthRule rule : this.growthRules.get((Object)flowerType)) {
            if (!rule.growFlower(this, flowerType, world, pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void registerGrowthRule(IFlowerGrowthRule rule, String ... flowerTypes) {
        if (rule == null) {
            return;
        }
        for (String flowerType : flowerTypes) {
            this.growthRules.get((Object)flowerType).add(rule);
        }
    }

    public Flower getRandomPlantableFlower(String flowerType, Random rand) {
        TreeMap<Double, Flower> chancesMap = this.getChancesMap(flowerType);
        double maxKey = chancesMap.lastKey() + 1.0;
        return chancesMap.get(chancesMap.lowerKey(rand.nextDouble() * maxKey));
    }

    private TreeMap<Double, Flower> getChancesMap(String flowerType) {
        if (!this.chances.containsKey(flowerType)) {
            TreeMap<Double, Flower> flowerChances = new TreeMap<Double, Flower>();
            double count = 0.0;
            for (Flower flower : this.plantableFlowers.get((Object)flowerType)) {
                if (!flower.isPlantable()) continue;
                flowerChances.put(count, flower);
                count += flower.getWeight();
            }
            this.chances.put(flowerType, flowerChances);
        }
        return this.chances.get(flowerType);
    }

    private void registerVanillaGrowthRules() {
        this.registerGrowthRule(new GrowthRuleDirtGrass(), "flowersVanilla", "flowersSnow");
        this.registerGrowthRule(new GrowthRuleSnow(), "flowersSnow");
        this.registerGrowthRule(new GrowthRuleMycelium(), "flowersMushrooms");
        this.registerGrowthRule(new GrowthRuleNone(), "flowersEnd");
        this.registerGrowthRule(new GrowthRuleFertilize(Blocks.field_150394_bc, Blocks.field_150393_bb), "flowersGourd");
        this.registerGrowthRule(new GrowthRuleFertilize(Blocks.field_150464_aj), "flowersWheat");
    }

    @Override
    public boolean plantRandomFlower(String flowerType, World world, BlockPos pos) {
        Flower flower = this.getRandomPlantableFlower(flowerType, world.field_73012_v);
        return world.func_175656_a(pos, flower.getBlockState());
    }

    private static class AcceptedFlowerPredicate
    implements IBlockPosPredicate {
        private final String flowerType;
        private final Set<IFlowerAcceptableRule> acceptableRules;
        private final Set<Block> acceptedBlocks;
        private final Set<IBlockState> acceptedBlockStates;

        public AcceptedFlowerPredicate(String flowerType, Set<IFlowerAcceptableRule> acceptableRules, Set<Block> acceptedBlocks, Set<IBlockState> acceptedBlockStates) {
            this.flowerType = flowerType;
            this.acceptableRules = acceptableRules;
            this.acceptedBlocks = acceptedBlocks;
            this.acceptedBlockStates = acceptedBlockStates;
        }

        @Override
        public boolean test(World world, BlockPos blockPos) {
            IBlockState blockState;
            if (world.func_175667_e(blockPos) && !(blockState = world.func_180495_p(blockPos)).func_177230_c().isAir(blockState, (IBlockAccess)world, blockPos)) {
                for (IFlowerAcceptableRule acceptableRule : this.acceptableRules) {
                    if (!acceptableRule.isAcceptableFlower(blockState, world, blockPos, this.flowerType)) continue;
                    return true;
                }
                if (FlowerRegistry.isAcceptedFlower(blockState, this.acceptedBlocks, this.acceptedBlockStates)) {
                    return true;
                }
            }
            return false;
        }
    }
}

