/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.HasFlowersCache;
import forestry.apiculture.network.packets.PacketBeeLogicActive;
import forestry.apiculture.tiles.TileHive;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.TickHelper;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldgenBeekeepingLogic
implements IBeekeepingLogic {
    private final TileHive housing;
    private IEffectData[] effectData = new IEffectData[2];
    private final HasFlowersCache hasFlowersCache = new HasFlowersCache();
    private final TickHelper tickHelper = new TickHelper();
    private boolean active;

    public WorldgenBeekeepingLogic(TileHive housing) {
        this.housing = housing;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.setActive(nbttagcompound.func_74767_n("Active"));
        this.hasFlowersCache.readFromNBT(nbttagcompound);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("Active", this.active);
        this.hasFlowersCache.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeBoolean(this.active);
        if (this.active) {
            this.hasFlowersCache.writeData(data);
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        boolean active = data.readBoolean();
        this.setActive(active);
        if (active) {
            this.hasFlowersCache.readData(data);
        }
    }

    private void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        this.syncToClient();
    }

    @Override
    public boolean canWork() {
        this.tickHelper.onTick();
        IBee queen = this.housing.getContainedBee();
        this.hasFlowersCache.update(queen, this.housing);
        if (this.tickHelper.updateOnInterval(200)) {
            World world = this.housing.getWorldObj();
            boolean canWork = !(!world.func_72935_r() && !queen.getGenome().getNeverSleeps() || this.housing.isRaining() && !queen.getGenome().getToleratesRain());
            boolean flowerCacheNeedsSync = this.hasFlowersCache.needsSync();
            if (this.active != canWork) {
                this.setActive(canWork);
            } else if (flowerCacheNeedsSync) {
                this.syncToClient();
            }
        }
        return this.active;
    }

    @Override
    public void doWork() {
    }

    @Override
    public void clearCachedValues() {
        if (!this.housing.getWorldObj().field_72995_K) {
            this.hasFlowersCache.clear();
            this.canWork();
        }
    }

    @Override
    public void syncToClient() {
        World world = this.housing.getWorldObj();
        if (world != null && !world.field_72995_K) {
            Proxies.net.sendNetworkPacket(new PacketBeeLogicActive(this.housing), world);
        }
    }

    @Override
    public void syncToClient(EntityPlayerMP player) {
        World world = this.housing.getWorldObj();
        if (world != null && !world.field_72995_K) {
            Proxies.net.sendToPlayer(new PacketBeeLogicActive(this.housing), (EntityPlayer)player);
        }
    }

    @Override
    public int getBeeProgressPercent() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canDoBeeFX() {
        return !Minecraft.func_71410_x().func_147113_T() && this.active;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doBeeFX() {
        IBee queen = this.housing.getContainedBee();
        queen.doFX(this.effectData, this.housing);
    }

    @Override
    public List<BlockPos> getFlowerPositions() {
        return this.hasFlowersCache.getFlowerCoords();
    }
}

