/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyTransferMode;
import forestry.energy.compat.EnergyStorageWrapper;
import forestry.energy.compat.tesla.TeslaConsumerWrapper;
import forestry.energy.compat.tesla.TeslaHelper;
import forestry.energy.compat.tesla.TeslaHolderWrapper;
import forestry.energy.compat.tesla.TeslaProducerWrapper;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;

public class EnergyManager
extends EnergyStorage
implements IStreamable,
INbtReadable,
INbtWritable {
    @Nonnull
    private EnergyTransferMode externalMode = EnergyTransferMode.BOTH;

    public EnergyManager(int maxTransfer, int capacity) {
        super(EnergyHelper.scaleForDifficulty(capacity), EnergyHelper.scaleForDifficulty(maxTransfer), EnergyHelper.scaleForDifficulty(maxTransfer));
    }

    public void setExternalMode(@Nonnull EnergyTransferMode externalMode) {
        this.externalMode = externalMode;
    }

    @Nonnull
    public EnergyTransferMode getExternalMode() {
        return this.externalMode;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int energy;
        if (nbt.func_74764_b("EnergyManager")) {
            NBTTagCompound energyManagerNBT = nbt.func_74775_l("EnergyManager");
            NBTTagCompound energyStorageNBT = energyManagerNBT.func_74775_l("EnergyStorage");
            energy = energyStorageNBT.func_74762_e("Energy");
        } else {
            energy = nbt.func_74762_e("Energy");
        }
        this.setEnergyStored(energy);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Energy", this.energy);
        return nbt;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.energy);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        int energyStored = data.readVarInt();
        this.setEnergyStored(energyStored);
    }

    public int getMaxEnergyReceived() {
        return this.maxReceive;
    }

    public void drainEnergy(int amount) {
        this.setEnergyStored(this.energy - amount);
    }

    public void generateEnergy(int amount) {
        this.setEnergyStored(this.energy + amount);
    }

    public void setEnergyStored(int energyStored) {
        this.energy = energyStored;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public boolean hasCapability(Capability<?> capability) {
        if (capability == null) {
            return false;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        if (capability == TeslaHelper.TESLA_PRODUCER && this.externalMode.canExtract()) {
            return true;
        }
        if (capability == TeslaHelper.TESLA_CONSUMER && this.externalMode.canReceive()) {
            return true;
        }
        return capability == TeslaHelper.TESLA_HOLDER;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability) {
        if (capability == null) {
            return null;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            EnergyStorageWrapper energyStorage = new EnergyStorageWrapper(this, this.externalMode);
            return (T)CapabilityEnergy.ENERGY.cast((Object)energyStorage);
        }
        if (capability == TeslaHelper.TESLA_PRODUCER && this.externalMode.canExtract()) {
            return (T)TeslaHelper.TESLA_PRODUCER.cast((Object)new TeslaProducerWrapper(this));
        }
        if (capability == TeslaHelper.TESLA_CONSUMER && this.externalMode.canReceive()) {
            return (T)TeslaHelper.TESLA_CONSUMER.cast((Object)new TeslaConsumerWrapper(this));
        }
        if (capability == TeslaHelper.TESLA_HOLDER) {
            return (T)TeslaHelper.TESLA_HOLDER.cast((Object)new TeslaHolderWrapper(this));
        }
        return null;
    }
}

