/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes;

import forestry.api.recipes.IDescriptiveRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.factory.inventory.InventoryCraftingForestry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public abstract class RecipeUtil {
    public static void addFermenterRecipes(ItemStack resource, int fermentationValue, Fluids output) {
        if (RecipeManagers.fermenterManager == null) {
            return;
        }
        RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.0f, output.getFluid(1), new FluidStack(FluidRegistry.WATER, 1));
        if (FluidRegistry.isFluidRegistered((Fluid)Fluids.JUICE.getFluid())) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output.getFluid(1), Fluids.JUICE.getFluid(1));
        }
        if (FluidRegistry.isFluidRegistered((Fluid)Fluids.FOR_HONEY.getFluid())) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output.getFluid(1), Fluids.FOR_HONEY.getFluid(1));
        }
    }

    public static List getOreDictRecipeEquivalents(ItemStack itemStack) {
        int[] oreDictIds = OreDictionary.getOreIDs((ItemStack)itemStack);
        ArrayList<String> oreDictNames = new ArrayList<String>(oreDictIds.length);
        for (int oreId : oreDictIds) {
            String oreDictName = OreDictionary.getOreName((int)oreId);
            oreDictNames.add(oreDictName);
        }
        if (oreDictNames.isEmpty()) {
            return Collections.singletonList(itemStack);
        }
        return oreDictNames;
    }

    public static Object[] getCraftingRecipeAsArray(IDescriptiveRecipe recipe) {
        try {
            return RecipeUtil.getShapedRecipeAsArray(recipe.getWidth(), recipe.getHeight(), recipe.getIngredients(), recipe.func_77571_b());
        }
        catch (RuntimeException ex) {
            Log.warning("Exception while trying to parse an ItemStack[10] from an IRecipe:", ex);
            return null;
        }
    }

    private static Object[] getShapedRecipeAsArray(int width, int height, Object[] ingredients, ItemStack output) {
        Object[] result = new Object[10];
        for (int y = 0; y < height; ++y) {
            System.arraycopy(ingredients, y * width, result, y * 3, width);
        }
        result[9] = output;
        return result;
    }

    @Nullable
    public static InventoryCraftingForestry getCraftRecipe(InventoryCrafting originalCrafting, ItemStack[] availableItems, World world, IRecipe recipe) {
        ItemStack output;
        if (!recipe.func_77569_a(originalCrafting, world)) {
            return null;
        }
        ItemStack expectedOutput = recipe.func_77572_b(originalCrafting);
        if (expectedOutput == null) {
            return null;
        }
        InventoryCraftingForestry crafting = new InventoryCraftingForestry();
        ItemStack[] stockCopy = ItemStackUtil.condenseStacks(availableItems);
        for (int slot = 0; slot < originalCrafting.func_70302_i_(); ++slot) {
            ItemStack stackInSlot = originalCrafting.func_70301_a(slot);
            if (stackInSlot == null) continue;
            ItemStack equivalent = RecipeUtil.getCraftingEquivalent(stockCopy, originalCrafting, slot, world, recipe, expectedOutput);
            if (equivalent == null) {
                return null;
            }
            crafting.func_70299_a(slot, equivalent);
        }
        if (recipe.func_77569_a((InventoryCrafting)crafting, world) && ItemStack.func_77989_b((ItemStack)(output = recipe.func_77572_b((InventoryCrafting)crafting)), (ItemStack)expectedOutput)) {
            return crafting;
        }
        return null;
    }

    @Nullable
    private static ItemStack getCraftingEquivalent(ItemStack[] stockCopy, InventoryCrafting crafting, int slot, World world, IRecipe recipe, ItemStack expectedOutput) {
        ItemStack originalStack = crafting.func_70301_a(slot);
        for (ItemStack stockStack : stockCopy) {
            ItemStack output;
            if (stockStack == null || stockStack.field_77994_a <= 0) continue;
            ItemStack singleStockStack = ItemStackUtil.createCopyWithCount(stockStack, 1);
            crafting.func_70299_a(slot, singleStockStack);
            if (!recipe.func_77569_a(crafting, world) || !ItemStack.func_77989_b((ItemStack)(output = recipe.func_77572_b(crafting)), (ItemStack)expectedOutput)) continue;
            crafting.func_70299_a(slot, originalStack);
            return stockStack.func_77979_a(1);
        }
        crafting.func_70299_a(slot, originalStack);
        return null;
    }

    public static List<IRecipe> findMatchingRecipes(InventoryCrafting inventory, World world) {
        ArrayList<IRecipe> matchingRecipes = new ArrayList<IRecipe>();
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!recipe.func_77569_a(inventory, world)) continue;
            matchingRecipes.add(recipe);
        }
        return matchingRecipes;
    }

    public static void addRecipe(Block block, Object ... obj) {
        RecipeUtil.addRecipe(new ItemStack(block), obj);
    }

    public static void addRecipe(Item item, Object ... obj) {
        RecipeUtil.addRecipe(new ItemStack(item), obj);
    }

    public static void addRecipe(ItemStack itemstack, Object ... obj) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedRecipeCustom(itemstack, obj));
    }

    public static void addPriorityRecipe(ItemStack itemStack, Object ... obj) {
        CraftingManager.func_77594_a().func_77592_b().add(0, new ShapedRecipeCustom(itemStack, obj));
    }

    public static void addShapelessRecipe(Item item, Object ... obj) {
        RecipeUtil.addShapelessRecipe(new ItemStack(item), obj);
    }

    public static void addShapelessRecipe(ItemStack itemstack, Object ... obj) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(itemstack, obj));
    }

    public static void addSmelting(ItemStack res, Item prod, float xp) {
        RecipeUtil.addSmelting(res, new ItemStack(prod), xp);
    }

    public static void addSmelting(ItemStack res, ItemStack prod, float xp) {
        if (res == null || res.func_77973_b() == null) {
            throw new IllegalArgumentException("Tried to register smelting recipe with null input");
        }
        if (prod == null || prod.func_77973_b() == null) {
            throw new IllegalArgumentException("Tried to register smelting recipe with null output");
        }
        GameRegistry.addSmelting((ItemStack)res, (ItemStack)prod, (float)xp);
    }

    public static boolean matches(IDescriptiveRecipe recipe, IInventory inventoryCrafting) {
        Object[] recipeIngredients = recipe.getIngredients();
        int width = recipe.getWidth();
        int height = recipe.getHeight();
        return RecipeUtil.matches(recipeIngredients, width, height, inventoryCrafting);
    }

    public static boolean matches(Object[] recipeIngredients, int width, int height, IInventory inventoryCrafting) {
        ItemStack[][] resources = RecipeUtil.getResources(inventoryCrafting);
        return RecipeUtil.matches(recipeIngredients, width, height, resources);
    }

    public static ItemStack[][] getResources(IInventory inventoryCrafting) {
        ItemStack[][] resources = new ItemStack[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int k = i + j * 3;
                resources[i][j] = inventoryCrafting.func_70301_a(k);
            }
        }
        return resources;
    }

    public static boolean matches(Object[] recipeIngredients, int width, int height, ItemStack[][] resources) {
        for (int i = 0; i <= 3 - width; ++i) {
            for (int j = 0; j <= 3 - height; ++j) {
                if (RecipeUtil.checkMatch(recipeIngredients, width, height, resources, i, j, true)) {
                    return true;
                }
                if (!RecipeUtil.checkMatch(recipeIngredients, width, height, resources, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkMatch(Object[] recipeIngredients, int width, int height, ItemStack[][] resources, int xInGrid, int yInGrid, boolean mirror) {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                ItemStack resource = resources[k][l];
                int widthIt = k - xInGrid;
                int heightIt = l - yInGrid;
                Object recipeIngredient = null;
                if (widthIt >= 0 && heightIt >= 0 && widthIt < width && heightIt < height) {
                    recipeIngredient = mirror ? recipeIngredients[width - widthIt - 1 + heightIt * width] : recipeIngredients[widthIt + heightIt * width];
                }
                if (RecipeUtil.checkIngredientMatch(recipeIngredient, resource)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkIngredientMatch(Object recipeIngredient, ItemStack resource) {
        if (recipeIngredient == null && resource == null) {
            return true;
        }
        if (recipeIngredient instanceof ItemStack) {
            return ItemStackUtil.isCraftingEquivalent((ItemStack)recipeIngredient, resource);
        }
        if (recipeIngredient instanceof Iterable) {
            for (Object item : (Iterable)recipeIngredient) {
                if (!RecipeUtil.checkIngredientMatch(item, resource)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

