/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.IBlockPosPredicate;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.api.genetics.IFlowerProvider;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.utils.TickHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HasFlowersCache
implements INbtWritable,
INbtReadable,
IStreamable {
    private static final String NBT_KEY = "hasFlowerCache";
    private static final String NBT_KEY_FLOWERS = "flowers";
    private static final int FLOWER_CHECK_INTERVAL = 200;
    private final TickHelper tickHelper = new TickHelper();
    @Nullable
    private FlowerData flowerData;
    private final List<BlockPos> flowerCoords = new ArrayList<BlockPos>();
    private boolean needsSync = false;

    public void update(IBee queen, IBeeHousing beeHousing) {
        int flowerCount;
        int ticksPerCheck;
        if (this.flowerData == null) {
            this.flowerData = new FlowerData(queen, beeHousing);
            this.flowerCoords.clear();
        }
        World world = beeHousing.getWorldObj();
        this.tickHelper.onTick();
        if (!this.flowerCoords.isEmpty() && this.tickHelper.updateOnInterval(200)) {
            Iterator<BlockPos> iterator = this.flowerCoords.iterator();
            while (iterator.hasNext()) {
                BlockPos flowerPos = iterator.next();
                if (this.flowerData.flowerPredicate.test(world, flowerPos) || !world.func_175667_e(flowerPos)) continue;
                iterator.remove();
                this.needsSync = true;
            }
        }
        if (this.tickHelper.updateOnInterval(ticksPerCheck = 1 + (flowerCount = this.flowerCoords.size()) * flowerCount)) {
            if (this.flowerData.areaIterator.hasNext()) {
                BlockPos.MutableBlockPos blockPos = this.flowerData.areaIterator.next();
                if (this.flowerData.flowerPredicate.test(world, (BlockPos)blockPos)) {
                    this.flowerCoords.add(blockPos.func_185334_h());
                    this.needsSync = true;
                }
            } else {
                this.flowerData.resetIterator(queen, beeHousing);
            }
        }
    }

    public boolean hasFlowers() {
        return !this.flowerCoords.isEmpty();
    }

    public boolean needsSync() {
        boolean returnVal = this.needsSync;
        this.needsSync = false;
        return returnVal;
    }

    public void clear() {
        this.flowerCoords.clear();
        this.flowerData = null;
    }

    @Nonnull
    public List<BlockPos> getFlowerCoords() {
        return Collections.unmodifiableList(this.flowerCoords);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        int[] flowersList;
        if (!nbttagcompound.func_74764_b(NBT_KEY)) {
            return;
        }
        NBTTagCompound hasFlowerCacheNBT = nbttagcompound.func_74775_l(NBT_KEY);
        if (hasFlowerCacheNBT.func_74764_b(NBT_KEY_FLOWERS) && (flowersList = hasFlowerCacheNBT.func_74759_k(NBT_KEY_FLOWERS)) != null && flowersList.length % 3 == 0) {
            int flowerCount = flowersList.length / 3;
            for (int i = 0; i < flowerCount; ++i) {
                BlockPos flowerPos = new BlockPos(flowersList[i], flowersList[i + 1], flowersList[i + 2]);
                this.flowerCoords.add(flowerPos);
            }
            this.needsSync = true;
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound hasFlowerCacheNBT = new NBTTagCompound();
        if (!this.flowerCoords.isEmpty()) {
            int[] flowersList = new int[this.flowerCoords.size() * 3];
            int i = 0;
            for (BlockPos flowerPos : this.flowerCoords) {
                flowersList[i] = flowerPos.func_177958_n();
                flowersList[i + 1] = flowerPos.func_177956_o();
                flowersList[i + 2] = flowerPos.func_177952_p();
                ++i;
            }
            hasFlowerCacheNBT.func_74783_a(NBT_KEY_FLOWERS, flowersList);
        }
        nbttagcompound.func_74782_a(NBT_KEY, (NBTBase)hasFlowerCacheNBT);
        return nbttagcompound;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        int size = this.flowerCoords.size();
        data.writeVarInt(size);
        if (size > 0) {
            for (BlockPos pos : this.flowerCoords) {
                data.writeVarInt(pos.func_177958_n());
                data.writeVarInt(pos.func_177956_o());
                data.writeVarInt(pos.func_177952_p());
            }
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.flowerCoords.clear();
        for (int size = data.readVarInt(); size > 0; --size) {
            BlockPos pos = new BlockPos(data.readVarInt(), data.readVarInt(), data.readVarInt());
            this.flowerCoords.add(pos);
        }
    }

    private static class FlowerData {
        public String flowerType;
        public final IBlockPosPredicate flowerPredicate;
        public Iterator<BlockPos.MutableBlockPos> areaIterator;

        public FlowerData(IBee queen, IBeeHousing beeHousing) {
            IFlowerProvider flowerProvider = queen.getGenome().getFlowerProvider();
            this.flowerType = flowerProvider.getFlowerType();
            this.flowerPredicate = FlowerManager.flowerRegistry.createAcceptedFlowerPredicate(this.flowerType);
            this.areaIterator = FlowerManager.flowerRegistry.getAreaIterator(beeHousing, queen);
        }

        public void resetIterator(IBee queen, IBeeHousing beeHousing) {
            this.areaIterator = FlowerManager.flowerRegistry.getAreaIterator(beeHousing, queen);
        }
    }
}

