/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.core.gui.ContainerEscritoire;
import forestry.core.gui.GuiEscritoire;
import forestry.core.inventory.InventoryEscritoire;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.network.packets.PacketItemStackDisplay;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEscritoire
extends TileBase
implements ISidedInventory,
ISlotPickupWatcher,
IStreamableGui,
IItemStackDisplay {
    private final EscritoireGame game = new EscritoireGame();
    private ItemStack individualOnDisplayClient;

    public TileEscritoire() {
        super("escritoire");
        this.setInternalInventory(new InventoryEscritoire(this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.game.readFromNBT(nbttagcompound);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.game.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    public EscritoireGame getGame() {
        return this.game;
    }

    public void choose(GameProfile gameProfile, int index) {
        this.game.choose(index);
        this.processTurnResult(gameProfile);
    }

    private void processTurnResult(GameProfile gameProfile) {
        if (this.getGame().getStatus() != EscritoireGame.Status.SUCCESS) {
            return;
        }
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(this.func_70301_a(0));
        if (individual == null) {
            return;
        }
        IAlleleSpecies species = individual.getGenome().getPrimary();
        for (ItemStack itemstack : species.getResearchBounty(this.field_145850_b, gameProfile, individual, this.game.getBountyLevel())) {
            InventoryUtil.addStack((IInventory)this.getInternalInventory(), itemstack, 1, 6, true);
        }
    }

    private boolean areProbeSlotsFilled() {
        int filledSlots = 0;
        int required = this.game.getSampleSize(5);
        for (int i = 7; i < 7 + required; ++i) {
            if (this.func_70301_a(i) == null) continue;
            ++filledSlots;
        }
        return filledSlots >= required;
    }

    public void probe() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack analyze = this.func_70301_a(0);
        if (analyze != null && this.areProbeSlotsFilled()) {
            this.game.probe(analyze, (IInventory)this, 7, 5);
        }
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        this.game.writeData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.game.readData(data);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        ItemStack displayStack = this.getIndividualOnDisplay();
        data.writeItemStack(displayStack);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.individualOnDisplayClient = data.readItemStack();
    }

    @Override
    public void onPickupFromSlot(int slotIndex, EntityPlayer player) {
        if (slotIndex == 0) {
            this.game.reset();
            PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
            Proxies.net.sendNetworkPacket(packet, this.field_145850_b);
        }
    }

    @Override
    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        super.func_70299_a(slotIndex, itemstack);
        if (slotIndex == 0) {
            PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
            Proxies.net.sendNetworkPacket(packet, this.field_145850_b);
        }
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiEscritoire(player, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerEscritoire(player, this);
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        if (!ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)this.individualOnDisplayClient)) {
            this.individualOnDisplayClient = itemStack;
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public ItemStack getIndividualOnDisplay() {
        if (this.field_145850_b.field_72995_K) {
            return this.individualOnDisplayClient;
        }
        return this.func_70301_a(0);
    }
}

