/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.utils;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

import net.minecraftforge.fml.common.registry.EntityRegistry;

import forestry.api.core.ForestryAPI;

public abstract class EntityUtil {
	public static <E extends EntityLiving> E spawnEntity(World world, Class<E> entityClass, double x, double y, double z) {
		E entityLiving = createEntity(world, entityClass);
		if (entityLiving == null) {
			return null;
		}
		return spawnEntity(world, entityLiving, x, y, z);
	}

	public static <E extends EntityLiving> E spawnEntity(World world, E living, double x, double y, double z) {
		if (living == null) {
			return null;
		}

		living.func_70012_b(x, y, z, MathHelper.func_76142_g(world.field_73012_v.nextFloat() * 360.0f), 0.0f);
		living.field_70759_as = living.field_70177_z;
		living.field_70761_aq = living.field_70177_z;
		living.func_180482_a(world.func_175649_E(new BlockPos(x, y, z)), null);
		world.func_72838_d(living);
		living.func_70642_aH();
		return living;
	}

	public static void registerEntity(Class<? extends Entity> entityClass, String ident, int id, int eggForeground, int eggBackground, int trackingRange, int updateFrequency, boolean sendVelocity) {
		EntityRegistry.registerModEntity(entityClass, ident, id, ForestryAPI.instance, trackingRange, updateFrequency, sendVelocity);
		Log.debug("Registered entity %s (%s) with id %s.", ident, entityClass.toString(), id);
	}

	private static <E extends EntityLiving> E createEntity(World world, Class<E> entityClass) {
		if (!EntityList.field_75626_c.containsKey(entityClass)) {
			return null;
		}

		String entityString = EntityList.field_75626_c.get(entityClass);
		if (entityString == null) {
			return null;
		}

		Entity entity = EntityList.func_75620_a(entityString, world);
		return entityClass.cast(entity);
	}
}
