/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import com.google.common.base.Preconditions;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketIdClient;
import forestry.core.network.PacketIdServer;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketHandler {
    public static final String channelId = "FOR";
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("FOR");

    public PacketHandler() {
        this.channel.register((Object)this);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        DataInputStreamForestry data = PacketHandler.getStream(event.getPacket());
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        try {
            byte packetIdOrdinal = data.readByte();
            PacketIdServer packetId = PacketIdServer.VALUES[packetIdOrdinal];
            IForestryPacketServer packetHandler = packetId.getPacketHandler();
            PacketHandler.checkThreadAndEnqueue(packetHandler, data, player, (IThreadListener)player.func_71121_q());
        }
        catch (IOException e) {
            Log.error("Failed to read packet.", e);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        DataInputStreamForestry data = PacketHandler.getStream(event.getPacket());
        try {
            byte packetIdOrdinal = data.readByte();
            PacketIdClient packetId = PacketIdClient.VALUES[packetIdOrdinal];
            IForestryPacketClient packetHandler = packetId.getPacketHandler();
            PacketHandler.checkThreadAndEnqueue(packetHandler, data, (IThreadListener)Minecraft.func_71410_x());
        }
        catch (IOException e) {
            Log.error("Failed to read packet.", e);
        }
    }

    private static DataInputStreamForestry getStream(FMLProxyPacket fmlPacket) {
        ByteBufInputStream is = new ByteBufInputStream(fmlPacket.payload());
        return new DataInputStreamForestry((InputStream)is);
    }

    public void sendPacket(FMLProxyPacket packet, EntityPlayerMP player) {
        this.channel.sendTo(packet, player);
    }

    @SideOnly(value=Side.CLIENT)
    private static void checkThreadAndEnqueue(IForestryPacketClient packet, DataInputStreamForestry data, IThreadListener threadListener) {
        if (!threadListener.func_152345_ab()) {
            threadListener.func_152344_a(() -> {
                try {
                    EntityPlayer player = Proxies.common.getPlayer();
                    Preconditions.checkNotNull((Object)player, (Object)"Tried to send data to client before the player exists.");
                    packet.readData(data);
                    packet.onPacketData(data, player);
                }
                catch (IOException e) {
                    Log.error("Network Error", e);
                }
            });
        }
    }

    private static void checkThreadAndEnqueue(IForestryPacketServer packet, DataInputStreamForestry data, EntityPlayerMP player, IThreadListener threadListener) {
        if (!threadListener.func_152345_ab()) {
            threadListener.func_152344_a(() -> {
                try {
                    packet.readData(data);
                    packet.onPacketData(data, player);
                }
                catch (IOException e) {
                    Log.error("Network Error", e);
                }
            });
        }
    }
}

