/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketNBT;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PacketGenomeTrackerSync
extends PacketNBT
implements IForestryPacketClient {
    public PacketGenomeTrackerSync() {
    }

    public PacketGenomeTrackerSync(NBTTagCompound nbtTagCompound) {
        super(nbtTagCompound);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        String type;
        ISpeciesRoot root;
        NBTTagCompound nbt = this.getTagCompound();
        if (nbt != null && (root = AlleleManager.alleleRegistry.getSpeciesRoot(type = nbt.func_74779_i("TYPE"))) != null) {
            IBreedingTracker tracker = root.getBreedingTracker(player.func_130014_f_(), player.func_146103_bH());
            tracker.decodeFromNBT(nbt);
            MinecraftForge.EVENT_BUS.post((Event)new ForestryEvent.SyncedBreedingTracker(tracker, player));
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.GENOME_TRACKER_UPDATE;
    }
}

