/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import com.google.common.collect.ImmutableMap;
import forestry.Forestry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IArmorApiarist;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.hives.HiveManager;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFlowerAcceptableRule;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.apiculture.ArmorApiaristHelper;
import forestry.apiculture.SaveEventHandlerApiculture;
import forestry.apiculture.VillageCreationApiculture;
import forestry.apiculture.VillagerApiaristTrades;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.blocks.BlockCandle;
import forestry.apiculture.blocks.BlockRegistryApiculture;
import forestry.apiculture.capabilities.ArmorApiarist;
import forestry.apiculture.commands.CommandBee;
import forestry.apiculture.entities.EntityMinecartApiary;
import forestry.apiculture.entities.EntityMinecartBeehouse;
import forestry.apiculture.flowers.FlowerRegistry;
import forestry.apiculture.genetics.BeeBranchDefinition;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.BeeFactory;
import forestry.apiculture.genetics.BeeMutationFactory;
import forestry.apiculture.genetics.BeeRoot;
import forestry.apiculture.genetics.BeekeepingMode;
import forestry.apiculture.genetics.HiveDrop;
import forestry.apiculture.genetics.JubilanceFactory;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.apiculture.items.EnumPropolis;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.apiculture.multiblock.TileAlvearyFan;
import forestry.apiculture.multiblock.TileAlvearyHeater;
import forestry.apiculture.multiblock.TileAlvearyHygroregulator;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.apiculture.multiblock.TileAlvearySieve;
import forestry.apiculture.multiblock.TileAlvearyStabiliser;
import forestry.apiculture.multiblock.TileAlvearySwarmer;
import forestry.apiculture.network.PacketRegistryApiculture;
import forestry.apiculture.proxy.ProxyApiculture;
import forestry.apiculture.proxy.ProxyApicultureClient;
import forestry.apiculture.tiles.TileCandle;
import forestry.apiculture.tiles.TileHive;
import forestry.apiculture.worldgen.HiveDecorator;
import forestry.apiculture.worldgen.HiveDescription;
import forestry.apiculture.worldgen.HiveGenHelper;
import forestry.apiculture.worldgen.HiveRegistry;
import forestry.core.ISaveEventHandler;
import forestry.core.PluginCore;
import forestry.core.PluginFluids;
import forestry.core.capabilities.NullStorage;
import forestry.core.config.Config;
import forestry.core.config.Constants;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.entities.ParticleSnow;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumElectronTube;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.IMCUtil;
import forestry.core.utils.Log;
import forestry.core.utils.VillagerTradeLists;
import forestry.food.PluginFood;
import forestry.food.items.ItemRegistryFood;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ForestryPlugin(pluginID="forestry.apiculture", name="Apiculture", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.apiculture.description")
public class PluginApiculture
extends BlankForestryPlugin {
    @SidedProxy(clientSide="forestry.apiculture.proxy.ProxyApicultureClient", serverSide="forestry.apiculture.proxy.ProxyApiculture")
    public static ProxyApiculture proxy;
    private static final String CONFIG_CATEGORY = "apiculture";
    public static String beekeepingMode;
    private static float secondPrincessChance;
    public static final int ticksPerBeeWorkCycle = 550;
    public static ItemRegistryApiculture items;
    public static BlockRegistryApiculture blocks;
    public static HiveRegistry hiveRegistry;
    public static VillagerRegistry.VillagerProfession villagerApiarist;

    @Override
    public void setupAPI() {
        super.setupAPI();
        hiveRegistry = new HiveRegistry();
        HiveManager.hiveRegistry = hiveRegistry;
        HiveManager.genHelper = new HiveGenHelper();
        FlowerManager.flowerRegistry = new FlowerRegistry();
        BeeManager.commonVillageBees = new ArrayList<IBeeGenome>();
        BeeManager.uncommonVillageBees = new ArrayList<IBeeGenome>();
        BeeManager.beeFactory = new BeeFactory();
        BeeManager.beeMutationFactory = new BeeMutationFactory();
        BeeManager.jubilanceFactory = new JubilanceFactory();
        BeeManager.armorApiaristHelper = new ArmorApiaristHelper();
        BeeManager.beeRoot = new BeeRoot();
        AlleleManager.alleleRegistry.registerSpeciesRoot(BeeManager.beeRoot);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.easy);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.normal);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.hard);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.hardcore);
        BeeManager.beeRoot.registerBeekeepingMode(BeekeepingMode.insane);
        CapabilityManager.INSTANCE.register(IArmorApiarist.class, new NullStorage(), () -> ArmorApiarist.INSTANCE);
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryApiculture();
        blocks = new BlockRegistryApiculture();
    }

    @Override
    public void preInit() {
        super.preInit();
        BeeDefinition.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (Config.enableVillagers) {
            VillageCreationApiculture.registerVillageComponents();
        }
        PluginCore.rootCommand.addChildCommand(new CommandBee());
    }

    @Override
    public void doInit() {
        boolean deleted;
        File configFile = new File(Forestry.instance.getConfigFolder(), "apiculture.cfg");
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "3.0.0");
        if (!Objects.equals(config.getLoadedConfigVersion(), config.getDefinedConfigVersion()) && (deleted = configFile.delete())) {
            config = new LocalizedConfiguration(configFile, "3.0.0");
        }
        this.initFlowerRegistry();
        ArrayList<IBeekeepingMode> beekeepingModes = BeeManager.beeRoot.getBeekeepingModes();
        String[] validBeekeepingModeNames = new String[beekeepingModes.size()];
        for (int i = 0; i < beekeepingModes.size(); ++i) {
            validBeekeepingModeNames[i] = ((IBeekeepingMode)beekeepingModes.get(i)).getName();
        }
        beekeepingMode = config.getStringLocalized("beekeeping", "mode", "NORMAL", validBeekeepingModeNames);
        Log.debug("Beekeeping mode read from config: " + beekeepingMode, new Object[0]);
        secondPrincessChance = config.getFloatLocalized("beekeeping", "second.princess", secondPrincessChance, 0.0f, 100.0f);
        String[] blacklist = config.getStringListLocalized("species", "blacklist", Constants.EMPTY_STRINGS);
        PluginApiculture.parseBeeBlacklist(blacklist);
        config.save();
        PluginApiculture.createAlleles();
        BeeDefinition.initBees();
        PluginApiculture.createHives();
        PluginApiculture.registerBeehiveDrops();
        BeeManager.inducers.put(PluginApiculture.items.royalJelly.getItemStack(), 10);
        GameRegistry.registerTileEntity(TileAlvearyPlain.class, (String)"forestry.Alveary");
        GameRegistry.registerTileEntity(TileHive.class, (String)"forestry.Swarm");
        GameRegistry.registerTileEntity(TileAlvearySwarmer.class, (String)"forestry.AlvearySwarmer");
        GameRegistry.registerTileEntity(TileAlvearyHeater.class, (String)"forestry.AlvearyHeater");
        GameRegistry.registerTileEntity(TileAlvearyFan.class, (String)"forestry.AlvearyFan");
        GameRegistry.registerTileEntity(TileAlvearyHygroregulator.class, (String)"forestry.AlvearyHygro");
        GameRegistry.registerTileEntity(TileAlvearyStabiliser.class, (String)"forestry.AlvearyStabiliser");
        GameRegistry.registerTileEntity(TileAlvearySieve.class, (String)"forestry.AlvearySieve");
        GameRegistry.registerTileEntity(TileCandle.class, (String)"forestry.Candle");
        EntityUtil.registerEntity(EntityMinecartBeehouse.class, "cart.beehouse", 1, 0, 0xFFFFFF, 256, 3, true);
        EntityUtil.registerEntity(EntityMinecartApiary.class, "cart.apiary", 2, 0, 0xFFFFFF, 256, 3, true);
        BeeManager.commonVillageBees.add(BeeDefinition.FOREST.getGenome());
        BeeManager.commonVillageBees.add(BeeDefinition.MEADOWS.getGenome());
        BeeManager.commonVillageBees.add(BeeDefinition.MODEST.getGenome());
        BeeManager.commonVillageBees.add(BeeDefinition.MARSHY.getGenome());
        BeeManager.commonVillageBees.add(BeeDefinition.WINTRY.getGenome());
        BeeManager.commonVillageBees.add(BeeDefinition.TROPICAL.getGenome());
        BeeManager.uncommonVillageBees.add(BeeDefinition.FOREST.getRainResist().getGenome());
        BeeManager.uncommonVillageBees.add(BeeDefinition.COMMON.getGenome());
        BeeManager.uncommonVillageBees.add(BeeDefinition.VALIANT.getGenome());
        if (Config.enableVillagers) {
            VillageCreationApiculture villageHandler = new VillageCreationApiculture();
            VillagerRegistry villagerRegistry = VillagerRegistry.instance();
            villagerRegistry.registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageHandler);
            villagerApiarist = new VillagerRegistry.VillagerProfession("forestry:apiarist", "forestry:textures/entity/beekeeper.png", "forestry:textures/entity/zombie_beekeeper.png");
            villagerRegistry.register(villagerApiarist);
            ItemStack wildcardPrincess = new ItemStack((Item)PluginApiculture.items.beePrincessGE, 1);
            ItemStack wildcardDrone = new ItemStack((Item)PluginApiculture.items.beeDroneGE, 1);
            ItemStack apiary = new ItemStack((Block)PluginApiculture.blocks.apiary);
            ItemStack provenFrames = PluginApiculture.items.frameProven.getItemStack();
            ItemStack monasticDrone = BeeDefinition.MONASTIC.getMemberStack(EnumBeeType.DRONE);
            ItemStack endDrone = BeeDefinition.ENDED.getMemberStack(EnumBeeType.DRONE);
            ItemStack propolis = new ItemStack((Item)PluginApiculture.items.propolis, 1);
            VillagerRegistry.VillagerCareer apiaristCareer = new VillagerRegistry.VillagerCareer(villagerApiarist, "apiarist");
            apiaristCareer.addTrade(1, new EntityVillager.ITradeList[]{new VillagerApiaristTrades.GiveRandomCombsForItems(new ItemStack(Items.field_151015_O), new EntityVillager.PriceInfo(8, 12), new EntityVillager.PriceInfo(2, 4)), new VillagerApiaristTrades.GiveRandomCombsForItems(new ItemStack(Items.field_151172_bF), new EntityVillager.PriceInfo(8, 12), new EntityVillager.PriceInfo(2, 4)), new VillagerApiaristTrades.GiveRandomCombsForItems(new ItemStack(Items.field_151174_bG), new EntityVillager.PriceInfo(8, 12), new EntityVillager.PriceInfo(2, 4))});
            apiaristCareer.addTrade(2, new EntityVillager.ITradeList[]{new VillagerTradeLists.GiveItemForEmeralds(new EntityVillager.PriceInfo(1, 4), new ItemStack((Item)PluginApiculture.items.smoker), null), new VillagerTradeLists.GiveItemForLogsAndEmeralds(apiary, new EntityVillager.PriceInfo(1, 1), new EntityVillager.PriceInfo(16, 32), new EntityVillager.PriceInfo(1, 2)), new VillagerApiaristTrades.GiveRandomHiveDroneForItems(propolis, null, wildcardDrone, new EntityVillager.PriceInfo(2, 4))});
            apiaristCareer.addTrade(3, new EntityVillager.ITradeList[]{new VillagerTradeLists.GiveEmeraldForItems(wildcardPrincess, null), new VillagerTradeLists.GiveItemForEmeralds(new EntityVillager.PriceInfo(1, 2), provenFrames, new EntityVillager.PriceInfo(1, 6))});
            apiaristCareer.addTrade(4, new EntityVillager.ITradeList[]{new VillagerTradeLists.GiveItemForItemAndEmerald(wildcardPrincess, null, new EntityVillager.PriceInfo(10, 64), monasticDrone, null), new VillagerTradeLists.GiveItemForTwoItems(wildcardPrincess, null, new ItemStack(Items.field_151061_bv), new EntityVillager.PriceInfo(12, 16), endDrone, null)});
        }
        PluginApiculture.blocks.apiary.init();
        PluginApiculture.blocks.beeHouse.init();
        PluginApiculture.blocks.beeChest.init();
    }

    @Override
    public void postInit() {
        super.postInit();
        PluginApiculture.registerDungeonLoot();
    }

    private void initFlowerRegistry() {
        FlowerRegistry flowerRegistry = (FlowerRegistry)FlowerManager.flowerRegistry;
        flowerRegistry.registerAcceptableFlowerRule(new EndFlowerAcceptableRule(), "flowersEnd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150380_bt, "flowersEnd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_185765_cR, "flowersEnd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_185766_cS, "flowersEnd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150395_bd, "flowersJungle");
        flowerRegistry.registerAcceptableFlower((Block)Blocks.field_150329_H, "flowersJungle");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150464_aj, "flowersWheat");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150393_bb, "flowersGourd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150394_bc, "flowersGourd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150388_bm, "flowersNether");
        flowerRegistry.registerAcceptableFlower((Block)Blocks.field_150434_aF, "flowersCacti");
        block4: for (BlockFlower.EnumFlowerType flowerType : BlockFlower.EnumFlowerType.values()) {
            IBlockState blockState;
            switch (flowerType.func_176964_a()) {
                case RED: {
                    blockState = Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)flowerType);
                    break;
                }
                case YELLOW: {
                    blockState = Blocks.field_150327_N.func_176223_P().func_177226_a(Blocks.field_150327_N.func_176494_l(), (Comparable)flowerType);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            flowerRegistry.registerPlantableFlower(blockState, 1.0, "flowersVanilla", "flowersSnow");
        }
        flowerRegistry.registerPlantableFlower(Blocks.field_150338_P.func_176223_P(), 1.0, "flowersMushrooms");
        flowerRegistry.registerPlantableFlower(Blocks.field_150337_Q.func_176223_P(), 1.0, "flowersMushrooms");
        flowerRegistry.registerPlantableFlower(Blocks.field_150434_aF.func_176223_P(), 1.0, "flowersCacti");
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryApiculture();
    }

    @Override
    public void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        crateRegistry.registerCrate(PluginCore.items.beeswax.getItemStack());
        crateRegistry.registerCrate(PluginApiculture.items.pollenCluster.get(EnumPollenCluster.NORMAL, 1));
        crateRegistry.registerCrate(PluginApiculture.items.pollenCluster.get(EnumPollenCluster.CRYSTALLINE, 1));
        crateRegistry.registerCrate(PluginApiculture.items.propolis.getItemStack());
        crateRegistry.registerCrate(PluginApiculture.items.honeydew.getItemStack());
        crateRegistry.registerCrate(PluginApiculture.items.royalJelly.getItemStack());
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.HONEY, 1));
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.COCOA, 1));
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.SIMMERING, 1));
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.STRINGY, 1));
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.FROZEN, 1));
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.DRIPPING, 1));
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.SILKY, 1));
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.PARCHED, 1));
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.MYSTERIOUS, 1));
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.POWDERY, 1));
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.WHEATEN, 1));
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.MOSSY, 1));
        crateRegistry.registerCrate(PluginApiculture.items.beeComb.get(EnumHoneyComb.MELLOW, 1));
        crateRegistry.registerCrate(PluginCore.items.refractoryWax.getItemStack());
    }

    @Override
    public void registerRecipes() {
        int outputRefractoryAmount;
        int outputCapsuleAmount;
        ItemStack wovenSilk = PluginCore.items.craftingMaterial.getWovenSilk();
        RecipeUtil.addRecipe((Item)PluginApiculture.items.apiaristHat, "###", "# #", Character.valueOf('#'), wovenSilk);
        RecipeUtil.addRecipe((Item)PluginApiculture.items.apiaristChest, "# #", "###", "###", Character.valueOf('#'), wovenSilk);
        RecipeUtil.addRecipe((Item)PluginApiculture.items.apiaristLegs, "###", "# #", "# #", Character.valueOf('#'), wovenSilk);
        RecipeUtil.addRecipe((Item)PluginApiculture.items.apiaristBoots, "# #", "# #", Character.valueOf('#'), wovenSilk);
        RecipeUtil.addRecipe(PluginApiculture.items.habitatLocator, " X ", "X#X", " X ", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotBronze");
        RecipeUtil.addRecipe(PluginApiculture.items.scoop, "#X#", "###", " # ", Character.valueOf('#'), "stickWood", Character.valueOf('X'), Blocks.field_150325_L);
        RecipeUtil.addRecipe(PluginApiculture.items.smoker, "LS#", "LF#", "###", Character.valueOf('#'), "ingotTin", Character.valueOf('S'), "stickWood", Character.valueOf('F'), Items.field_151033_d, Character.valueOf('L'), "leather");
        RecipeUtil.addRecipe(new ItemStack(Items.field_151123_aH), "#X#", "#X#", "#X#", Character.valueOf('#'), PluginApiculture.items.propolis, Character.valueOf('X'), PluginApiculture.items.pollenCluster.get(EnumPollenCluster.NORMAL, 1));
        RecipeUtil.addRecipe(new ItemStack(Items.field_151060_bw), "#X#", "#Y#", "#X#", Character.valueOf('#'), PluginApiculture.items.honeyDrop, Character.valueOf('X'), PluginApiculture.items.honeydew, Character.valueOf('Y'), Items.field_151127_ba);
        RecipeUtil.addRecipe(PluginApiculture.items.frameUntreated, "###", "#S#", "###", Character.valueOf('#'), "stickWood", Character.valueOf('S'), Items.field_151007_F);
        RecipeUtil.addRecipe(PluginApiculture.items.frameImpregnated, "###", "#S#", "###", Character.valueOf('#'), PluginCore.items.stickImpregnated, Character.valueOf('S'), Items.field_151007_F);
        RecipeUtil.addRecipe(PluginApiculture.items.minecartBeehouse.getBeeHouseMinecart(), "B", "C", Character.valueOf('B'), new ItemStack((Block)PluginApiculture.blocks.beeHouse), Character.valueOf('C'), Items.field_151143_au);
        RecipeUtil.addRecipe(PluginApiculture.items.minecartBeehouse.getApiaryMinecart(), "B", "C", Character.valueOf('B'), new ItemStack((Block)PluginApiculture.blocks.apiary), Character.valueOf('C'), Items.field_151143_au);
        ItemRegistryFood foodItems = PluginFood.items;
        if (foodItems != null) {
            RecipeUtil.addRecipe(new ItemStack((Item)foodItems.honeyedSlice, 4), "###", "#X#", "###", Character.valueOf('#'), PluginApiculture.items.honeyDrop, Character.valueOf('X'), Items.field_151025_P);
            RecipeUtil.addRecipe((Item)foodItems.honeyPot, "# #", " X ", "# #", Character.valueOf('#'), PluginApiculture.items.honeyDrop, Character.valueOf('X'), PluginFluids.items.waxCapsuleEmpty);
            RecipeUtil.addRecipe((Item)foodItems.ambrosia, "#Y#", "XXX", "###", Character.valueOf('#'), PluginApiculture.items.honeydew, Character.valueOf('X'), PluginApiculture.items.royalJelly, Character.valueOf('Y'), PluginFluids.items.waxCapsuleEmpty);
        }
        if ((outputCapsuleAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.capsule")) > 0) {
            ItemStack capsule = PluginFluids.items.waxCapsuleEmpty.getItemStack(outputCapsuleAmount);
            RecipeUtil.addRecipe(capsule, "###", Character.valueOf('#'), PluginCore.items.beeswax);
        }
        if ((outputRefractoryAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.refractory")) > 0) {
            ItemStack capsule = PluginFluids.items.refractoryEmpty.getItemStack(outputRefractoryAmount);
            RecipeUtil.addRecipe(capsule, "###", Character.valueOf('#'), PluginCore.items.refractoryWax);
        }
        RecipeUtil.addRecipe(PluginCore.items.bituminousPeat.getItemStack(), " # ", "XYX", " # ", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), PluginCore.items.peat, Character.valueOf('Y'), PluginApiculture.items.propolis);
        RecipeUtil.addRecipe(new ItemStack(Blocks.field_150478_aa, 3), " # ", " # ", " Y ", Character.valueOf('#'), PluginCore.items.beeswax, Character.valueOf('Y'), "stickWood");
        RecipeUtil.addRecipe(PluginCore.items.craftingMaterial.getPulsatingMesh(), "# #", " # ", "# #", Character.valueOf('#'), PluginApiculture.items.propolis.get(EnumPropolis.PULSATING, 1));
        RecipeUtil.addRecipe(PluginApiculture.items.waxCast, "###", "# #", "###", Character.valueOf('#'), PluginCore.items.beeswax);
        ItemStack alvearyPlainBlock = blocks.getAlvearyBlock(BlockAlvearyType.PLAIN);
        RecipeUtil.addRecipe(alvearyPlainBlock, "###", "#X#", "###", Character.valueOf('X'), PluginCore.items.impregnatedCasing, Character.valueOf('#'), PluginCore.items.craftingMaterial.getScentedPaneling());
        RecipeUtil.addRecipe(blocks.getAlvearyBlock(BlockAlvearyType.SWARMER), "#G#", " X ", "#G#", Character.valueOf('#'), PluginCore.items.tubes.get(EnumElectronTube.DIAMOND, 1), Character.valueOf('X'), alvearyPlainBlock, Character.valueOf('G'), "ingotGold");
        RecipeUtil.addRecipe(blocks.getAlvearyBlock(BlockAlvearyType.FAN), "I I", " X ", "I#I", Character.valueOf('#'), PluginCore.items.tubes.get(EnumElectronTube.GOLD, 1), Character.valueOf('X'), alvearyPlainBlock, Character.valueOf('I'), "ingotIron");
        RecipeUtil.addRecipe(blocks.getAlvearyBlock(BlockAlvearyType.HEATER), "#I#", " X ", "YYY", Character.valueOf('#'), PluginCore.items.tubes.get(EnumElectronTube.GOLD, 1), Character.valueOf('X'), alvearyPlainBlock, Character.valueOf('I'), "ingotIron", Character.valueOf('Y'), "stone");
        RecipeUtil.addRecipe(blocks.getAlvearyBlock(BlockAlvearyType.HYGRO), "GIG", "GXG", "GIG", Character.valueOf('X'), alvearyPlainBlock, Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "blockGlass");
        RecipeUtil.addRecipe(blocks.getAlvearyBlock(BlockAlvearyType.STABILISER), "G G", "GXG", "G G", Character.valueOf('X'), alvearyPlainBlock, Character.valueOf('G'), "gemQuartz");
        RecipeUtil.addRecipe(blocks.getAlvearyBlock(BlockAlvearyType.SIEVE), "III", " X ", "WWW", Character.valueOf('X'), alvearyPlainBlock, Character.valueOf('I'), "ingotIron", Character.valueOf('W'), PluginCore.items.craftingMaterial.getWovenSilk());
        if (ForestryAPI.enabledPlugins.contains("forestry.factory")) {
            FluidStack honeyDropFluid = Fluids.FOR_HONEY.getFluid(100);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{PluginApiculture.items.honeyDrop.getItemStack()}, honeyDropFluid, PluginApiculture.items.propolis.getItemStack(), 5);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{PluginApiculture.items.honeydew.getItemStack()}, honeyDropFluid);
            ItemStack phosphor = PluginCore.items.phosphor.getItemStack(2);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{phosphor, new ItemStack((Block)Blocks.field_150354_m)}, new FluidStack(FluidRegistry.LAVA, 2000));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{phosphor, new ItemStack((Block)Blocks.field_150354_m, 1, 1)}, new FluidStack(FluidRegistry.LAVA, 2000));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{phosphor, new ItemStack(Blocks.field_150346_d)}, new FluidStack(FluidRegistry.LAVA, 1600));
            RecipeManagers.carpenterManager.addRecipe(50, Fluids.FOR_HONEY.getFluid(500), null, PluginCore.items.craftingMaterial.getScentedPaneling(), " J ", "###", "WPW", Character.valueOf('#'), "plankWood", Character.valueOf('J'), PluginApiculture.items.royalJelly, Character.valueOf('W'), PluginCore.items.beeswax, Character.valueOf('P'), PluginApiculture.items.pollenCluster.get(EnumPollenCluster.NORMAL, 1));
            RecipeManagers.carpenterManager.addRecipe(30, new FluidStack(FluidRegistry.WATER, 600), null, PluginApiculture.blocks.candle.getUnlitCandle(24), " X ", "###", "###", Character.valueOf('#'), PluginCore.items.beeswax, Character.valueOf('X'), Items.field_151007_F);
            RecipeManagers.carpenterManager.addRecipe(10, new FluidStack(FluidRegistry.WATER, 200), null, PluginApiculture.blocks.candle.getUnlitCandle(6), "#X#", Character.valueOf('#'), PluginCore.items.beeswax, Character.valueOf('X'), PluginCore.items.craftingMaterial.getSilkWisp());
            RecipeUtil.addShapelessRecipe(PluginApiculture.blocks.candle.getUnlitCandle(1), PluginApiculture.blocks.candle.getUnlitCandle(1));
            RecipeUtil.addShapelessRecipe(PluginApiculture.blocks.candle.getLitCandle(1), PluginApiculture.blocks.candle.getLitCandle(1));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.HONEY, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.9f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.COCOA, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)new ItemStack(Items.field_151100_aR, 1, 3), (Object)Float.valueOf(0.5f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.SIMMERING, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.refractoryWax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginCore.items.phosphor.getItemStack(2), (Object)Float.valueOf(0.7f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.STRINGY, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.propolis.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.4f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.DRIPPING, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.honeydew.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.4f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.FROZEN, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(0.8f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.7f), (Object)new ItemStack(Items.field_151126_ay), (Object)Float.valueOf(0.4f), (Object)PluginApiculture.items.pollenCluster.get(EnumPollenCluster.CRYSTALLINE, 1), (Object)Float.valueOf(0.2f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.SILKY, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.propolis.get(EnumPropolis.SILKY, 1), (Object)Float.valueOf(0.8f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.PARCHED, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.9f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.MYSTERIOUS, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.propolis.get(EnumPropolis.PULSATING, 1), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.4f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.IRRADIATED, 1), (Map<ItemStack, Float>)ImmutableMap.of());
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.POWDERY, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.2f), (Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(0.2f), (Object)new ItemStack(Items.field_151016_H), (Object)Float.valueOf(0.9f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.WHEATEN, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.2f), (Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(0.2f), (Object)new ItemStack(Items.field_151015_O), (Object)Float.valueOf(0.8f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.MOSSY, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(1.0f), (Object)PluginApiculture.items.honeyDrop.getItemStack(), (Object)Float.valueOf(0.9f)));
            RecipeManagers.centrifugeManager.addRecipe(20, PluginApiculture.items.beeComb.get(EnumHoneyComb.MELLOW, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginApiculture.items.honeydew.getItemStack(), (Object)Float.valueOf(0.6f), (Object)PluginCore.items.beeswax.getItemStack(), (Object)Float.valueOf(0.2f), (Object)new ItemStack(Items.field_151128_bU), (Object)Float.valueOf(0.3f)));
            RecipeManagers.centrifugeManager.addRecipe(5, PluginApiculture.items.propolis.get(EnumPropolis.SILKY, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.craftingMaterial.getSilkWisp(), (Object)Float.valueOf(0.6f), (Object)PluginApiculture.items.propolis.getItemStack(), (Object)Float.valueOf(0.1f)));
            RecipeManagers.fermenterManager.addRecipe(PluginApiculture.items.honeydew.getItemStack(), 500, 1.0f, Fluids.SHORT_MEAD.getFluid(1), Fluids.FOR_HONEY.getFluid(1));
        }
        RecipeUtil.addRecipe(PluginApiculture.blocks.apiary, "XXX", "#C#", "###", Character.valueOf('X'), "slabWood", Character.valueOf('#'), "plankWood", Character.valueOf('C'), PluginCore.items.impregnatedCasing);
        RecipeUtil.addRecipe(PluginApiculture.blocks.beeChest, " # ", "XYX", "XXX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "beeComb", Character.valueOf('Y'), "chestWood");
        RecipeUtil.addRecipe(PluginApiculture.blocks.beeHouse, "XXX", "#C#", "###", Character.valueOf('X'), "slabWood", Character.valueOf('#'), "plankWood", Character.valueOf('C'), "beeComb");
    }

    private static void registerBeehiveDrops() {
        ItemStack honeyComb = PluginApiculture.items.beeComb.get(EnumHoneyComb.HONEY, 1);
        hiveRegistry.addDrops(IHiveRegistry.HiveType.FOREST.getHiveUid(), new HiveDrop(0.8, BeeDefinition.FOREST, honeyComb).setIgnobleShare(0.7), new HiveDrop(0.08, BeeDefinition.FOREST.getRainResist(), honeyComb), new HiveDrop(0.03, BeeDefinition.VALIANT, honeyComb));
        hiveRegistry.addDrops(IHiveRegistry.HiveType.MEADOWS.getHiveUid(), new HiveDrop(0.8, BeeDefinition.MEADOWS, honeyComb).setIgnobleShare(0.7), new HiveDrop(0.03, BeeDefinition.VALIANT, honeyComb));
        ItemStack parchedComb = PluginApiculture.items.beeComb.get(EnumHoneyComb.PARCHED, 1);
        hiveRegistry.addDrops(IHiveRegistry.HiveType.DESERT.getHiveUid(), new HiveDrop(0.8, BeeDefinition.MODEST, parchedComb).setIgnobleShare(0.7), new HiveDrop(0.03, BeeDefinition.VALIANT, parchedComb));
        ItemStack silkyComb = PluginApiculture.items.beeComb.get(EnumHoneyComb.SILKY, 1);
        hiveRegistry.addDrops(IHiveRegistry.HiveType.JUNGLE.getHiveUid(), new HiveDrop(0.8, BeeDefinition.TROPICAL, silkyComb).setIgnobleShare(0.7), new HiveDrop(0.03, BeeDefinition.VALIANT, silkyComb));
        ItemStack mysteriousComb = PluginApiculture.items.beeComb.get(EnumHoneyComb.MYSTERIOUS, 1);
        hiveRegistry.addDrops(IHiveRegistry.HiveType.END.getHiveUid(), new HiveDrop(0.9, BeeDefinition.ENDED, mysteriousComb));
        ItemStack frozenComb = PluginApiculture.items.beeComb.get(EnumHoneyComb.FROZEN, 1);
        hiveRegistry.addDrops(IHiveRegistry.HiveType.SNOW.getHiveUid(), new HiveDrop(0.8, BeeDefinition.WINTRY, frozenComb).setIgnobleShare(0.5), new HiveDrop(0.03, BeeDefinition.VALIANT, frozenComb));
        ItemStack mossyComb = PluginApiculture.items.beeComb.get(EnumHoneyComb.MOSSY, 1);
        hiveRegistry.addDrops(IHiveRegistry.HiveType.SWAMP.getHiveUid(), new HiveDrop(0.8, BeeDefinition.MARSHY, mossyComb).setIgnobleShare(0.4), new HiveDrop(0.03, BeeDefinition.VALIANT, mossyComb));
    }

    private static void registerDungeonLoot() {
        LootTableList.func_186375_a((ResourceLocation)Constants.VILLAGE_NATURALIST_LOOT_KEY);
    }

    @Override
    public void addLootPoolNames(Set<String> lootPoolNames) {
        super.addLootPoolNames(lootPoolNames);
        lootPoolNames.add("forestry_apiculture_items");
        lootPoolNames.add("forestry_apiculture_bees");
    }

    private static void createHives() {
        hiveRegistry.registerHive(IHiveRegistry.HiveType.FOREST.getHiveUid(), HiveDescription.FOREST);
        hiveRegistry.registerHive(IHiveRegistry.HiveType.MEADOWS.getHiveUid(), HiveDescription.MEADOWS);
        hiveRegistry.registerHive(IHiveRegistry.HiveType.DESERT.getHiveUid(), HiveDescription.DESERT);
        hiveRegistry.registerHive(IHiveRegistry.HiveType.JUNGLE.getHiveUid(), HiveDescription.JUNGLE);
        hiveRegistry.registerHive(IHiveRegistry.HiveType.END.getHiveUid(), HiveDescription.END);
        hiveRegistry.registerHive(IHiveRegistry.HiveType.SNOW.getHiveUid(), HiveDescription.SNOW);
        hiveRegistry.registerHive(IHiveRegistry.HiveType.SWAMP.getHiveUid(), HiveDescription.SWAMP);
    }

    private static void createAlleles() {
        IClassification hymnoptera = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "hymnoptera", "Hymnoptera");
        AlleleManager.alleleRegistry.getClassification("class.insecta").addMemberGroup(hymnoptera);
        IClassification apidae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "apidae", "Apidae");
        hymnoptera.addMemberGroup(apidae);
        for (BeeBranchDefinition beeBranch : BeeBranchDefinition.values()) {
            apidae.addMemberGroup(beeBranch.getBranch());
        }
        AlleleEffect.createAlleles();
    }

    public static double getSecondPrincessChance() {
        return secondPrincessChance;
    }

    private static void parseBeeBlacklist(String[] items) {
        for (String item : items) {
            if (item.isEmpty()) continue;
            FMLCommonHandler.instance().getFMLLogger().debug("Blacklisting bee species identified by " + item);
            AlleleManager.alleleRegistry.blacklistAllele(item);
        }
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerApiculture();
    }

    @Override
    public void populateChunk(IChunkGenerator chunkGenerator, World world, Random rand, int chunkX, int chunkZ, boolean hasVillageGenerated) {
        if (Config.getBeehivesAmount() > 0.0) {
            HiveDecorator.decorateHives(chunkGenerator, world, rand, chunkX, chunkZ, hasVillageGenerated);
        }
    }

    @Override
    public void populateChunkRetroGen(World world, Random rand, int chunkX, int chunkZ) {
        if (Config.getBeehivesAmount() > 0.0) {
            HiveDecorator.decorateHives(world, rand, chunkX, chunkZ);
        }
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-candle-lighting-id")) {
            ItemStack value = message.getItemStackValue();
            if (value != null) {
                BlockCandle.addItemToLightingList(value.func_77973_b());
            } else {
                IMCUtil.logInvalidIMCMessage(message);
            }
            return true;
        }
        if (message.key.equals("add-alveary-slab") && message.isStringMessage()) {
            String messageString = String.format("Received a '%s' request from mod '%s'. This IMC message has been replaced with the oreDictionary for 'slabWood'. Please contact the author and report this issue.", message.key, message.getSender());
            Log.warning(messageString, new Object[0]);
            return true;
        }
        return super.processIMCMessage(message);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) {
        ParticleSnow.sprites = new TextureAtlasSprite[3];
        for (int i = 0; i < ParticleSnow.sprites.length; ++i) {
            ParticleSnow.sprites[i] = event.getMap().func_174942_a(new ResourceLocation("forestry:entity/particles/snow." + (i + 1)));
        }
        ProxyApicultureClient.beeSprite = event.getMap().func_174942_a(new ResourceLocation("forestry:entity/particles/swarm_bee"));
    }

    static {
        beekeepingMode = "NORMAL";
        secondPrincessChance = 0.0f;
    }

    private static class EndFlowerAcceptableRule
    implements IFlowerAcceptableRule {
        private EndFlowerAcceptableRule() {
        }

        @Override
        public boolean isAcceptableFlower(IBlockState blockState, World world, BlockPos pos, String flowerType) {
            Biome biomeGenForCoords = world.func_180494_b(pos);
            return BiomeDictionary.isBiomeOfType((Biome)biomeGenForCoords, (BiomeDictionary.Type)BiomeDictionary.Type.END);
        }
    }
}

