/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.ApicultureCapabilities;
import forestry.api.apiculture.IHiveTile;
import forestry.api.core.Tabs;
import forestry.core.items.ItemForestry;
import forestry.core.proxy.Proxies;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemSmoker
extends ItemForestry {
    public ItemSmoker() {
        super(Tabs.tabApiculture);
        this.func_77625_d(1);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (worldIn.field_72995_K && isSelected && worldIn.field_73012_v.nextInt(40) == 0) {
            ItemSmoker.addSmoke(stack, worldIn, entityIn, 1);
        }
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        super.onUsingTick(stack, player, count);
        World worldObj = player.field_70170_p;
        ItemSmoker.addSmoke(stack, worldObj, (Entity)player, count % 5 + 1);
    }

    private static EnumHandSide getHandSide(ItemStack stack, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
            EnumHand activeHand = entityLivingBase.func_184600_cs();
            EnumHandSide handSide = entityLivingBase.func_184591_cq();
            if (activeHand == EnumHand.OFF_HAND) {
                handSide = handSide == EnumHandSide.LEFT ? EnumHandSide.RIGHT : EnumHandSide.LEFT;
            }
            return handSide;
        }
        return EnumHandSide.RIGHT;
    }

    private static void addSmoke(ItemStack stack, World worldObj, Entity entity, int distance) {
        if (distance <= 0) {
            return;
        }
        Vec3d look = entity.func_70040_Z();
        EnumHandSide handSide = ItemSmoker.getHandSide(stack, entity);
        Vec3d handOffset = handSide == EnumHandSide.RIGHT ? look.func_72431_c(new Vec3d(0.0, 1.0, 0.0)) : look.func_72431_c(new Vec3d(0.0, -1.0, 0.0));
        Vec3d lookDistance = new Vec3d(look.field_72450_a * (double)distance, look.field_72448_b * (double)distance, look.field_72449_c * (double)distance);
        Vec3d scaledOffset = handOffset.func_186678_a(1.0 / (double)distance);
        Vec3d smokePos = lookDistance.func_178787_e(entity.func_174791_d()).func_178787_e(scaledOffset);
        Proxies.render.addEntitySmokeFX(worldObj, smokePos.field_72450_a, smokePos.field_72448_b + 1.0, smokePos.field_72449_c);
        BlockPos blockPos = new BlockPos(smokePos.field_72450_a, smokePos.field_72448_b + 1.0, smokePos.field_72449_c);
        TileEntity tileEntity = worldObj.func_175625_s(blockPos);
        if (tileEntity instanceof IHiveTile) {
            IHiveTile hive = (IHiveTile)tileEntity;
            hive.calmBees();
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IHiveTile) {
            IHiveTile hive = (IHiveTile)tileEntity;
            hive.calmBees();
        }
        return super.onItemUseFirst(stack, player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ICapabilityProvider(){

            public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == ApicultureCapabilities.ARMOR_APIARIST;
            }

            public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability == ApicultureCapabilities.ARMOR_APIARIST) {
                    return (T)capability.getDefaultInstance();
                }
                return null;
            }
        };
    }
}

