/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins.compat;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.Farmables;
import forestry.core.PluginCore;
import forestry.core.circuits.Circuit;
import forestry.core.config.Config;
import forestry.core.items.EnumElectronTube;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.logic.FarmLogicEnder;
import forestry.farming.logic.FarmableAgingCrop;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ForestryPlugin(pluginID="forestry.extra.utilities", name="ExtraUtilities", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.extrautilities.description")
public class PluginExtraUtilities
extends BlankForestryPlugin {
    private static final String ExU = "extrautils2";

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(ExU);
    }

    @Override
    public String getFailMessage() {
        return "ExtraUtilities not found";
    }

    @Override
    public void doInit() {
        super.doInit();
        if (Config.isExUtilEnderLilyEnabled()) {
            Block enderLillyBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(ExU, "enderlilly"));
            Item enderLillyItem = Item.func_150898_a((Block)enderLillyBlock);
            if (enderLillyBlock == Blocks.field_150350_a) {
                Log.error("Could not find ender lilly block.", new Object[0]);
            } else if (enderLillyItem == null) {
                Log.error("Could not find ender lilly item.", new Object[0]);
            } else {
                IProperty<Integer> growthProperty = BlockUtil.getProperty(enderLillyBlock, "growth", Integer.class);
                if (growthProperty == null) {
                    Log.error("Could not find the growth property of ender lily.", new Object[0]);
                } else {
                    int harvestAge = (Integer)Collections.max(growthProperty.func_177700_c());
                    int replantAge = (Integer)enderLillyBlock.func_176223_P().func_177229_b(growthProperty);
                    Farmables.farmables.put((Object)"farmEnder", (Object)new FarmableAgingCrop(new ItemStack(enderLillyItem), enderLillyBlock, growthProperty, harvestAge, replantAge));
                    Circuit.farmEnderManaged = new CircuitFarmLogic("managedEnder", new FarmLogicEnder());
                }
            }
        }
    }

    @Override
    public void registerRecipes() {
        super.registerRecipes();
        if (ForestryAPI.enabledPlugins.contains("forestry.farming") && Circuit.farmEnderManaged != null) {
            ICircuitLayout layoutManaged = ChipsetManager.circuitRegistry.getLayout("forestry.farms.managed");
            ChipsetManager.solderManager.addRecipe(layoutManaged, PluginCore.items.tubes.get(EnumElectronTube.ENDER, 1), Circuit.farmEnderManaged);
        }
    }
}

