/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.food.items;

import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IModelManager;
import forestry.api.food.IBeverageEffect;
import forestry.core.config.Config;
import forestry.core.items.IColoredItem;
import forestry.core.items.ItemForestryFood;
import forestry.core.items.ItemOverlay;
import forestry.food.BeverageEffect;

public class ItemBeverage extends ItemForestryFood implements IColoredItem {
	public interface IBeverageInfo extends ItemOverlay.IOverlayInfo {
		int getHeal();

		float getSaturation();

		boolean isAlwaysEdible();

		void registerModels(Item item, IModelManager manager);
	}

	public final IBeverageInfo[] beverages;

	public ItemBeverage() {
		super(1, 0.2f);
		func_77625_d(1);
		this.beverages = EnumBeverage.VALUES;
	}

	/**
	 * @return true if the item's stackTagCompound needs to be synchronized over SMP.
	 */
	@Override
	public boolean func_77651_p() {
		return true;
	}

	@Override
	public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
		List<IBeverageEffect> effects = BeverageEffect.loadEffects(stack);

		stack.field_77994_a--;

		if (entityLiving instanceof EntityPlayer) {
			EntityPlayer entityplayer = (EntityPlayer) entityLiving;
			entityplayer.func_71024_bL().func_151686_a(this, stack);
			worldIn.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5F, worldIn.field_73012_v.nextFloat() * 0.1F + 0.9F);

			if (worldIn.field_72995_K) {
				return stack;
			}

			for (IBeverageEffect effect : effects) {
				effect.doEffect(worldIn, entityplayer);
			}

			entityplayer.func_71029_a(StatList.func_188057_b(this));
		}

		return stack;
	}

	@Override
	public int func_150905_g(ItemStack itemstack) {
		int meta = itemstack.func_77952_i();
		IBeverageInfo beverage = beverages[meta];
		return beverage.getHeal();
	}

	@Override
	public float func_150906_h(ItemStack itemstack) {
		int meta = itemstack.func_77952_i();
		IBeverageInfo beverage = beverages[meta];
		return beverage.getSaturation();
	}

	@Override
	public int func_77626_a(ItemStack itemstack) {
		return 32;
	}

	@Override
	public EnumAction func_77661_b(ItemStack itemstack) {
		return EnumAction.DRINK;
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand)
	{
		int meta = itemStackIn.func_77952_i();
		IBeverageInfo beverage = beverages[meta];
		if (playerIn.func_71043_e(beverage.isAlwaysEdible())) {
			playerIn.func_184598_c(hand);
			return new ActionResult<>(EnumActionResult.SUCCESS, itemStackIn);
		} else {
			return new ActionResult<>(EnumActionResult.FAIL, itemStackIn);
		}
	}

	@Override
	public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
		for (int i = 0; i < beverages.length; i++) {
			if (Config.isDebug || !beverages[i].isSecret()) {
				itemList.add(new ItemStack(this, 1, i));
			}
		}
	}

	@Override
	public void func_77624_a(ItemStack itemstack, EntityPlayer player, List<String> list, boolean flag) {
		List<IBeverageEffect> effects = BeverageEffect.loadEffects(itemstack);

		for (IBeverageEffect effect : effects) {
			if (effect.getDescription() != null) {
				list.add(effect.getDescription());
			}
		}
	}

	@Override
	public String func_77667_c(ItemStack stack) {
		return super.func_77667_c(stack) + "." + beverages[stack.func_77952_i()].getUid();
	}

	/* MODELS */
	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		for (IBeverageInfo info : beverages) {
			info.registerModels(item, manager);
		}
	}

	@Override
	public int getColorFromItemstack(ItemStack itemstack, int j) {
		if (j == 1 || beverages[itemstack.func_77952_i()].getSecondaryColor() == 0) {
			return beverages[itemstack.func_77952_i()].getPrimaryColor();
		} else {
			return beverages[itemstack.func_77952_i()].getSecondaryColor();
		}
	}

	public ItemStack get(EnumBeverage beverage, int amount) {
		return new ItemStack(this, amount, beverage.ordinal());
	}
}
