/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.fuels.RainSubstrate;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.PluginCore;
import forestry.core.PluginFluids;
import forestry.core.blocks.BlockBogEarth;
import forestry.core.circuits.Circuit;
import forestry.core.circuits.CircuitLayout;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumElectronTube;
import forestry.core.items.ItemElectronTube;
import forestry.core.items.ItemRegistryCore;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.datastructures.FluidMap;
import forestry.core.utils.datastructures.ItemStackMap;
import forestry.factory.DummyManagers;
import forestry.factory.blocks.BlockRegistryFactory;
import forestry.factory.circuits.CircuitSpeedUpgrade;
import forestry.factory.network.PacketRegistryFactory;
import forestry.factory.recipes.CarpenterRecipeManager;
import forestry.factory.recipes.CentrifugeRecipeManager;
import forestry.factory.recipes.FabricatorRecipeManager;
import forestry.factory.recipes.FabricatorSmeltingRecipeManager;
import forestry.factory.recipes.FermenterRecipeManager;
import forestry.factory.recipes.MoistenerRecipeManager;
import forestry.factory.recipes.SqueezerRecipeManager;
import forestry.factory.recipes.StillRecipeManager;
import forestry.factory.triggers.FactoryTriggers;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import forestry.storage.PluginStorage;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@ForestryPlugin(pluginID="forestry.factory", name="Factory", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.factory.description")
public class PluginFactory
extends BlankForestryPlugin {
    public static BlockRegistryFactory blocks;

    @Override
    public void setupAPI() {
        RecipeManagers.carpenterManager = new CarpenterRecipeManager();
        RecipeManagers.centrifugeManager = new CentrifugeRecipeManager();
        RecipeManagers.fabricatorManager = new FabricatorRecipeManager();
        RecipeManagers.fabricatorSmeltingManager = new FabricatorSmeltingRecipeManager();
        RecipeManagers.fermenterManager = new FermenterRecipeManager();
        RecipeManagers.moistenerManager = new MoistenerRecipeManager();
        RecipeManagers.squeezerManager = new SqueezerRecipeManager();
        RecipeManagers.stillManager = new StillRecipeManager();
        PluginFactory.setupFuelManager();
    }

    @Override
    public void disabledSetupAPI() {
        RecipeManagers.carpenterManager = new DummyManagers.DummyCarpenterManager();
        RecipeManagers.centrifugeManager = new DummyManagers.DummyCentrifugeManager();
        RecipeManagers.fabricatorManager = new DummyManagers.DummyFabricatorManager();
        RecipeManagers.fabricatorSmeltingManager = new DummyManagers.DummyFabricatorSmeltingManager();
        RecipeManagers.fermenterManager = new DummyManagers.DummyFermenterManager();
        RecipeManagers.moistenerManager = new DummyManagers.DummyMoistenerManager();
        RecipeManagers.squeezerManager = new DummyManagers.DummySqueezerManager();
        RecipeManagers.stillManager = new DummyManagers.DummyStillManager();
        PluginFactory.setupFuelManager();
    }

    private static void setupFuelManager() {
        FuelManager.fermenterFuel = new ItemStackMap<FermenterFuel>();
        FuelManager.moistenerResource = new ItemStackMap<MoistenerFuel>();
        FuelManager.rainSubstrate = new ItemStackMap<RainSubstrate>();
        FuelManager.bronzeEngineFuel = new FluidMap<EngineBronzeFuel>();
        FuelManager.copperEngineFuel = new ItemStackMap<EngineCopperFuel>();
        FuelManager.generatorFuel = new FluidMap<GeneratorFuel>();
    }

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistryFactory();
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryFactory();
    }

    @Override
    public void preInit() {
        super.preInit();
        ItemRegistryCore coreItems = PluginCore.items;
        ItemStack fertilizerCompound = coreItems.fertilizerCompound.getItemStack();
        FuelManager.fermenterFuel.put(fertilizerCompound, new FermenterFuel(fertilizerCompound, ForestryAPI.activeMode.getIntegerSetting("fermenter.value.fertilizer"), ForestryAPI.activeMode.getIntegerSetting("fermenter.cycles.fertilizer")));
        int cyclesCompost = ForestryAPI.activeMode.getIntegerSetting("fermenter.cycles.compost");
        int valueCompost = ForestryAPI.activeMode.getIntegerSetting("fermenter.value.compost");
        ItemStack fertilizerBio = coreItems.fertilizerBio.getItemStack();
        ItemStack mulch = coreItems.mulch.getItemStack();
        FuelManager.fermenterFuel.put(fertilizerBio, new FermenterFuel(fertilizerBio, valueCompost, cyclesCompost));
        FuelManager.fermenterFuel.put(mulch, new FermenterFuel(mulch, valueCompost, cyclesCompost));
        ItemStack wheat = new ItemStack(Items.field_151015_O);
        ItemStack mouldyWheat = coreItems.mouldyWheat.getItemStack();
        ItemStack decayingWheat = coreItems.decayingWheat.getItemStack();
        FuelManager.moistenerResource.put(wheat, new MoistenerFuel(wheat, mouldyWheat, 0, 300));
        FuelManager.moistenerResource.put(mouldyWheat, new MoistenerFuel(mouldyWheat, decayingWheat, 1, 600));
        FuelManager.moistenerResource.put(decayingWheat, new MoistenerFuel(decayingWheat, mulch, 2, 900));
        ItemStack peat = coreItems.peat.getItemStack();
        FuelManager.copperEngineFuel.put(peat, new EngineCopperFuel(peat, 20, 2500));
        ItemStack bituminousPeat = coreItems.bituminousPeat.getItemStack();
        FuelManager.copperEngineFuel.put(bituminousPeat, new EngineCopperFuel(bituminousPeat, 40, 3000));
        FuelManager.bronzeEngineFuel.put(Fluids.BIOMASS.getFluid(), new EngineBronzeFuel(Fluids.BIOMASS.getFluid(), 50, (int)(2500.0f * ForestryAPI.activeMode.getFloatSetting("fuel.biomass.biogas")), 1));
        FuelManager.bronzeEngineFuel.put(FluidRegistry.WATER, new EngineBronzeFuel(FluidRegistry.WATER, 10, 1000, 3));
        FuelManager.bronzeEngineFuel.put(Fluids.MILK.getFluid(), new EngineBronzeFuel(Fluids.MILK.getFluid(), 10, 10000, 3));
        FuelManager.bronzeEngineFuel.put(Fluids.SEED_OIL.getFluid(), new EngineBronzeFuel(Fluids.SEED_OIL.getFluid(), 30, 2500, 1));
        FuelManager.bronzeEngineFuel.put(Fluids.FOR_HONEY.getFluid(), new EngineBronzeFuel(Fluids.FOR_HONEY.getFluid(), 20, 2500, 1));
        FuelManager.bronzeEngineFuel.put(Fluids.JUICE.getFluid(), new EngineBronzeFuel(Fluids.JUICE.getFluid(), 10, 2500, 1));
        ItemStack iodineCharge = coreItems.iodineCharge.getItemStack();
        ItemStack dissipationCharge = coreItems.craftingMaterial.getDissipationCharge();
        FuelManager.rainSubstrate.put(iodineCharge, new RainSubstrate(iodineCharge, 10000, 0.01f));
        FuelManager.rainSubstrate.put(dissipationCharge, new RainSubstrate(dissipationCharge, 0.075f));
        CircuitLayout layoutMachineUpgrade = new CircuitLayout("machine.upgrade", CircuitSocketType.MACHINE);
        ChipsetManager.circuitRegistry.registerLayout(layoutMachineUpgrade);
    }

    @Override
    public void addLootPoolNames(Set<String> lootPoolNames) {
        super.addLootPoolNames(lootPoolNames);
        lootPoolNames.add("forestry_factory_items");
    }

    @Override
    public void registerTriggers() {
        FactoryTriggers.initialize();
    }

    @Override
    public void doInit() {
        super.doInit();
        PluginFactory.blocks.bottler.init();
        PluginFactory.blocks.carpenter.init();
        PluginFactory.blocks.centrifuge.init();
        PluginFactory.blocks.fermenter.init();
        PluginFactory.blocks.moistener.init();
        PluginFactory.blocks.squeezer.init();
        PluginFactory.blocks.still.init();
        PluginFactory.blocks.rainmaker.init();
        PluginFactory.blocks.fabricator.init();
        PluginFactory.blocks.raintank.init();
        PluginFactory.blocks.worktable.init();
        Circuit.machineSpeedUpgrade1 = new CircuitSpeedUpgrade("machine.speed.boost.1", 0.125, 0.05f);
        Circuit.machineSpeedUpgrade2 = new CircuitSpeedUpgrade("machine.speed.boost.2", 0.25, 0.1f);
        Circuit.machineEfficiencyUpgrade1 = new CircuitSpeedUpgrade("machine.efficiency.1", 0.0, -0.1f);
    }

    @Override
    public void registerRecipes() {
        ItemElectronTube electronTube = PluginCore.items.tubes;
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.COPPER, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotCopper"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.TIN, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotTin"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.BRONZE, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotBronze"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.IRON, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotIron"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.GOLD, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotGold"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.DIAMOND, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "gemDiamond"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.OBSIDIAN, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), Blocks.field_150343_Z});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.BLAZE, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), Items.field_151065_br});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.EMERALD, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "gemEmerald"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.APATITE, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "gemApatite"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.LAPIS, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 4)});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), electronTube.get(EnumElectronTube.ENDER, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), new ItemStack(Items.field_151061_bv, 1, 0), Character.valueOf('X'), new ItemStack(Blocks.field_150377_bs, 1, 0)});
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        if (ForestryAPI.enabledPlugins.contains("forestry.apiculture")) {
            ItemRegistryApiculture beeItems = PluginApiculture.items;
            FluidStack liquidGlass = Fluids.GLASS.getFluid(1000);
            FluidStack liquidGlassX4 = Fluids.GLASS.getFluid(4000);
            for (int i = 0; i < 16; ++i) {
                RecipeManagers.fabricatorManager.addRecipe(beeItems.waxCast.getWildcard(), liquidGlass, new ItemStack((Block)Blocks.field_150399_cn, 4, 15 - i), new Object[]{"#", "X", Character.valueOf('#'), dyes[i], Character.valueOf('X'), beeItems.propolis.getWildcard()});
            }
            RecipeManagers.fabricatorManager.addRecipe(beeItems.waxCast.getWildcard(), liquidGlassX4, new ItemStack(Blocks.field_150359_w, 1, 0), new Object[]{"#", "X", Character.valueOf('X'), beeItems.propolis.getWildcard()});
        }
        int appleMulchAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.mulch.apple");
        int appleJuiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple");
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151034_e)}, Fluids.JUICE.getFluid(appleJuiceAmount), PluginCore.items.mulch.getItemStack(), appleMulchAmount);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151172_bF)}, Fluids.JUICE.getFluid(appleJuiceAmount), PluginCore.items.mulch.getItemStack(), appleMulchAmount);
        int seedOilAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        FluidStack seedOil = Fluids.SEED_OIL.getFluid(seedOilAmount);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151014_N)}, seedOil);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151080_bb)}, seedOil);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151081_bc)}, seedOil);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_185163_cU)}, seedOil);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{PluginCore.items.phosphor.getItemStack(2), new ItemStack(Blocks.field_150347_e)}, new FluidStack(FluidRegistry.LAVA, 1600));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack((Block)Blocks.field_150434_aF)}, new FluidStack(FluidRegistry.WATER, 500));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151126_ay), PluginCore.items.craftingMaterial.getIceShard(4)}, Fluids.ICE.getFluid(4000));
        RecipeManagers.stillManager.addRecipe(100, Fluids.BIOMASS.getFluid(10), Fluids.BIO_ETHANOL.getFluid(3));
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Items.field_151014_N), new ItemStack((Block)Blocks.field_150391_bh), 5000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150341_Y), 20000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150417_aV, 1, 1), 20000);
        for (int i = 0; i < 6; ++i) {
            RecipeUtil.addFermenterRecipes(new ItemStack(Blocks.field_150345_g, 1, i), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        }
        RecipeUtil.addFermenterRecipes(new ItemStack((Block)Blocks.field_150434_aF), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.cactus"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack(Items.field_151015_O), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack(Items.field_151174_bG), 2 * ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack(Items.field_151120_aE), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.cane"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack((Block)Blocks.field_150338_P), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.mushroom"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack((Block)Blocks.field_150337_Q), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.mushroom"), Fluids.BIOMASS);
        RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.field_150359_w), Fluids.GLASS.getFluid(1000), 1000);
        RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.field_150410_aZ), Fluids.GLASS.getFluid(375), 1000);
        RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack((Block)Blocks.field_150354_m), Fluids.GLASS.getFluid(1000), 3000);
        RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack((Block)Blocks.field_150354_m, 1, 1), Fluids.GLASS.getFluid(1000), 3000);
        RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.field_150322_A), Fluids.GLASS.getFluid(4000), 4800);
        RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.field_150322_A, 1, 1), Fluids.GLASS.getFluid(4000), 4800);
        RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.field_150322_A, 1, 2), Fluids.GLASS.getFluid(4000), 4800);
        RecipeManagers.carpenterManager.addRecipe(50, Fluids.SEED_OIL.getFluid(250), null, PluginCore.items.impregnatedCasing.getItemStack(), "###", "# #", "###", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(50, Fluids.SEED_OIL.getFluid(500), null, new ItemStack((Block)PluginCore.blocks.escritoire), "#  ", "###", "# #", Character.valueOf('#'), "plankWood");
        RecipeManagers.carpenterManager.addRecipe(10, Fluids.SEED_OIL.getFluid(100), null, PluginCore.items.stickImpregnated.getItemStack(2), "#", "#", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 250), null, PluginCore.items.woodPulp.getItemStack(4), "#", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 250), null, new ItemStack(Items.field_151121_aF, 1), "#", "#", Character.valueOf('#'), "pulpWood");
        RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 1000), null, new ItemStack((Block)PluginCore.blocks.humus, 9), "###", "#X#", "###", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), PluginCore.items.mulch);
        RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 1000), null, PluginCore.blocks.bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, 8), "#X#", "XYX", "#X#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), "sand", Character.valueOf('Y'), PluginCore.items.mulch);
        RecipeManagers.carpenterManager.addRecipe(75, new FluidStack(FluidRegistry.WATER, 5000), null, PluginCore.items.hardenedCasing.getItemStack(), "# #", " Y ", "# #", Character.valueOf('#'), "gemDiamond", Character.valueOf('Y'), PluginCore.items.sturdyCasing);
        ItemStack basicCircuitboard = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.BASIC, null, new ICircuit[0]);
        ItemStack enhancedCircuitboard = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.ENHANCED, null, new ICircuit[0]);
        ItemStack refinedCircuitboard = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0]);
        ItemStack intricateCircuitboard = ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.INTRICATE, null, new ICircuit[0]);
        RecipeManagers.carpenterManager.addRecipe(20, new FluidStack(FluidRegistry.WATER, 1000), null, basicCircuitboard, "R R", "R#R", "R R", Character.valueOf('#'), "ingotTin", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(40, new FluidStack(FluidRegistry.WATER, 1000), null, enhancedCircuitboard, "R#R", "R#R", "R#R", Character.valueOf('#'), "ingotBronze", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(80, new FluidStack(FluidRegistry.WATER, 1000), null, refinedCircuitboard, "R#R", "R#R", "R#R", Character.valueOf('#'), "ingotIron", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(80, new FluidStack(FluidRegistry.WATER, 1000), null, intricateCircuitboard, "R#R", "R#R", "R#R", Character.valueOf('#'), "ingotGold", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(40, new FluidStack(FluidRegistry.WATER, 1000), null, PluginCore.items.solderingIron.getItemStack(), " # ", "# #", "  B", Character.valueOf('#'), "ingotIron", Character.valueOf('B'), "ingotBronze");
        ItemRegistryApiculture beeItems = PluginApiculture.items;
        if (beeItems != null) {
            RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 1000), null, PluginCore.items.iodineCharge.getItemStack(), "Z#Z", "#Y#", "X#X", Character.valueOf('#'), beeItems.pollenCluster.getWildcard(), Character.valueOf('X'), Items.field_151016_H, Character.valueOf('Y'), PluginFluids.items.canEmpty, Character.valueOf('Z'), beeItems.honeyDrop);
            RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 1000), null, PluginCore.items.craftingMaterial.getDissipationCharge(), "Z#Z", "#Y#", "X#X", Character.valueOf('#'), beeItems.royalJelly, Character.valueOf('X'), Items.field_151016_H, Character.valueOf('Y'), PluginFluids.items.canEmpty, Character.valueOf('Z'), beeItems.honeydew);
        }
        RecipeManagers.carpenterManager.addRecipe(100, null, new ItemStack(Items.field_151079_bi, 1), " # ", "###", " # ", Character.valueOf('#'), PluginCore.items.craftingMaterial.getPulsatingMesh());
        RecipeManagers.carpenterManager.addRecipe(10, new FluidStack(FluidRegistry.WATER, 500), null, PluginCore.items.craftingMaterial.getWovenSilk(), "###", "###", "###", Character.valueOf('#'), PluginCore.items.craftingMaterial.getSilkWisp());
        RecipeManagers.carpenterManager.addRecipe(5, new FluidStack(FluidRegistry.WATER, 1000), null, PluginCore.items.carton.getItemStack(2), " # ", "# #", " # ", Character.valueOf('#'), "pulpWood");
        RecipeManagers.carpenterManager.addRecipe(20, (FluidStack)null, PluginCore.items.carton.getItemStack(), PluginCore.items.kitPickaxe.getItemStack(), "###", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeManagers.carpenterManager.addRecipe(20, (FluidStack)null, PluginCore.items.carton.getItemStack(), PluginCore.items.kitShovel.getItemStack(), " # ", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        ItemStack ingotBronze = PluginCore.items.ingotBronze.func_77946_l();
        ingotBronze.field_77994_a = 2;
        RecipeManagers.carpenterManager.addRecipe(null, ingotBronze, "#", Character.valueOf('#'), PluginCore.items.brokenBronzePickaxe);
        ingotBronze = ingotBronze.func_77946_l();
        ingotBronze.field_77994_a = 1;
        RecipeManagers.carpenterManager.addRecipe(null, ingotBronze, "#", Character.valueOf('#'), PluginCore.items.brokenBronzeShovel);
        if (ForestryAPI.enabledPlugins.contains("forestry.storage")) {
            PluginStorage.createCrateRecipes();
        }
        ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout("forestry.machine.upgrade");
        ChipsetManager.solderManager.addRecipe(layout, PluginCore.items.tubes.get(EnumElectronTube.EMERALD, 1), Circuit.machineSpeedUpgrade1);
        ChipsetManager.solderManager.addRecipe(layout, PluginCore.items.tubes.get(EnumElectronTube.BLAZE, 1), Circuit.machineSpeedUpgrade2);
        ChipsetManager.solderManager.addRecipe(layout, PluginCore.items.tubes.get(EnumElectronTube.GOLD, 1), Circuit.machineEfficiencyUpgrade1);
        RecipeUtil.addRecipe(PluginFactory.blocks.bottler, "X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), PluginFluids.items.canEmpty, Character.valueOf('Y'), PluginCore.items.sturdyCasing);
        RecipeUtil.addRecipe(PluginFactory.blocks.carpenter, "X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), PluginCore.items.sturdyCasing);
        RecipeUtil.addRecipe(PluginFactory.blocks.centrifuge, "X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotCopper", Character.valueOf('Y'), PluginCore.items.sturdyCasing);
        RecipeUtil.addRecipe(PluginFactory.blocks.fermenter, "X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "gearBronze", Character.valueOf('Y'), PluginCore.items.sturdyCasing);
        RecipeUtil.addRecipe(PluginFactory.blocks.moistener, "X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "gearCopper", Character.valueOf('Y'), PluginCore.items.sturdyCasing);
        RecipeUtil.addRecipe(PluginFactory.blocks.squeezer, "X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotTin", Character.valueOf('Y'), PluginCore.items.sturdyCasing);
        RecipeUtil.addRecipe(PluginFactory.blocks.still, "X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "dustRedstone", Character.valueOf('Y'), PluginCore.items.sturdyCasing);
        RecipeUtil.addRecipe(PluginFactory.blocks.rainmaker, "X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "gearTin", Character.valueOf('Y'), PluginCore.items.hardenedCasing);
        RecipeUtil.addRecipe(PluginFactory.blocks.fabricator, "X#X", "#Y#", "XZX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotGold", Character.valueOf('Y'), PluginCore.items.sturdyCasing, Character.valueOf('Z'), "chestWood");
        RecipeUtil.addRecipe(PluginFactory.blocks.raintank, "X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotIron", Character.valueOf('Y'), PluginCore.items.sturdyCasing);
        RecipeUtil.addRecipe(PluginFactory.blocks.worktable, "B", "W", "C", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('W'), "craftingTableWood", Character.valueOf('C'), "chestWood");
    }
}

