/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.mail;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldSavedData;

import forestry.api.mail.EnumAddressee;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.PostManager;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.utils.InventoryUtil;

public class POBox extends WorldSavedData implements IInventory {

	public static final String SAVE_NAME = "POBox_";
	public static final short SLOT_SIZE = 84;

	private IMailAddress address;
	private final InventoryAdapter letters = new InventoryAdapter(SLOT_SIZE, "Letters").disableAutomation();

	public POBox(IMailAddress address) {
		super(SAVE_NAME + address);
		if (address.getType() != EnumAddressee.PLAYER) {
			throw new IllegalArgumentException("POBox address must be a player");
		}
		this.address = address;
	}

	public POBox(String savename) {
		super(savename);
	}

	@Override
	public void func_76184_a(NBTTagCompound nbttagcompound) {
		if (nbttagcompound.func_74764_b("address")) {
			this.address = new MailAddress(nbttagcompound.func_74775_l("address"));
		}
		letters.readFromNBT(nbttagcompound);
	}

	@Override
	public NBTTagCompound func_189551_b(NBTTagCompound nbttagcompound) {
		if (this.address != null) {
			NBTTagCompound nbt = new NBTTagCompound();
			this.address.writeToNBT(nbt);
			nbttagcompound.func_74782_a("address", nbt);
		}
		letters.writeToNBT(nbttagcompound);
		return nbttagcompound;
	}

	public boolean storeLetter(ItemStack letterstack) {
		ILetter letter = PostManager.postRegistry.getLetter(letterstack);

		// Mark letter as processed
		letter.setProcessed(true);
		letter.invalidatePostage();
		NBTTagCompound nbttagcompound = new NBTTagCompound();
		letter.writeToNBT(nbttagcompound);
		letterstack.func_77982_d(nbttagcompound);

		this.func_76185_a();

		return InventoryUtil.tryAddStack(letters, letterstack, true);
	}

	public POBoxInfo getPOBoxInfo() {
		int playerLetters = 0;
		int tradeLetters = 0;
		for (int i = 0; i < letters.func_70302_i_(); i++) {
			if (letters.func_70301_a(i) == null) {
				continue;
			}
			ILetter letter = new Letter(letters.func_70301_a(i).func_77978_p());
			if (letter.getSender().getType() == EnumAddressee.PLAYER) {
				playerLetters++;
			} else {
				tradeLetters++;
			}
		}

		return new POBoxInfo(playerLetters, tradeLetters);
	}

	/* IINVENTORY */
	@Override
	public void func_76185_a() {
		super.func_76185_a();
		letters.func_70296_d();
	}

	@Override
	public void func_70299_a(int var1, ItemStack var2) {
		this.func_76185_a();
		letters.func_70299_a(var1, var2);
	}

	@Override
	public int func_70302_i_() {
		return letters.func_70302_i_();
	}

	@Override
	public ItemStack func_70301_a(int var1) {
		return letters.func_70301_a(var1);
	}

	@Override
	public ItemStack func_70298_a(int var1, int var2) {
		return letters.func_70298_a(var1, var2);
	}
	
	@Override
	public ItemStack func_70304_b(int index) {
		return letters.func_70304_b(index);
	}

	@Override
	public String func_70005_c_() {
		return letters.func_70005_c_();
	}

	@Override
	public int func_70297_j_() {
		return letters.func_70297_j_();
	}

	@Override
	public boolean func_70300_a(EntityPlayer var1) {
		return letters.func_70300_a(var1);
	}

	@Override
	public void func_174889_b(EntityPlayer var1) {
	}

	@Override
	public void func_174886_c(EntityPlayer var1) {
	}

	@Override
	public boolean func_145818_k_() {
		return true;
	}

	@Override
	public boolean func_94041_b(int i, ItemStack itemstack) {
		return letters.func_94041_b(i, itemstack);
	}

	@Override
	public ITextComponent func_145748_c_() {
		return letters.func_145748_c_();
	}

	/* FIELDS */
	@Override
	public int func_174887_a_(int id) {
		return 0;
	}

	@Override
	public void func_174885_b(int id, int value) {
	}

	@Override
	public int func_174890_g() {
		return 0;
	}

	@Override
	public void func_174888_l() {
	}

}
