/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.EnumAddressee;
import forestry.api.mail.IMailAddress;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiTextBox;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.proxy.Proxies;
import forestry.core.render.ColourProperties;
import forestry.core.utils.Translator;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.gui.widgets.AddresseeSlot;
import forestry.mail.inventory.ItemInventoryLetter;
import forestry.mail.network.packets.PacketLetterInfoRequest;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;

public class GuiLetter
extends GuiForestry<ContainerLetter, ItemInventoryLetter> {
    private final boolean isProcessedLetter;
    private boolean checkedSessionVars;
    private GuiTextField address;
    private GuiTextBox text;
    private boolean addressFocus;
    private boolean textFocus;
    private final ArrayList<Widget> tradeInfoWidgets;

    public GuiLetter(EntityPlayer player, ItemInventoryLetter inventory) {
        super("textures/gui/letter.png", new ContainerLetter(player, inventory), inventory);
        this.field_146999_f = 194;
        this.field_147000_g = 227;
        this.isProcessedLetter = ((ContainerLetter)this.container).getLetter().isProcessed();
        this.widgetManager.add(new AddresseeSlot(this.widgetManager, 16, 12, (ContainerLetter)this.container));
        this.tradeInfoWidgets = new ArrayList();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.address = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 46, this.field_147009_r + 13, 93, 13);
        IMailAddress recipient = ((ContainerLetter)this.container).getRecipient();
        if (recipient != null) {
            this.address.func_146180_a(recipient.getName());
        }
        this.text = new GuiTextBox(1, this.field_146289_q, this.field_147003_i + 17, this.field_147009_r + 31, 122, 57);
        this.text.func_146203_f(128);
        if (!((ContainerLetter)this.container).getText().isEmpty()) {
            this.text.func_146180_a(((ContainerLetter)this.container).getText());
        }
    }

    protected void func_73869_a(char eventCharacter, int eventKey) throws IOException {
        if (this.address.func_146206_l()) {
            if (eventKey == 28) {
                this.address.func_146195_b(false);
            } else {
                this.address.func_146201_a(eventCharacter, eventKey);
            }
            return;
        }
        if (this.text.func_146206_l()) {
            if (eventKey == 28) {
                if (Proxies.common.isShiftDown()) {
                    this.text.func_146180_a(this.text.func_146179_b() + "\n");
                } else {
                    this.text.func_146195_b(false);
                }
            } else if (eventKey == 208) {
                this.text.advanceLine();
            } else if (eventKey == 200) {
                this.text.regressLine();
            } else if (this.text.moreLinesAllowed() || eventKey == 211 || eventKey == 14) {
                this.text.func_146201_a(eventCharacter, eventKey);
            }
            return;
        }
        super.func_73869_a(eventCharacter, eventKey);
    }

    @Override
    protected void func_73864_a(int par1, int par2, int mouseButton) throws IOException {
        super.func_73864_a(par1, par2, mouseButton);
        this.address.func_146192_a(par1, par2, mouseButton);
        this.text.func_146192_a(par1, par2, mouseButton);
    }

    @Override
    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        EnumAddressee recipientType;
        String recipient;
        if (!this.isProcessedLetter && !this.checkedSessionVars) {
            this.checkedSessionVars = true;
            this.setFromSessionVars();
            recipient = this.address.func_146179_b();
            recipientType = ((ContainerLetter)this.container).getCarrierType();
            this.setRecipient(recipient, recipientType);
        }
        if (this.addressFocus != this.address.func_146206_l() && StringUtils.isNotBlank((CharSequence)(recipient = this.address.func_146179_b()))) {
            recipientType = ((ContainerLetter)this.container).getCarrierType();
            this.setRecipient(recipient, recipientType);
        }
        this.addressFocus = this.address.func_146206_l();
        if (this.textFocus != this.text.func_146206_l()) {
            this.setText();
        }
        this.textFocus = this.text.func_146206_l();
        super.func_146976_a(var1, mouseX, mouseY);
        if (this.isProcessedLetter) {
            this.field_146289_q.func_78276_b(this.address.func_146179_b(), this.field_147003_i + 49, this.field_147009_r + 16, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
            this.field_146289_q.func_78279_b(this.text.func_146179_b(), this.field_147003_i + 20, this.field_147009_r + 34, 119, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
        } else {
            this.clearTradeInfoWidgets();
            this.address.func_146194_f();
            if (((ContainerLetter)this.container).getCarrierType() == EnumAddressee.TRADER) {
                this.drawTradePreview(18, 32);
            } else {
                this.text.func_146194_f();
            }
        }
    }

    private void drawTradePreview(int x, int y) {
        String infoString = null;
        if (((ContainerLetter)this.container).getTradeInfo() == null) {
            infoString = Translator.translateToLocal("for.gui.mail.no.trader");
        } else if (((ContainerLetter)this.container).getTradeInfo().getTradegood() == null) {
            infoString = Translator.translateToLocal("for.gui.mail.nothing.to.trade");
        } else if (!((ContainerLetter)this.container).getTradeInfo().getState().isOk()) {
            infoString = ((ContainerLetter)this.container).getTradeInfo().getState().getDescription();
        }
        if (infoString != null) {
            this.field_146289_q.func_78279_b(infoString, this.field_147003_i + x, this.field_147009_r + y, 119, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
            return;
        }
        this.field_146289_q.func_78276_b(Translator.translateToLocal("for.gui.mail.pleasesend"), this.field_147003_i + x, this.field_147009_r + y, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
        this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x, y + 10, ((ContainerLetter)this.container).getTradeInfo().getTradegood()));
        this.field_146289_q.func_78276_b(Translator.translateToLocal("for.gui.mail.foreveryattached"), this.field_147003_i + x, this.field_147009_r + y + 28, ColourProperties.INSTANCE.get("gui.mail.lettertext"));
        for (int i = 0; i < ((ContainerLetter)this.container).getTradeInfo().getRequired().length; ++i) {
            this.addTradeInfoWidget(new ItemStackWidget(this.widgetManager, x + i * 18, y + 38, ((ContainerLetter)this.container).getTradeInfo().getRequired()[i]));
        }
    }

    private void addTradeInfoWidget(Widget widget) {
        this.tradeInfoWidgets.add(widget);
        this.widgetManager.add(widget);
    }

    private void clearTradeInfoWidgets() {
        for (Widget widget : this.tradeInfoWidgets) {
            this.widgetManager.remove(widget);
        }
        this.tradeInfoWidgets.clear();
    }

    @Override
    public void func_146281_b() {
        String recipientName = this.address.func_146179_b();
        EnumAddressee recipientType = ((ContainerLetter)this.container).getCarrierType();
        this.setRecipient(recipientName, recipientType);
        this.setText();
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    private void setFromSessionVars() {
        if (SessionVars.getStringVar("mail.letter.recipient") == null) {
            return;
        }
        String recipient = SessionVars.getStringVar("mail.letter.recipient");
        String typeName = SessionVars.getStringVar("mail.letter.addressee");
        if (StringUtils.isNotBlank((CharSequence)recipient) && StringUtils.isNotBlank((CharSequence)typeName)) {
            this.address.func_146180_a(recipient);
            EnumAddressee type = EnumAddressee.fromString(typeName);
            ((ContainerLetter)this.container).setCarrierType(type);
        }
        SessionVars.clearStringVar("mail.letter.recipient");
        SessionVars.clearStringVar("mail.letter.addressee");
    }

    private void setRecipient(String recipientName, EnumAddressee type) {
        if (this.isProcessedLetter || StringUtils.isBlank((CharSequence)recipientName) || type == null) {
            return;
        }
        PacketLetterInfoRequest packet = new PacketLetterInfoRequest(recipientName, type);
        Proxies.net.sendToServer(packet);
    }

    private void setText() {
        if (this.isProcessedLetter) {
            return;
        }
        ((ContainerLetter)this.container).setText(this.text.func_146179_b());
    }
}

