/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.items;

import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IModelManager;

public class ItemCraftingMaterial extends ItemForestry {

	private final String[] definition = new String[]{"pulsatingDust", "pulsatingMesh", "silkWisp", "wovenSilk", "dissipationCharge", "iceShard", "scentedPaneling", "camouflagedPaneling" };

	public ItemCraftingMaterial() {
		func_77656_e(0);
		func_77627_a(true);
	}

	@Override
	public boolean func_77645_m() {
		return false;
	}

	@Override
	public boolean isRepairable() {
		return false;
	}

	@Override
	public String func_77667_c(ItemStack stack) {
		if (stack.func_77952_i() >= definition.length || stack.func_77952_i() < 0) {
			return "item.forestry.unknown";
		} else {
			return super.func_77667_c(stack) + "." + definition[stack.func_77952_i()];
		}
	}

	/* Models */
	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		for (int i = 0; i < definition.length; i++) {
			manager.registerItemModel(item, i, definition[i]);
		}
	}

	@Override
	public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
		for (int i = 0; i < definition.length; i++) {
			itemList.add(new ItemStack(this, 1, i));
		}
	}

	public ItemStack getPulsatingDust() {
		return new ItemStack(this, 1, 0);
	}

	public ItemStack getPulsatingMesh() {
		return new ItemStack(this, 1, 1);
	}

	public ItemStack getSilkWisp() {
		return new ItemStack(this, 1, 2);
	}

	public ItemStack getWovenSilk() {
		return new ItemStack(this, 1, 3);
	}

	public ItemStack getDissipationCharge() {
		return new ItemStack(this, 1, 4);
	}

	public ItemStack getIceShard(int amount) {
		return new ItemStack(this, amount, 5);
	}

	public ItemStack getScentedPaneling() {
		return new ItemStack(this, 1, 6);
	}
	
	public ItemStack getCamouflagedPaneling() {
		return getCamouflagedPaneling(1);
	}
	
	public ItemStack getCamouflagedPaneling(int stackSize) {
		return new ItemStack(this, stackSize, 7);
	}
}
