/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTreeVanilla;
import forestry.core.worldgen.WorldGenHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenJungle
extends WorldGenTreeVanilla {
    public WorldGenJungle(ITreeGenData tree) {
        super(tree);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        int height = this.height;
        float vinesChance = 0.0f;
        if (this.girth >= 2) {
            height = (int)((float)height * 1.5f);
            vinesChance = 0.8f;
        }
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, height, this.girth, 0, vinesChance, null, 0.0f);
        HashSet<BlockPos> branchCoords = new HashSet<BlockPos>();
        if (height > 10) {
            for (int branchSpawn = 6; branchSpawn < height - 2; branchSpawn += rand.nextInt(4)) {
                branchCoords.addAll(WorldGenHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, branchSpawn, 0), this.girth, 0.5f, 0.0f, 2, 1, 0.25f));
            }
        }
        return branchCoords;
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        int height = this.height;
        if (this.girth >= 2) {
            height = (int)((float)height * 1.5f);
        }
        for (BlockPos branchEnd : branchEnds) {
            WorldGenHelper.generateCylinderFromPos(world, leaf, branchEnd, this.girth, 1, WorldGenHelper.EnumReplaceMode.AIR);
        }
        int leafSpawn = height + 1;
        float canopyRadiusMultiplier = (float)height / 7.0f;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 0.5f * canopyRadiusMultiplier + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.9f * canopyRadiusMultiplier + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 1.9f * canopyRadiusMultiplier + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
    }
}

