/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.items;

import java.util.List;
import java.util.Locale;

import forestry.api.core.EnumContainerType;
import forestry.api.core.IModelManager;
import forestry.core.CreativeTabForestry;
import forestry.core.config.Constants;
import forestry.core.fluids.Fluids;
import forestry.core.utils.Translator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidContainerForestry extends ItemForestry {
	private final EnumContainerType type;

	public ItemFluidContainerForestry(EnumContainerType type) {
		super(CreativeTabForestry.tabForestry);
		this.type = type;
	}

	/* Models */
	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		String identifier = "liquids/" + type.toString().toLowerCase(Locale.ENGLISH);
		manager.registerItemModel(item, 0, identifier + "_empty");
		ModelLoader.setCustomModelResourceLocation(item, 1, new ModelResourceLocation(new ResourceLocation(Constants.MOD_ID, identifier), "inventory"));
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
		// empty
		subItems.add(new ItemStack(itemIn));

		// filled
		for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
			ItemStack itemStack = new ItemStack(itemIn);
			IFluidHandler fluidHandler = new FluidHandlerItemForestry(itemStack, type);
			if (fluidHandler.fill(new FluidStack(fluid, Fluid.BUCKET_VOLUME), true) == Fluid.BUCKET_VOLUME) {
				subItems.add(itemStack);
			}
		}
	}

	public EnumContainerType getType() {
		return type;
	}

	protected FluidStack getContained(ItemStack itemStack) {
		if (itemStack.field_77994_a != 1) {
			itemStack = itemStack.func_77946_l();
			itemStack.field_77994_a = 1;
		}
		IFluidHandler fluidHandler = new FluidHandlerItemForestry(itemStack, type);
		return fluidHandler.drain(Integer.MAX_VALUE, false);
	}

	@Override
	public String func_77653_i(ItemStack stack) {
		Item item = stack.func_77973_b();
		if (item instanceof ItemFluidContainerForestry) {
			FluidStack fluid = getContained(stack);
			if (fluid != null) {
				String exactTranslationKey = "item.for." + type.getName() + '.' + fluid.getFluid().getName() + ".name";
				if (Translator.canTranslateToLocal(exactTranslationKey)) {
					return Translator.translateToLocal(exactTranslationKey);
				} else {
					String grammarKey = "item.for." + type.getName() + ".grammar";
					return Translator.translateToLocalFormatted(grammarKey, fluid.getLocalizedName());
				}
			} else {
				String unlocalizedname = "item.for." + type.getName() + ".empty.name";
				return Translator.translateToLocal(unlocalizedname);
			}
		}
		return super.func_77653_i(stack);
	}

	/** DRINKS */
	@Override
	public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
		DrinkProperties drinkProperties = getDrinkProperties(stack);
		if (drinkProperties != null) {
			if (entityLiving instanceof EntityPlayer && !((EntityPlayer) entityLiving).field_71075_bZ.field_75098_d) {
				EntityPlayer player = (EntityPlayer) entityLiving;
				if (!player.field_71075_bZ.field_75098_d) {
					--stack.field_77994_a;
				}

				if (!worldIn.field_72995_K) {
					FoodStats foodStats = player.func_71024_bL();
					foodStats.func_75122_a(drinkProperties.getHealAmount(), drinkProperties.getSaturationModifier());
					worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5F, worldIn.field_73012_v.nextFloat() * 0.1F + 0.9F);
				}

				player.func_71029_a(StatList.func_188057_b(this));
			}
		}
		return stack;
	}

	protected DrinkProperties getDrinkProperties(ItemStack itemStack) {
		FluidStack contained = getContained(itemStack);
		if (contained != null) {
			Fluids definition = Fluids.getFluidDefinition(contained);
			if (definition != null) {
				return definition.getDrinkProperties();
			}
		}
		return null;
	}

	@Override
	public int func_77626_a(ItemStack itemstack) {
		DrinkProperties drinkProperties = getDrinkProperties(itemstack);
		if (drinkProperties != null) {
			return drinkProperties.getMaxItemUseDuration();
		} else {
			return super.func_77626_a(itemstack);
		}
	}

	@Override
	public EnumAction func_77661_b(ItemStack itemstack) {
		DrinkProperties drinkProperties = getDrinkProperties(itemstack);
		if (drinkProperties != null) {
			return EnumAction.DRINK;
		} else {
			return EnumAction.NONE;
		}
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
		DrinkProperties drinkProperties = getDrinkProperties(itemStackIn);
		if (drinkProperties != null) {
			if (playerIn.func_71043_e(false)) {
				playerIn.func_184598_c(hand);
				return new ActionResult<>(EnumActionResult.SUCCESS, itemStackIn);
			} else {
				return new ActionResult<>(EnumActionResult.FAIL, itemStackIn);
			}
		} else {
			return super.func_77659_a(itemStackIn, worldIn, playerIn, hand);
		}
	}

	@Override
	public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt)
	{
		return new FluidHandlerItemForestry(stack, type);
	}
}
