/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.render;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

import forestry.core.proxy.Proxies;
import forestry.core.render.ForestryResource;

public class ModelAnalyzer extends ModelBase {

	private final ModelRenderer pedestal;
	private final ModelRenderer cover;
	private final ModelRenderer tower1;
	private final ModelRenderer tower2;

	private final ResourceLocation[] textures;

	public ModelAnalyzer(String gfxBase) {

		textures = new ResourceLocation[]{
				new ForestryResource(gfxBase + "pedestal.png"),
				new ForestryResource(gfxBase + "tower1.png"),
				new ForestryResource(gfxBase + "tower2.png"),
		};

		pedestal = new ModelRenderer(this, 0, 0);
		pedestal.func_78789_a(-8F, -8F, -8F, 16, 1, 16);
		pedestal.func_78793_a(8, 8, 8);

		cover = new ModelRenderer(this, 0, 0);
		cover.func_78789_a(-8F, -8F, -8F, 16, 1, 16);
		cover.func_78793_a(8, 8, 8);

		tower1 = new ModelRenderer(this, 0, 0);
		tower1.func_78789_a(-8, -7, -7, 2, 14, 14);
		tower1.func_78793_a(8, 8, 8);

		tower2 = new ModelRenderer(this, 0, 0);
		tower2.func_78789_a(6, -7, -7, 2, 14, 14);
		tower2.func_78793_a(8, 8, 8);

	}

	public void render(EnumFacing orientation, float posX, float posY, float posZ) {

		GlStateManager.func_179094_E();

		GlStateManager.func_179109_b(posX, posY, posZ);
		float[] angle = {0, 0, 0};

		if (orientation == null) {
			orientation = EnumFacing.WEST;
		}
		switch (orientation) {
			case EAST:
				angle[1] = (float) Math.PI / 2;
				break;
			case WEST:
				angle[1] = -(float) Math.PI / 2;
				break;
			case SOUTH:
				break;
			case NORTH:
			default:
				angle[1] = (float) Math.PI;
				break;
		}

		float factor = (float) (1.0 / 16.0);

		Proxies.render.bindTexture(textures[0]);

		pedestal.field_78795_f = angle[0];
		pedestal.field_78796_g = angle[1];
		pedestal.field_78808_h = angle[2];
		pedestal.func_78785_a(factor);

		cover.field_78795_f = angle[0];
		cover.field_78796_g = angle[1];
		cover.field_78808_h = (float) Math.PI;
		cover.func_78785_a(factor);

		tower1.field_78795_f = angle[0];
		tower1.field_78796_g = angle[1];
		tower1.field_78808_h = angle[2];
		Proxies.render.bindTexture(textures[1]);
		tower1.func_78785_a(factor);

		tower2.field_78795_f = angle[0];
		tower2.field_78796_g = angle[1];
		tower2.field_78808_h = angle[2];
		Proxies.render.bindTexture(textures[2]);
		tower2.func_78785_a(factor);

		GlStateManager.func_179121_F();
	}

}
