/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import forestry.Forestry;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.Farmables;
import forestry.core.PluginCore;
import forestry.core.circuits.Circuit;
import forestry.core.circuits.CircuitLayout;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.items.EnumElectronTube;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.farming.blocks.BlockMushroom;
import forestry.farming.blocks.BlockRegistryFarming;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.logic.FarmLogicArboreal;
import forestry.farming.logic.FarmLogicCereal;
import forestry.farming.logic.FarmLogicCocoa;
import forestry.farming.logic.FarmLogicGourd;
import forestry.farming.logic.FarmLogicInfernal;
import forestry.farming.logic.FarmLogicMushroom;
import forestry.farming.logic.FarmLogicOrchard;
import forestry.farming.logic.FarmLogicPeat;
import forestry.farming.logic.FarmLogicReeds;
import forestry.farming.logic.FarmLogicSucculent;
import forestry.farming.logic.FarmLogicVegetable;
import forestry.farming.logic.FarmableAgingCrop;
import forestry.farming.logic.FarmableGE;
import forestry.farming.logic.FarmableGourd;
import forestry.farming.logic.FarmableStacked;
import forestry.farming.logic.FarmableVanillaMushroom;
import forestry.farming.logic.FarmableVanillaSapling;
import forestry.farming.models.EnumFarmBlockTexture;
import forestry.farming.proxy.ProxyFarming;
import forestry.farming.tiles.TileFarmControl;
import forestry.farming.tiles.TileFarmGearbox;
import forestry.farming.tiles.TileFarmHatch;
import forestry.farming.tiles.TileFarmPlain;
import forestry.farming.tiles.TileFarmValve;
import forestry.farming.triggers.FarmingTriggers;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ForestryPlugin(pluginID="forestry.farming", name="Farming", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.farming.description")
public class PluginFarming
extends BlankForestryPlugin {
    @SidedProxy(clientSide="forestry.farming.proxy.ProxyFarmingClient", serverSide="forestry.farming.proxy.ProxyFarming")
    public static ProxyFarming proxy;
    public static int modelIdFarmBlock;
    public static BlockRegistryFarming blocks;

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistryFarming();
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Farmables.farmables.put((Object)"farmArboreal", (Object)new FarmableVanillaSapling());
        if (ForestryAPI.enabledPlugins.contains("forestry.arboriculture")) {
            Farmables.farmables.put((Object)"farmArboreal", (Object)new FarmableGE());
        }
        Farmables.farmables.putAll((Object)"farmOrchard", Arrays.asList(new FarmableAgingCrop(new ItemStack(Items.field_151014_N), Blocks.field_150464_aj, (IProperty<Integer>)BlockCrops.field_176488_a, 7, 0), new FarmableAgingCrop(new ItemStack(Items.field_151174_bG), Blocks.field_150469_bN, (IProperty<Integer>)BlockCrops.field_176488_a, 7, 0), new FarmableAgingCrop(new ItemStack(Items.field_151172_bF), Blocks.field_150459_bM, (IProperty<Integer>)BlockCrops.field_176488_a, 7, 0), new FarmableAgingCrop(new ItemStack(Items.field_185163_cU), Blocks.field_185773_cZ, (IProperty<Integer>)BlockBeetroot.field_185531_a, 3, 0)));
        IBlockState plantedBrownMushroom = PluginFarming.blocks.mushroom.func_176223_P().func_177226_a(BlockMushroom.VARIANT, (Comparable)((Object)BlockMushroom.MushroomType.BROWN));
        Farmables.farmables.put((Object)"farmShroom", (Object)new FarmableVanillaMushroom(new ItemStack((Block)Blocks.field_150338_P), plantedBrownMushroom, Blocks.field_150420_aW));
        IBlockState plantedRedMushroom = PluginFarming.blocks.mushroom.func_176223_P().func_177226_a(BlockMushroom.VARIANT, (Comparable)((Object)BlockMushroom.MushroomType.RED));
        Farmables.farmables.put((Object)"farmShroom", (Object)new FarmableVanillaMushroom(new ItemStack((Block)Blocks.field_150337_Q), plantedRedMushroom, Blocks.field_150419_aX));
        Farmables.farmables.put((Object)"farmWheat", (Object)new FarmableAgingCrop(new ItemStack(Items.field_151014_N), Blocks.field_150464_aj, (IProperty<Integer>)BlockCrops.field_176488_a, 7));
        Farmables.farmables.put((Object)"farmGourd", (Object)new FarmableGourd(new ItemStack(Items.field_151080_bb), Blocks.field_150393_bb, Blocks.field_150423_aK));
        Farmables.farmables.put((Object)"farmGourd", (Object)new FarmableGourd(new ItemStack(Items.field_151081_bc), Blocks.field_150394_bc, Blocks.field_150440_ba));
        Farmables.farmables.put((Object)"farmInfernal", (Object)new FarmableAgingCrop(new ItemStack(Items.field_151075_bm), Blocks.field_150388_bm, (IProperty<Integer>)BlockNetherWart.field_176486_a, 3));
        Farmables.farmables.put((Object)"farmPoales", (Object)new FarmableStacked(new ItemStack(Items.field_151120_aE), (Block)Blocks.field_150436_aH, 3));
        Farmables.farmables.put((Object)"farmSucculentes", (Object)new FarmableStacked(new ItemStack((Block)Blocks.field_150434_aF), (Block)Blocks.field_150434_aF, 3));
        Farmables.farmables.put((Object)"farmVegetables", (Object)new FarmableAgingCrop(new ItemStack(Items.field_151174_bG), Blocks.field_150469_bN, (IProperty<Integer>)BlockCrops.field_176488_a, 7));
        Farmables.farmables.put((Object)"farmVegetables", (Object)new FarmableAgingCrop(new ItemStack(Items.field_151172_bF), Blocks.field_150459_bM, (IProperty<Integer>)BlockCrops.field_176488_a, 7));
        Farmables.farmables.put((Object)"farmVegetables", (Object)new FarmableAgingCrop(new ItemStack(Items.field_185163_cU), Blocks.field_185773_cZ, (IProperty<Integer>)BlockBeetroot.field_185531_a, 3));
        Farmables.fertilizers.put(new ItemStack((Item)PluginCore.items.fertilizerCompound, 1, Short.MAX_VALUE), 500);
        proxy.initializeModels();
        CircuitLayout layoutManaged = new CircuitLayout("farms.managed", CircuitSocketType.FARM);
        ChipsetManager.circuitRegistry.registerLayout(layoutManaged);
        CircuitLayout layoutManual = new CircuitLayout("farms.manual", CircuitSocketType.FARM);
        ChipsetManager.circuitRegistry.registerLayout(layoutManual);
    }

    private void loadConfig(LocalizedConfiguration config) {
        ArrayList<String> defaultFertilizers = new ArrayList<String>(PluginFarming.getItemStrings(Farmables.fertilizers));
        Collections.sort(defaultFertilizers);
        String[] defaultSortedFertilizers = defaultFertilizers.toArray(new String[defaultFertilizers.size()]);
        Property fertilizerConf = config.get("fertilizers", "items", defaultSortedFertilizers, Translator.translateToLocal("for.config.farm.fertilizers.items"));
        Farmables.fertilizers.clear();
        String[] fertilizerList = fertilizerConf.getStringList();
        for (int i = 0; i < fertilizerList.length; ++i) {
            try {
                String fertilizer = fertilizerList[i];
                String[] fertilizers = fertilizer.split(";");
                ItemStack fertilizerItem = ItemStackUtil.parseItemStackString(fertilizers[0], Short.MAX_VALUE);
                int fertilizerValue = Integer.parseInt(fertilizers[1]);
                Farmables.fertilizers.put(fertilizerItem, fertilizerValue);
                continue;
            }
            catch (Exception e) {
                Log.error("Forestry failed to parse a fertilizer entry at the farm config, at the position " + i + ".", e);
            }
        }
    }

    @Nonnull
    private static Set<String> getItemStrings(LinkedHashMap<ItemStack, Integer> itemStacks) {
        HashSet<String> itemStrings = new HashSet<String>(itemStacks.size());
        for (Map.Entry<ItemStack, Integer> itemStack : itemStacks.entrySet()) {
            String itemString = ItemStackUtil.getStringForItemStack(itemStack.getKey());
            itemString = itemString + ";" + itemStack.getValue();
            itemStrings.add(itemString);
        }
        return itemStrings;
    }

    @Override
    public void registerTriggers() {
        FarmingTriggers.initialize();
    }

    @Override
    public void doInit() {
        super.doInit();
        File configFile = new File(Forestry.instance.getConfigFolder(), "farm.cfg");
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "1.0.0");
        this.loadConfig(config);
        config.save();
        GameRegistry.registerTileEntity(TileFarmPlain.class, (String)"forestry.Farm");
        GameRegistry.registerTileEntity(TileFarmGearbox.class, (String)"forestry.FarmGearbox");
        GameRegistry.registerTileEntity(TileFarmHatch.class, (String)"forestry.FarmHatch");
        GameRegistry.registerTileEntity(TileFarmValve.class, (String)"forestry.FarmValve");
        GameRegistry.registerTileEntity(TileFarmControl.class, (String)"forestry.FarmControl");
        Circuit.farmArborealManaged = new CircuitFarmLogic("managedArboreal", new FarmLogicArboreal());
        Circuit.farmShroomManaged = new CircuitFarmLogic("managedShroom", new FarmLogicMushroom());
        Circuit.farmPeatManaged = new CircuitFarmLogic("managedPeat", new FarmLogicPeat());
        Circuit.farmCerealManaged = new CircuitFarmLogic("managedCereal", new FarmLogicCereal());
        Circuit.farmVegetableManaged = new CircuitFarmLogic("managedVegetable", new FarmLogicVegetable());
        Circuit.farmInfernalManaged = new CircuitFarmLogic("managedInfernal", new FarmLogicInfernal());
        Circuit.farmPeatManual = new CircuitFarmLogic("manualPeat", new FarmLogicPeat()).setManual();
        Circuit.farmShroomManual = new CircuitFarmLogic("manualShroom", new FarmLogicMushroom()).setManual();
        Circuit.farmCerealManual = new CircuitFarmLogic("manualCereal", new FarmLogicCereal()).setManual();
        Circuit.farmVegetableManual = new CircuitFarmLogic("manualVegetable", new FarmLogicVegetable()).setManual();
        Circuit.farmSucculentManual = new CircuitFarmLogic("manualSucculent", new FarmLogicSucculent()).setManual();
        Circuit.farmPoalesManual = new CircuitFarmLogic("manualPoales", new FarmLogicReeds()).setManual();
        Circuit.farmGourdManual = new CircuitFarmLogic("manualGourd", new FarmLogicGourd()).setManual();
        Circuit.farmCocoaManual = new CircuitFarmLogic("manualCocoa", new FarmLogicCocoa()).setManual();
        Circuit.farmOrchardManual = new CircuitFarmLogic("manualOrchard", new FarmLogicOrchard());
    }

    @Override
    public void registerRecipes() {
        ItemStack basic = PluginFarming.blocks.farm.get(EnumFarmBlockType.PLAIN, 1);
        ItemStack gearbox = PluginFarming.blocks.farm.get(EnumFarmBlockType.GEARBOX, 1);
        ItemStack hatch = PluginFarming.blocks.farm.get(EnumFarmBlockType.HATCH, 1);
        ItemStack valve = PluginFarming.blocks.farm.get(EnumFarmBlockType.VALVE, 1);
        ItemStack control = PluginFarming.blocks.farm.get(EnumFarmBlockType.CONTROL, 1);
        for (EnumFarmBlockTexture block : EnumFarmBlockTexture.values()) {
            NBTTagCompound compound = new NBTTagCompound();
            block.saveToCompound(compound);
            basic.func_77982_d(compound);
            gearbox.func_77982_d(compound);
            hatch.func_77982_d(compound);
            valve.func_77982_d(compound);
            control.func_77982_d(compound);
            RecipeUtil.addRecipe(basic, "I#I", "WCW", Character.valueOf('#'), block.getBase(), Character.valueOf('W'), "slabWood", Character.valueOf('C'), PluginCore.items.tubes.get(EnumElectronTube.TIN, 1), Character.valueOf('I'), "ingotCopper");
            RecipeUtil.addRecipe(gearbox, " # ", "TTT", Character.valueOf('#'), basic, Character.valueOf('T'), "gearTin");
            RecipeUtil.addRecipe(hatch, " # ", "TDT", Character.valueOf('#'), basic, Character.valueOf('T'), "gearTin", Character.valueOf('D'), "trapdoorWood");
            RecipeUtil.addRecipe(valve, " # ", "XTX", Character.valueOf('#'), basic, Character.valueOf('T'), "gearTin", Character.valueOf('X'), "blockGlass");
            RecipeUtil.addRecipe(control, " # ", "XTX", Character.valueOf('#'), basic, Character.valueOf('T'), PluginCore.items.tubes.get(EnumElectronTube.GOLD, 1), Character.valueOf('X'), "dustRedstone");
        }
        ICircuitLayout layoutManaged = ChipsetManager.circuitRegistry.getLayout("forestry.farms.managed");
        ICircuitLayout layoutManual = ChipsetManager.circuitRegistry.getLayout("forestry.farms.manual");
        ChipsetManager.solderManager.addRecipe(layoutManaged, PluginCore.items.tubes.get(EnumElectronTube.COPPER, 1), Circuit.farmArborealManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, PluginCore.items.tubes.get(EnumElectronTube.TIN, 1), Circuit.farmPeatManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, PluginCore.items.tubes.get(EnumElectronTube.BRONZE, 1), Circuit.farmCerealManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, PluginCore.items.tubes.get(EnumElectronTube.IRON, 1), Circuit.farmVegetableManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, PluginCore.items.tubes.get(EnumElectronTube.BLAZE, 1), Circuit.farmInfernalManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, PluginCore.items.tubes.get(EnumElectronTube.APATITE, 1), Circuit.farmShroomManaged);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.COPPER, 1), Circuit.farmOrchardManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.TIN, 1), Circuit.farmPeatManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.BRONZE, 1), Circuit.farmCerealManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.IRON, 1), Circuit.farmVegetableManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.GOLD, 1), Circuit.farmSucculentManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.DIAMOND, 1), Circuit.farmPoalesManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.OBSIDIAN, 1), Circuit.farmGourdManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.APATITE, 1), Circuit.farmShroomManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.LAPIS, 1), Circuit.farmCocoaManual);
    }

    @Override
    public void getHiddenItems(List<ItemStack> hiddenItems) {
        hiddenItems.add(new ItemStack((Block)PluginFarming.blocks.mushroom, 1, Short.MAX_VALUE));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleTextureRemap(TextureStitchEvent.Pre event) {
        EnumFarmBlockType.registerSprites();
    }
}

