/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.lepidopterology.entities;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public abstract class AIButterflyBase extends EntityAIBase {

	protected final EntityButterfly entity;

	protected AIButterflyBase(EntityButterfly entity) {
		this.entity = entity;
	}

	protected Vec3d getRandomDestination() {
		if (entity.func_70090_H()) {
			return getRandomDestinationUpwards();
		}

		Vec3d randomTarget = RandomPositionGenerator.func_75461_b(entity, 16, 7,
				new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));

		if (randomTarget == null) {
			return null;
		}

		if (validateDestination(randomTarget, false)) {
			return randomTarget;
		} else {
			return null;
		}
	}

	protected Vec3d getRandomDestinationUpwards() {
		Vec3d destination = new Vec3d(entity.field_70165_t, entity.field_70163_u + entity.func_70681_au().nextInt(10) + 2, entity.field_70161_v);
		if (validateDestination(destination, true)) {
			return destination;
		} else {
			return null;
		}
	}

	private boolean validateDestination(Vec3d dest, boolean allowFluids) {
		if (dest.field_72448_b < 1) {
			return false;
		}
		BlockPos pos = new BlockPos(dest);
		if (!entity.field_70170_p.func_175667_e(pos)) {
			return false;
		}
		IBlockState blockState = entity.field_70170_p.func_180495_p(pos);
		Block block = blockState.func_177230_c();
		if (!allowFluids && block.func_149688_o(blockState).func_76224_d()) {
			return false;
		}
		if (!block.func_176205_b(entity.field_70170_p, pos)) {
			return false;
		}
		return entity.getButterfly().isAcceptedEnvironment(entity.field_70170_p, dest.field_72450_a, dest.field_72448_b, dest.field_72449_c);
	}

}
